/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.TruncateTokenFilter;
import org.junit.Test;

public class TestTruncateTokenFilter
extends BaseTokenStreamTestCase {
    public void testTruncating() throws Exception {
        MockTokenizer stream = TestTruncateTokenFilter.whitespaceMockTokenizer((String)"abcdefg 1234567 ABCDEFG abcde abc 12345 123");
        stream = new TruncateTokenFilter((TokenStream)stream, 5);
        TestTruncateTokenFilter.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"abcde", "12345", "ABCDE", "abcde", "abc", "12345", "123"});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNonPositiveLength() throws Exception {
        new TruncateTokenFilter((TokenStream)TestTruncateTokenFilter.whitespaceMockTokenizer((String)"length must be a positive number"), -48);
    }
}

