/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestTruncateTokenFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testTruncating() throws Exception {
        StringReader reader = new StringReader("abcdefg 1234567 ABCDEFG abcde abc 12345 123");
        MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)stream).setReader((Reader)reader);
        stream = this.tokenFilterFactory("Truncate", "prefixLength", "5").create((TokenStream)stream);
        TestTruncateTokenFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"abcde", "12345", "ABCDE", "abcde", "abc", "12345", "123"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestTruncateTokenFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("Truncate", "prefixLength", "5", "bogusArg", "bogusValue"));
        TestTruncateTokenFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameter(s):"));
    }

    public void testNonPositivePrefixLengthArgument() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestTruncateTokenFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("Truncate", "prefixLength", "-5"));
        TestTruncateTokenFilterFactory.assertTrue((boolean)expected.getMessage().contains("prefixLength parameter must be a positive number: -5"));
    }
}

