/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CannedTokenStream;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterIterator;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.IOUtils;
import org.junit.Test;

public class TestWordDelimiterFilter
extends BaseTokenStreamTestCase {
    @Test
    public void testOffsets() throws IOException {
        int flags = 467;
        WordDelimiterFilter wdf = new WordDelimiterFilter((TokenStream)new CannedTokenStream(new Token[]{new Token((CharSequence)"foo-bar", 5, 12)}), WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, flags, null);
        TestWordDelimiterFilter.assertTokenStreamContents((TokenStream)wdf, (String[])new String[]{"foo", "foobar", "bar"}, (int[])new int[]{5, 5, 9}, (int[])new int[]{8, 12, 12});
        wdf = new WordDelimiterFilter((TokenStream)new CannedTokenStream(new Token[]{new Token((CharSequence)"foo-bar", 5, 6)}), WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, flags, null);
        TestWordDelimiterFilter.assertTokenStreamContents((TokenStream)wdf, (String[])new String[]{"foo", "bar", "foobar"}, (int[])new int[]{5, 5, 5}, (int[])new int[]{6, 6, 6});
    }

    @Test
    public void testOffsetChange() throws Exception {
        int flags = 467;
        WordDelimiterFilter wdf = new WordDelimiterFilter((TokenStream)new CannedTokenStream(new Token[]{new Token((CharSequence)"\u00fcbelkeit)", 7, 16)}), WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, flags, null);
        TestWordDelimiterFilter.assertTokenStreamContents((TokenStream)wdf, (String[])new String[]{"\u00fcbelkeit"}, (int[])new int[]{7}, (int[])new int[]{15});
    }

    @Test
    public void testOffsetChange2() throws Exception {
        int flags = 467;
        WordDelimiterFilter wdf = new WordDelimiterFilter((TokenStream)new CannedTokenStream(new Token[]{new Token((CharSequence)"(\u00fcbelkeit", 7, 17)}), WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, flags, null);
        TestWordDelimiterFilter.assertTokenStreamContents((TokenStream)wdf, (String[])new String[]{"\u00fcbelkeit"}, (int[])new int[]{8}, (int[])new int[]{17});
    }

    @Test
    public void testOffsetChange3() throws Exception {
        int flags = 467;
        WordDelimiterFilter wdf = new WordDelimiterFilter((TokenStream)new CannedTokenStream(new Token[]{new Token((CharSequence)"(\u00fcbelkeit", 7, 16)}), WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, flags, null);
        TestWordDelimiterFilter.assertTokenStreamContents((TokenStream)wdf, (String[])new String[]{"\u00fcbelkeit"}, (int[])new int[]{8}, (int[])new int[]{16});
    }

    @Test
    public void testOffsetChange4() throws Exception {
        int flags = 467;
        WordDelimiterFilter wdf = new WordDelimiterFilter((TokenStream)new CannedTokenStream(new Token[]{new Token((CharSequence)"(foo,bar)", 7, 16)}), WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, flags, null);
        TestWordDelimiterFilter.assertTokenStreamContents((TokenStream)wdf, (String[])new String[]{"foo", "foobar", "bar"}, (int[])new int[]{8, 8, 12}, (int[])new int[]{11, 15, 15});
    }

    public void doSplit(String input, String ... output) throws Exception {
        int flags = 451;
        WordDelimiterFilter wdf = new WordDelimiterFilter((TokenStream)TestWordDelimiterFilter.keywordMockTokenizer((String)input), WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, flags, null);
        TestWordDelimiterFilter.assertTokenStreamContents((TokenStream)wdf, (String[])output);
    }

    @Test
    public void testSplits() throws Exception {
        this.doSplit("basic-split", "basic", "split");
        this.doSplit("camelCase", "camel", "Case");
        this.doSplit("\u0e1a\u0e49\u0e32\u0e19", "\u0e1a\u0e49\u0e32\u0e19");
        this.doSplit("test's'", "test");
        this.doSplit("\u0420\u043e\u0431\u0435\u0440\u0442", "\u0420\u043e\u0431\u0435\u0440\u0442");
        this.doSplit("\u0420\u043e\u0431\u0415\u0440\u0442", "\u0420\u043e\u0431", "\u0415\u0440\u0442");
        this.doSplit("a\u01c5ungla", "a\u01c5ungla");
        this.doSplit("\u0633\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0644\u0627\u0645", "\u0633\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0644\u0627\u0645");
        this.doSplit("test\u20dd", "test\u20dd");
        this.doSplit("\u0939\u093f\u0928\u094d\u0926\u0940", "\u0939\u093f\u0928\u094d\u0926\u0940");
        this.doSplit("\u0661\u0662\u0663\u0664", "\u0661\u0662\u0663\u0664");
        this.doSplit("\ud840\udc00\ud840\udc00", "\ud840\udc00\ud840\udc00");
    }

    public void doSplitPossessive(int stemPossessive, String input, String ... output) throws Exception {
        int flags = 195;
        WordDelimiterFilter wdf = new WordDelimiterFilter((TokenStream)TestWordDelimiterFilter.keywordMockTokenizer((String)input), flags |= stemPossessive == 1 ? 256 : 0, null);
        TestWordDelimiterFilter.assertTokenStreamContents((TokenStream)wdf, (String[])output);
    }

    @Test
    public void testPossessives() throws Exception {
        this.doSplitPossessive(1, "ra's", "ra");
        this.doSplitPossessive(0, "ra's", "ra", "s");
    }

    @Test
    public void testPositionIncrements() throws Exception {
        int flags = 467;
        final CharArraySet protWords = new CharArraySet(new HashSet<String>(Arrays.asList("NUTCH")), false);
        Analyzer a = new Analyzer(){

            public Analyzer.TokenStreamComponents createComponents(String field) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new WordDelimiterFilter((TokenStream)tokenizer, 467, protWords));
            }
        };
        TestWordDelimiterFilter.assertAnalyzesTo((Analyzer)a, (String)"LUCENE / SOLR", (String[])new String[]{"LUCENE", "SOLR"}, (int[])new int[]{0, 9}, (int[])new int[]{6, 13}, null, (int[])new int[]{1, 1}, null, (boolean)false);
        TestWordDelimiterFilter.assertAnalyzesTo((Analyzer)a, (String)"LUCENE / solR", (String[])new String[]{"LUCENE", "sol", "solR", "R"}, (int[])new int[]{0, 9, 9, 12}, (int[])new int[]{6, 12, 13, 13}, null, (int[])new int[]{1, 1, 0, 1}, null, (boolean)false);
        TestWordDelimiterFilter.assertAnalyzesTo((Analyzer)a, (String)"LUCENE / NUTCH SOLR", (String[])new String[]{"LUCENE", "NUTCH", "SOLR"}, (int[])new int[]{0, 9, 15}, (int[])new int[]{6, 14, 19}, null, (int[])new int[]{1, 1, 1}, null, (boolean)false);
        Analyzer a2 = new Analyzer(){

            public Analyzer.TokenStreamComponents createComponents(String field) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new WordDelimiterFilter((TokenStream)new LargePosIncTokenFilter((TokenStream)tokenizer), 467, protWords));
            }
        };
        TestWordDelimiterFilter.assertAnalyzesTo((Analyzer)a2, (String)"LUCENE largegap SOLR", (String[])new String[]{"LUCENE", "largegap", "SOLR"}, (int[])new int[]{0, 7, 16}, (int[])new int[]{6, 15, 20}, null, (int[])new int[]{1, 10, 1}, null, (boolean)false);
        TestWordDelimiterFilter.assertAnalyzesTo((Analyzer)a2, (String)"LUCENE / SOLR", (String[])new String[]{"LUCENE", "SOLR"}, (int[])new int[]{0, 9}, (int[])new int[]{6, 13}, null, (int[])new int[]{1, 11}, null, (boolean)false);
        TestWordDelimiterFilter.assertAnalyzesTo((Analyzer)a2, (String)"LUCENE / solR", (String[])new String[]{"LUCENE", "sol", "solR", "R"}, (int[])new int[]{0, 9, 9, 12}, (int[])new int[]{6, 12, 13, 13}, null, (int[])new int[]{1, 11, 0, 1}, null, (boolean)false);
        TestWordDelimiterFilter.assertAnalyzesTo((Analyzer)a2, (String)"LUCENE / NUTCH SOLR", (String[])new String[]{"LUCENE", "NUTCH", "SOLR"}, (int[])new int[]{0, 9, 15}, (int[])new int[]{6, 14, 19}, null, (int[])new int[]{1, 11, 1}, null, (boolean)false);
        Analyzer a3 = new Analyzer(){

            public Analyzer.TokenStreamComponents createComponents(String field) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                StopFilter filter = new StopFilter((TokenStream)tokenizer, StandardAnalyzer.STOP_WORDS_SET);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new WordDelimiterFilter((TokenStream)filter, 467, protWords));
            }
        };
        TestWordDelimiterFilter.assertAnalyzesTo((Analyzer)a3, (String)"lucene.solr", (String[])new String[]{"lucene", "lucenesolr", "solr"}, (int[])new int[]{0, 0, 7}, (int[])new int[]{6, 11, 11}, null, (int[])new int[]{1, 0, 1}, null, (boolean)false);
        TestWordDelimiterFilter.assertAnalyzesTo((Analyzer)a3, (String)"the lucene.solr", (String[])new String[]{"lucene", "lucenesolr", "solr"}, (int[])new int[]{4, 4, 11}, (int[])new int[]{10, 15, 15}, null, (int[])new int[]{2, 0, 1}, null, (boolean)false);
        IOUtils.close((Closeable[])new Closeable[]{a, a2, a3});
    }

    public void testLotsOfConcatenating() throws Exception {
        int flags = 479;
        Analyzer a = new Analyzer(){

            public Analyzer.TokenStreamComponents createComponents(String field) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new WordDelimiterFilter((TokenStream)tokenizer, 479, null));
            }
        };
        TestWordDelimiterFilter.assertAnalyzesTo((Analyzer)a, (String)"abc-def-123-456", (String[])new String[]{"abc", "abcdef", "abcdef123456", "def", "123", "123456", "456"}, (int[])new int[]{0, 0, 0, 4, 8, 8, 12}, (int[])new int[]{3, 7, 15, 7, 11, 15, 15}, null, (int[])new int[]{1, 0, 0, 1, 1, 0, 1}, null, (boolean)false);
        a.close();
    }

    public void testLotsOfConcatenating2() throws Exception {
        int flags = 511;
        Analyzer a = new Analyzer(){

            public Analyzer.TokenStreamComponents createComponents(String field) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new WordDelimiterFilter((TokenStream)tokenizer, 511, null));
            }
        };
        TestWordDelimiterFilter.assertAnalyzesTo((Analyzer)a, (String)"abc-def-123-456", (String[])new String[]{"abc-def-123-456", "abc", "abcdef", "abcdef123456", "def", "123", "123456", "456"}, (int[])new int[]{0, 0, 0, 0, 4, 8, 8, 12}, (int[])new int[]{15, 3, 7, 15, 7, 11, 15, 15}, null, (int[])new int[]{1, 0, 0, 0, 1, 1, 0, 1}, null, (boolean)false);
        a.close();
    }

    public void testRandomStrings() throws Exception {
        int numIterations = TestWordDelimiterFilter.atLeast((int)5);
        for (int i = 0; i < numIterations; ++i) {
            final int flags = TestWordDelimiterFilter.random().nextInt(512);
            final CharArraySet protectedWords = TestWordDelimiterFilter.random().nextBoolean() ? new CharArraySet(new HashSet<String>(Arrays.asList("a", "b", "cd")), false) : null;
            Analyzer a = new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                    return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new WordDelimiterFilter((TokenStream)tokenizer, flags, protectedWords));
                }
            };
            TestWordDelimiterFilter.checkRandomData((Random)TestWordDelimiterFilter.random(), (Analyzer)a, (int)(200 * RANDOM_MULTIPLIER), (int)20, (boolean)false, (boolean)false);
            a.close();
        }
    }

    public void testRandomHugeStrings() throws Exception {
        int numIterations = TestWordDelimiterFilter.atLeast((int)5);
        for (int i = 0; i < numIterations; ++i) {
            final int flags = TestWordDelimiterFilter.random().nextInt(512);
            final CharArraySet protectedWords = TestWordDelimiterFilter.random().nextBoolean() ? new CharArraySet(new HashSet<String>(Arrays.asList("a", "b", "cd")), false) : null;
            Analyzer a = new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                    return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new WordDelimiterFilter((TokenStream)tokenizer, flags, protectedWords));
                }
            };
            TestWordDelimiterFilter.checkRandomData((Random)TestWordDelimiterFilter.random(), (Analyzer)a, (int)(20 * RANDOM_MULTIPLIER), (int)8192, (boolean)false, (boolean)false);
            a.close();
        }
    }

    public void testEmptyTerm() throws IOException {
        Random random = TestWordDelimiterFilter.random();
        for (int i = 0; i < 512; ++i) {
            final int flags = i;
            final CharArraySet protectedWords = random.nextBoolean() ? new CharArraySet(new HashSet<String>(Arrays.asList("a", "b", "cd")), false) : null;
            Analyzer a = new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    KeywordTokenizer tokenizer = new KeywordTokenizer();
                    return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new WordDelimiterFilter((TokenStream)tokenizer, flags, protectedWords));
                }
            };
            TestWordDelimiterFilter.checkAnalysisConsistency((Random)random, (Analyzer)a, (boolean)random.nextBoolean(), (String)"");
            a.close();
        }
    }

    public void testOnlyNumbers() throws Exception {
        final int flags = 193;
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new WordDelimiterFilter((TokenStream)tokenizer, flags, null));
            }
        };
        TestWordDelimiterFilter.assertAnalyzesTo((Analyzer)a, (String)"7-586", (String[])new String[0], (int[])new int[0], (int[])new int[0], null, (int[])new int[0], null, (boolean)false);
    }

    public void testNumberPunct() throws Exception {
        final int flags = 193;
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new WordDelimiterFilter((TokenStream)tokenizer, flags, null));
            }
        };
        TestWordDelimiterFilter.assertAnalyzesTo((Analyzer)a, (String)"6-", (String[])new String[]{"6"}, (int[])new int[]{0}, (int[])new int[]{1}, null, (int[])new int[]{1}, null, (boolean)false);
    }

    private Analyzer getAnalyzer(final int flags) {
        return new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new WordDelimiterFilter((TokenStream)tokenizer, flags, null));
            }
        };
    }

    private static final class LargePosIncTokenFilter
    extends TokenFilter {
        private CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);

        protected LargePosIncTokenFilter(TokenStream input) {
            super(input);
        }

        public boolean incrementToken() throws IOException {
            if (this.input.incrementToken()) {
                if (this.termAtt.toString().equals("largegap") || this.termAtt.toString().equals("/")) {
                    this.posIncAtt.setPositionIncrement(10);
                }
                return true;
            }
            return false;
        }
    }
}

