/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CannedTokenStream;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterGraphFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterIterator;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.TestUtil;

public class TestWordDelimiterGraphFilter
extends BaseTokenStreamTestCase {
    private static final int NUMBER = 0;
    private static final int LETTER = 1;
    private static final int DELIM = 2;

    public void testOffsets() throws IOException {
        int flags = 467;
        WordDelimiterGraphFilter wdf = new WordDelimiterGraphFilter((TokenStream)new CannedTokenStream(new Token[]{new Token((CharSequence)"foo-bar", 5, 12)}), WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, flags, null);
        TestWordDelimiterGraphFilter.assertTokenStreamContents((TokenStream)wdf, (String[])new String[]{"foobar", "foo", "bar"}, (int[])new int[]{5, 5, 9}, (int[])new int[]{12, 8, 12});
        wdf = new WordDelimiterGraphFilter((TokenStream)new CannedTokenStream(new Token[]{new Token((CharSequence)"foo-bar", 5, 6)}), WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, flags, null);
        TestWordDelimiterGraphFilter.assertTokenStreamContents((TokenStream)wdf, (String[])new String[]{"foobar", "foo", "bar"}, (int[])new int[]{5, 5, 5}, (int[])new int[]{6, 6, 6});
    }

    public void testOffsetChange() throws Exception {
        int flags = 467;
        WordDelimiterGraphFilter wdf = new WordDelimiterGraphFilter((TokenStream)new CannedTokenStream(new Token[]{new Token((CharSequence)"\u00fcbelkeit)", 7, 16)}), WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, flags, null);
        TestWordDelimiterGraphFilter.assertTokenStreamContents((TokenStream)wdf, (String[])new String[]{"\u00fcbelkeit"}, (int[])new int[]{7}, (int[])new int[]{15});
    }

    public void testOffsetChange2() throws Exception {
        int flags = 467;
        WordDelimiterGraphFilter wdf = new WordDelimiterGraphFilter((TokenStream)new CannedTokenStream(new Token[]{new Token((CharSequence)"(\u00fcbelkeit", 7, 17)}), WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, flags, null);
        TestWordDelimiterGraphFilter.assertTokenStreamContents((TokenStream)wdf, (String[])new String[]{"\u00fcbelkeit"}, (int[])new int[]{7}, (int[])new int[]{17});
    }

    public void testOffsetChange3() throws Exception {
        int flags = 467;
        WordDelimiterGraphFilter wdf = new WordDelimiterGraphFilter((TokenStream)new CannedTokenStream(new Token[]{new Token((CharSequence)"(\u00fcbelkeit", 7, 16)}), WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, flags, null);
        TestWordDelimiterGraphFilter.assertTokenStreamContents((TokenStream)wdf, (String[])new String[]{"\u00fcbelkeit"}, (int[])new int[]{8}, (int[])new int[]{16});
    }

    public void testOffsetChange4() throws Exception {
        int flags = 467;
        WordDelimiterGraphFilter wdf = new WordDelimiterGraphFilter((TokenStream)new CannedTokenStream(new Token[]{new Token((CharSequence)"(foo,bar)", 7, 16)}), WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, flags, null);
        TestWordDelimiterGraphFilter.assertTokenStreamContents((TokenStream)wdf, (String[])new String[]{"foobar", "foo", "bar"}, (int[])new int[]{8, 8, 12}, (int[])new int[]{15, 11, 15});
    }

    public void doSplit(String input, String ... output) throws Exception {
        int flags = 451;
        WordDelimiterGraphFilter wdf = new WordDelimiterGraphFilter((TokenStream)TestWordDelimiterGraphFilter.keywordMockTokenizer((String)input), WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, flags, null);
        TestWordDelimiterGraphFilter.assertTokenStreamContents((TokenStream)wdf, (String[])output);
    }

    public void testSplits() throws Exception {
        this.doSplit("basic-split", "basic", "split");
        this.doSplit("camelCase", "camel", "Case");
        this.doSplit("\u0e1a\u0e49\u0e32\u0e19", "\u0e1a\u0e49\u0e32\u0e19");
        this.doSplit("test's'", "test");
        this.doSplit("\u0420\u043e\u0431\u0435\u0440\u0442", "\u0420\u043e\u0431\u0435\u0440\u0442");
        this.doSplit("\u0420\u043e\u0431\u0415\u0440\u0442", "\u0420\u043e\u0431", "\u0415\u0440\u0442");
        this.doSplit("a\u01c5ungla", "a\u01c5ungla");
        this.doSplit("\u0633\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0644\u0627\u0645", "\u0633\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0640\u0644\u0627\u0645");
        this.doSplit("test\u20dd", "test\u20dd");
        this.doSplit("\u0939\u093f\u0928\u094d\u0926\u0940", "\u0939\u093f\u0928\u094d\u0926\u0940");
        this.doSplit("\u0661\u0662\u0663\u0664", "\u0661\u0662\u0663\u0664");
        this.doSplit("\ud840\udc00\ud840\udc00", "\ud840\udc00\ud840\udc00");
    }

    public void doSplitPossessive(int stemPossessive, String input, String ... output) throws Exception {
        int flags = 195;
        WordDelimiterGraphFilter wdf = new WordDelimiterGraphFilter((TokenStream)TestWordDelimiterGraphFilter.keywordMockTokenizer((String)input), flags |= stemPossessive == 1 ? 256 : 0, null);
        TestWordDelimiterGraphFilter.assertTokenStreamContents((TokenStream)wdf, (String[])output);
    }

    public void testPossessives() throws Exception {
        this.doSplitPossessive(1, "ra's", "ra");
        this.doSplitPossessive(0, "ra's", "ra", "s");
    }

    public void testTokenType() throws Exception {
        int flags = 467;
        Token token = new Token((CharSequence)"foo-bar", 5, 12);
        token.setType("mytype");
        WordDelimiterGraphFilter wdf = new WordDelimiterGraphFilter((TokenStream)new CannedTokenStream(new Token[]{token}), WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, flags, null);
        TestWordDelimiterGraphFilter.assertTokenStreamContents((TokenStream)wdf, (String[])new String[]{"foobar", "foo", "bar"}, (String[])new String[]{"mytype", "mytype", "mytype"});
    }

    public void testPositionIncrements() throws Exception {
        int flags = 467;
        final CharArraySet protWords = new CharArraySet(new HashSet<String>(Arrays.asList("NUTCH")), false);
        Analyzer a = new Analyzer(){

            public Analyzer.TokenStreamComponents createComponents(String field) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new WordDelimiterGraphFilter((TokenStream)tokenizer, 467, protWords));
            }
        };
        TestWordDelimiterGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"LUCENE / SOLR", (String[])new String[]{"LUCENE", "SOLR"}, (int[])new int[]{0, 9}, (int[])new int[]{6, 13}, null, (int[])new int[]{1, 2}, null, (boolean)false);
        TestWordDelimiterGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"LUCENE / solR", (String[])new String[]{"LUCENE", "solR", "sol", "R"}, (int[])new int[]{0, 9, 9, 12}, (int[])new int[]{6, 13, 12, 13}, null, (int[])new int[]{1, 2, 0, 1}, null, (boolean)false);
        TestWordDelimiterGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"LUCENE / NUTCH SOLR", (String[])new String[]{"LUCENE", "NUTCH", "SOLR"}, (int[])new int[]{0, 9, 15}, (int[])new int[]{6, 14, 19}, null, (int[])new int[]{1, 2, 1}, null, (boolean)false);
        Analyzer a2 = new Analyzer(){

            public Analyzer.TokenStreamComponents createComponents(String field) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new WordDelimiterGraphFilter((TokenStream)new LargePosIncTokenFilter((TokenStream)tokenizer), 467, protWords));
            }
        };
        TestWordDelimiterGraphFilter.assertAnalyzesTo((Analyzer)a2, (String)"LUCENE largegap SOLR", (String[])new String[]{"LUCENE", "largegap", "SOLR"}, (int[])new int[]{0, 7, 16}, (int[])new int[]{6, 15, 20}, null, (int[])new int[]{1, 10, 1}, null, (boolean)false);
        TestWordDelimiterGraphFilter.assertAnalyzesTo((Analyzer)a2, (String)"LUCENE / SOLR", (String[])new String[]{"LUCENE", "SOLR"}, (int[])new int[]{0, 9}, (int[])new int[]{6, 13}, null, (int[])new int[]{1, 11}, null, (boolean)false);
        TestWordDelimiterGraphFilter.assertAnalyzesTo((Analyzer)a2, (String)"LUCENE / solR", (String[])new String[]{"LUCENE", "solR", "sol", "R"}, (int[])new int[]{0, 9, 9, 12}, (int[])new int[]{6, 13, 12, 13}, null, (int[])new int[]{1, 11, 0, 1}, null, (boolean)false);
        TestWordDelimiterGraphFilter.assertAnalyzesTo((Analyzer)a2, (String)"LUCENE / NUTCH SOLR", (String[])new String[]{"LUCENE", "NUTCH", "SOLR"}, (int[])new int[]{0, 9, 15}, (int[])new int[]{6, 14, 19}, null, (int[])new int[]{1, 11, 1}, null, (boolean)false);
        Analyzer a3 = new Analyzer(){

            public Analyzer.TokenStreamComponents createComponents(String field) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                StopFilter filter = new StopFilter((TokenStream)tokenizer, StandardAnalyzer.STOP_WORDS_SET);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new WordDelimiterGraphFilter((TokenStream)filter, 467, protWords));
            }
        };
        TestWordDelimiterGraphFilter.assertAnalyzesTo((Analyzer)a3, (String)"lucene.solr", (String[])new String[]{"lucenesolr", "lucene", "solr"}, (int[])new int[]{0, 0, 7}, (int[])new int[]{11, 6, 11}, null, (int[])new int[]{1, 0, 1}, null, (boolean)false);
        TestWordDelimiterGraphFilter.assertAnalyzesTo((Analyzer)a3, (String)"the lucene.solr", (String[])new String[]{"lucenesolr", "lucene", "solr"}, (int[])new int[]{4, 4, 11}, (int[])new int[]{15, 10, 15}, null, (int[])new int[]{2, 0, 1}, null, (boolean)false);
        IOUtils.close((Closeable[])new Closeable[]{a, a2, a3});
    }

    public void testLotsOfConcatenating() throws Exception {
        int flags = 479;
        Analyzer a = new Analyzer(){

            public Analyzer.TokenStreamComponents createComponents(String field) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new WordDelimiterGraphFilter((TokenStream)tokenizer, 479, null));
            }
        };
        TestWordDelimiterGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"abc-def-123-456", (String[])new String[]{"abcdef123456", "abcdef", "abc", "def", "123456", "123", "456"}, (int[])new int[]{0, 0, 0, 4, 8, 8, 12}, (int[])new int[]{15, 7, 3, 7, 15, 11, 15}, null, (int[])new int[]{1, 0, 0, 1, 1, 0, 1}, null, (boolean)false);
        a.close();
    }

    public void testLotsOfConcatenating2() throws Exception {
        int flags = 511;
        Analyzer a = new Analyzer(){

            public Analyzer.TokenStreamComponents createComponents(String field) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new WordDelimiterGraphFilter((TokenStream)tokenizer, 511, null));
            }
        };
        TestWordDelimiterGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"abc-def-123-456", (String[])new String[]{"abcdef123456", "abc-def-123-456", "abcdef", "abc", "def", "123456", "123", "456"}, (int[])new int[]{0, 0, 0, 0, 4, 8, 8, 12}, (int[])new int[]{15, 15, 7, 3, 7, 15, 11, 15}, null, (int[])new int[]{1, 0, 0, 0, 1, 1, 0, 1}, null, (boolean)false);
        a.close();
    }

    public void testRandomStrings() throws Exception {
        int numIterations = TestWordDelimiterGraphFilter.atLeast((int)5);
        for (int i = 0; i < numIterations; ++i) {
            final int flags = TestWordDelimiterGraphFilter.random().nextInt(512);
            final CharArraySet protectedWords = TestWordDelimiterGraphFilter.random().nextBoolean() ? new CharArraySet(new HashSet<String>(Arrays.asList("a", "b", "cd")), false) : null;
            Analyzer a = new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                    return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new WordDelimiterGraphFilter((TokenStream)tokenizer, flags, protectedWords));
                }
            };
            TestWordDelimiterGraphFilter.checkRandomData((Random)TestWordDelimiterGraphFilter.random(), (Analyzer)a, (int)(200 * RANDOM_MULTIPLIER), (int)20, (boolean)false, (boolean)false);
            a.close();
        }
    }

    public void testRandomHugeStrings() throws Exception {
        int numIterations = TestWordDelimiterGraphFilter.atLeast((int)5);
        for (int i = 0; i < numIterations; ++i) {
            final int flags = TestWordDelimiterGraphFilter.random().nextInt(512);
            final CharArraySet protectedWords = TestWordDelimiterGraphFilter.random().nextBoolean() ? new CharArraySet(new HashSet<String>(Arrays.asList("a", "b", "cd")), false) : null;
            Analyzer a = new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                    WordDelimiterGraphFilter wdgf = new WordDelimiterGraphFilter((TokenStream)tokenizer, flags, protectedWords);
                    return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)wdgf);
                }
            };
            TestWordDelimiterGraphFilter.checkRandomData((Random)TestWordDelimiterGraphFilter.random(), (Analyzer)a, (int)(20 * RANDOM_MULTIPLIER), (int)8192, (boolean)false, (boolean)false);
            a.close();
        }
    }

    public void testEmptyTerm() throws IOException {
        Random random = TestWordDelimiterGraphFilter.random();
        for (int i = 0; i < 512; ++i) {
            final int flags = i;
            final CharArraySet protectedWords = random.nextBoolean() ? new CharArraySet(new HashSet<String>(Arrays.asList("a", "b", "cd")), false) : null;
            Analyzer a = new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    KeywordTokenizer tokenizer = new KeywordTokenizer();
                    return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new WordDelimiterGraphFilter((TokenStream)tokenizer, flags, protectedWords));
                }
            };
            TestWordDelimiterGraphFilter.checkAnalysisConsistency((Random)random, (Analyzer)a, (boolean)random.nextBoolean(), (String)"");
            a.close();
        }
    }

    private Analyzer getAnalyzer(int flags) {
        return this.getAnalyzer(flags, null);
    }

    private Analyzer getAnalyzer(final int flags, final CharArraySet protectedWords) {
        return new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new WordDelimiterGraphFilter((TokenStream)tokenizer, flags, protectedWords));
            }
        };
    }

    private static boolean has(int flags, int flag) {
        return (flags & flag) != 0;
    }

    private static boolean isEnglishPossessive(String text, int pos) {
        if (!(pos <= 2 || text.charAt(pos - 1) != 's' && text.charAt(pos - 1) != 'S' || pos != text.length() && text.charAt(pos) == '-')) {
            text = text.substring(0, text.length() - 2);
        }
        return true;
    }

    private static int toType(char ch) {
        if (Character.isDigit(ch)) {
            return 0;
        }
        if (Character.isLetter(ch)) {
            return 1;
        }
        return 2;
    }

    private Set<String> slowWDF(String text, int flags) {
        ArrayList<WordPart> wordParts = new ArrayList<WordPart>();
        int lastCH = -1;
        int wordPartStart = 0;
        boolean inToken = false;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (TestWordDelimiterGraphFilter.toType(ch) == 2) {
                if (inToken) {
                    wordParts.add(new WordPart(text, wordPartStart, i));
                    inToken = false;
                }
                if (!(!TestWordDelimiterGraphFilter.has(flags, 256) || ch != '\'' || i <= 0 || i >= text.length() - 1 || text.charAt(i + 1) != 's' && text.charAt(i + 1) != 'S' || TestWordDelimiterGraphFilter.toType(text.charAt(i - 1)) != 1 || i + 2 != text.length() && TestWordDelimiterGraphFilter.toType(text.charAt(i + 2)) != 2)) {
                    i += 2;
                }
            } else if (!inToken) {
                inToken = true;
                wordPartStart = i;
            } else {
                boolean newToken = false;
                if (Character.isLetter(lastCH)) {
                    if (Character.isLetter(ch)) {
                        if (TestWordDelimiterGraphFilter.has(flags, 64) && Character.isLowerCase(lastCH) && !Character.isLowerCase(ch)) {
                            newToken = true;
                        }
                    } else if (TestWordDelimiterGraphFilter.has(flags, 128) && Character.isDigit(ch)) {
                        newToken = true;
                    }
                } else {
                    assert (Character.isDigit(lastCH));
                    if (Character.isLetter(ch) && TestWordDelimiterGraphFilter.has(flags, 128)) {
                        newToken = true;
                    }
                }
                if (newToken) {
                    wordParts.add(new WordPart(text, wordPartStart, i));
                    wordPartStart = i;
                }
            }
            lastCH = ch;
        }
        if (inToken) {
            wordParts.add(new WordPart(text, wordPartStart, text.length()));
        }
        HashSet<String> paths = new HashSet<String>();
        if (!wordParts.isEmpty()) {
            this.enumerate(flags, 0, text, wordParts, paths, new StringBuilder());
        }
        if (TestWordDelimiterGraphFilter.has(flags, 32)) {
            paths.add(text);
        }
        if (TestWordDelimiterGraphFilter.has(flags, 16) && !wordParts.isEmpty()) {
            StringBuilder b = new StringBuilder();
            for (WordPart wordPart : wordParts) {
                b.append(wordPart.part);
            }
            paths.add(b.toString());
        }
        return paths;
    }

    private void add(StringBuilder path, String part) {
        if (path.length() != 0) {
            path.append(' ');
        }
        path.append(part);
    }

    private void add(StringBuilder path, List<WordPart> wordParts, int from, int to) {
        if (path.length() != 0) {
            path.append(' ');
        }
        for (int i = from; i < to; ++i) {
            path.append(wordParts.get((int)i).part);
        }
    }

    private void addWithSpaces(StringBuilder path, List<WordPart> wordParts, int from, int to) {
        for (int i = from; i < to; ++i) {
            this.add(path, wordParts.get((int)i).part);
        }
    }

    private int endOfRun(List<WordPart> wordParts, int start) {
        int upto;
        for (upto = start + 1; upto < wordParts.size() && wordParts.get((int)upto).type == wordParts.get((int)start).type; ++upto) {
        }
        return upto;
    }

    private void enumerate(int flags, int upto, String text, List<WordPart> wordParts, Set<String> paths, StringBuilder path) {
        if (upto == wordParts.size()) {
            if (path.length() > 0) {
                paths.add(path.toString());
            }
        } else {
            int savLength = path.length();
            int end = this.endOfRun(wordParts, upto);
            if (wordParts.get((int)upto).type == 0) {
                if (TestWordDelimiterGraphFilter.has(flags, 2) || wordParts.size() == 1) {
                    this.addWithSpaces(path, wordParts, upto, end);
                    if (TestWordDelimiterGraphFilter.has(flags, 8)) {
                        this.enumerate(flags, end, text, wordParts, paths, path);
                        path.setLength(savLength);
                        this.add(path, wordParts, upto, end);
                    }
                } else if (TestWordDelimiterGraphFilter.has(flags, 8)) {
                    this.add(path, wordParts, upto, end);
                }
                this.enumerate(flags, end, text, wordParts, paths, path);
                path.setLength(savLength);
            } else {
                assert (wordParts.get((int)upto).type == 1);
                if (TestWordDelimiterGraphFilter.has(flags, 1) || wordParts.size() == 1) {
                    this.addWithSpaces(path, wordParts, upto, end);
                    if (TestWordDelimiterGraphFilter.has(flags, 4)) {
                        this.enumerate(flags, end, text, wordParts, paths, path);
                        path.setLength(savLength);
                        this.add(path, wordParts, upto, end);
                    }
                } else if (TestWordDelimiterGraphFilter.has(flags, 4)) {
                    this.add(path, wordParts, upto, end);
                }
                this.enumerate(flags, end, text, wordParts, paths, path);
                path.setLength(savLength);
            }
        }
    }

    public void testBasicGraphSplits() throws Exception {
        TestWordDelimiterGraphFilter.assertGraphStrings((Analyzer)this.getAnalyzer(0), (String)"PowerShotPlus", (String[])new String[]{"PowerShotPlus"});
        TestWordDelimiterGraphFilter.assertGraphStrings((Analyzer)this.getAnalyzer(1), (String)"PowerShotPlus", (String[])new String[]{"PowerShotPlus"});
        TestWordDelimiterGraphFilter.assertGraphStrings((Analyzer)this.getAnalyzer(65), (String)"PowerShotPlus", (String[])new String[]{"Power Shot Plus"});
        TestWordDelimiterGraphFilter.assertGraphStrings((Analyzer)this.getAnalyzer(97), (String)"PowerShotPlus", (String[])new String[]{"PowerShotPlus", "Power Shot Plus"});
        TestWordDelimiterGraphFilter.assertGraphStrings((Analyzer)this.getAnalyzer(1), (String)"Power-Shot-Plus", (String[])new String[]{"Power Shot Plus"});
        TestWordDelimiterGraphFilter.assertGraphStrings((Analyzer)this.getAnalyzer(65), (String)"Power-Shot-Plus", (String[])new String[]{"Power Shot Plus"});
        TestWordDelimiterGraphFilter.assertGraphStrings((Analyzer)this.getAnalyzer(97), (String)"Power-Shot-Plus", (String[])new String[]{"Power-Shot-Plus", "Power Shot Plus"});
        TestWordDelimiterGraphFilter.assertGraphStrings((Analyzer)this.getAnalyzer(65), (String)"PowerShotPlus", (String[])new String[]{"Power Shot Plus"});
        TestWordDelimiterGraphFilter.assertGraphStrings((Analyzer)this.getAnalyzer(65), (String)"PowerShot1000Plus", (String[])new String[]{"Power Shot1000Plus"});
        TestWordDelimiterGraphFilter.assertGraphStrings((Analyzer)this.getAnalyzer(65), (String)"Power-Shot-Plus", (String[])new String[]{"Power Shot Plus"});
        TestWordDelimiterGraphFilter.assertGraphStrings((Analyzer)this.getAnalyzer(69), (String)"PowerShotPlus", (String[])new String[]{"Power Shot Plus", "PowerShotPlus"});
        TestWordDelimiterGraphFilter.assertGraphStrings((Analyzer)this.getAnalyzer(69), (String)"PowerShot1000Plus", (String[])new String[]{"Power Shot1000Plus", "PowerShot1000Plus"});
        TestWordDelimiterGraphFilter.assertGraphStrings((Analyzer)this.getAnalyzer(79), (String)"Power-Shot-1000-17-Plus", (String[])new String[]{"Power Shot 1000 17 Plus", "Power Shot 100017 Plus", "PowerShot 1000 17 Plus", "PowerShot 100017 Plus"});
        TestWordDelimiterGraphFilter.assertGraphStrings((Analyzer)this.getAnalyzer(111), (String)"Power-Shot-1000-17-Plus", (String[])new String[]{"Power-Shot-1000-17-Plus", "Power Shot 1000 17 Plus", "Power Shot 100017 Plus", "PowerShot 1000 17 Plus", "PowerShot 100017 Plus"});
    }

    private String randomWDFText() {
        StringBuilder b = new StringBuilder();
        int length = TestUtil.nextInt((Random)TestWordDelimiterGraphFilter.random(), (int)1, (int)50);
        for (int i = 0; i < length; ++i) {
            int surpriseMe = TestWordDelimiterGraphFilter.random().nextInt(37);
            int lower = -1;
            int upper = -1;
            if (surpriseMe < 10) {
                lower = 97;
                upper = 122;
            } else if (surpriseMe < 20) {
                lower = 65;
                upper = 90;
            } else if (surpriseMe < 30) {
                lower = 48;
                upper = 57;
            } else if (surpriseMe < 35) {
                lower = 45;
                upper = 45;
            } else {
                b.append("'s");
            }
            if (lower == -1) continue;
            b.append((char)TestUtil.nextInt((Random)TestWordDelimiterGraphFilter.random(), (int)lower, (int)upper));
        }
        return b.toString();
    }

    public void testInvalidFlag() throws Exception {
        TestWordDelimiterGraphFilter.expectThrows(IllegalArgumentException.class, () -> new WordDelimiterGraphFilter((TokenStream)new CannedTokenStream(new Token[0]), Integer.MIN_VALUE, null));
    }

    public void testRandomPaths() throws Exception {
        int iters = TestWordDelimiterGraphFilter.atLeast((int)100);
        for (int iter = 0; iter < iters; ++iter) {
            String text = this.randomWDFText();
            if (VERBOSE) {
                System.out.println("\nTEST: text=" + text + " len=" + text.length());
            }
            int flags = 0;
            if (TestWordDelimiterGraphFilter.random().nextBoolean()) {
                flags |= 1;
            }
            if (TestWordDelimiterGraphFilter.random().nextBoolean()) {
                flags |= 2;
            }
            if (TestWordDelimiterGraphFilter.random().nextBoolean()) {
                flags |= 4;
            }
            if (TestWordDelimiterGraphFilter.random().nextBoolean()) {
                flags |= 8;
            }
            if (TestWordDelimiterGraphFilter.random().nextBoolean()) {
                flags |= 0x10;
            }
            if (TestWordDelimiterGraphFilter.random().nextBoolean()) {
                flags |= 0x20;
            }
            if (TestWordDelimiterGraphFilter.random().nextBoolean()) {
                flags |= 0x40;
            }
            if (TestWordDelimiterGraphFilter.random().nextBoolean()) {
                flags |= 0x80;
            }
            if (TestWordDelimiterGraphFilter.random().nextBoolean()) {
                flags |= 0x100;
            }
            this.verify(text, flags);
        }
    }

    private void verify(String text, int flags) throws IOException {
        Set actual;
        Set<String> expected = this.slowWDF(text, flags);
        if (VERBOSE) {
            for (String path : expected) {
                System.out.println("  " + path);
            }
        }
        if (!(actual = TestWordDelimiterGraphFilter.getGraphStrings((Analyzer)this.getAnalyzer(flags), (String)text)).equals(expected)) {
            StringBuilder b = new StringBuilder();
            b.append("\n\nFAIL: text=");
            b.append(text);
            b.append(" flags=");
            b.append(WordDelimiterGraphFilter.flagsToString((int)flags));
            b.append('\n');
            b.append("  expected paths:\n");
            for (String s : expected) {
                b.append("    ");
                b.append(s);
                if (!actual.contains(s)) {
                    b.append(" [missing!]");
                }
                b.append('\n');
            }
            b.append("  actual paths:\n");
            for (String s : actual) {
                b.append("    ");
                b.append(s);
                if (!expected.contains(s)) {
                    b.append(" [unexpected!]");
                }
                b.append('\n');
            }
            TestWordDelimiterGraphFilter.fail((String)b.toString());
        }
    }

    public void testOnlyNumbers() throws Exception {
        TestWordDelimiterGraphFilter.assertGraphStrings((Analyzer)this.getAnalyzer(193), (String)"7-586", (String[])new String[0]);
    }

    public void testNoCatenate() throws Exception {
        TestWordDelimiterGraphFilter.assertGraphStrings((Analyzer)this.getAnalyzer(195), (String)"a-b-c-9-d", (String[])new String[]{"a b c 9 d"});
    }

    public void testCuriousCase1() throws Exception {
        this.verify("u-0L-4836-ip4Gw--13--q7--L07E1", 468);
    }

    public void testCuriousCase2() throws Exception {
        this.verify("u-l-p", 16);
    }

    public void testOriginalPosLength() throws Exception {
        this.verify("Foo-Bar-Baz", 100);
    }

    public void testCuriousCase3() throws Exception {
        this.verify("cQzk4-GL0izl0mKM-J8--4m-'s", 202);
    }

    public void testEmptyString() throws Exception {
        WordDelimiterGraphFilter wdf = new WordDelimiterGraphFilter((TokenStream)new CannedTokenStream(new Token[]{new Token((CharSequence)"", 0, 0)}), WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, 49, null);
        wdf.reset();
        TestWordDelimiterGraphFilter.assertTrue((boolean)wdf.incrementToken());
        TestWordDelimiterGraphFilter.assertFalse((boolean)wdf.incrementToken());
        wdf.end();
        wdf.close();
    }

    public void testProtectedWords() throws Exception {
        CannedTokenStream tokens = new CannedTokenStream(new Token[]{new Token((CharSequence)"foo17-bar", 0, 9), new Token((CharSequence)"foo-bar", 0, 7)});
        CharArraySet protectedWords = new CharArraySet(new HashSet<String>(Arrays.asList("foo17-BAR")), true);
        WordDelimiterGraphFilter wdf = new WordDelimiterGraphFilter((TokenStream)tokens, WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, 49, protectedWords);
        TestWordDelimiterGraphFilter.assertGraphStrings((TokenStream)wdf, (String[])new String[]{"foo17-bar foo bar", "foo17-bar foo-bar", "foo17-bar foobar"});
    }

    private static class WordPart {
        final String part;
        final int startOffset;
        final int endOffset;
        final int type;

        public WordPart(String text, int startOffset, int endOffset) {
            this.part = text.substring(startOffset, endOffset);
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.type = TestWordDelimiterGraphFilter.toType(this.part.charAt(0));
        }

        public String toString() {
            return "WordPart(" + this.part + " " + this.startOffset + "-" + this.endOffset + ")";
        }
    }

    private static final class LargePosIncTokenFilter
    extends TokenFilter {
        private CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);

        protected LargePosIncTokenFilter(TokenStream input) {
            super(input);
        }

        public boolean incrementToken() throws IOException {
            if (this.input.incrementToken()) {
                if (this.termAtt.toString().equals("largegap") || this.termAtt.toString().equals("/")) {
                    this.posIncAtt.setPositionIncrement(10);
                }
                return true;
            }
            return false;
        }
    }
}

