/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.core.LetterTokenizer;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.shingle.ShingleFilter;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.TestUtil;

public class EdgeNGramTokenFilterTest
extends BaseTokenStreamTestCase {
    private TokenStream input;

    public void setUp() throws Exception {
        super.setUp();
        this.input = EdgeNGramTokenFilterTest.whitespaceMockTokenizer((String)"abcde");
    }

    public void testInvalidInput() throws Exception {
        EdgeNGramTokenFilterTest.expectThrows(IllegalArgumentException.class, () -> new EdgeNGramTokenFilter(this.input, 0, 0));
    }

    public void testInvalidInput2() throws Exception {
        EdgeNGramTokenFilterTest.expectThrows(IllegalArgumentException.class, () -> new EdgeNGramTokenFilter(this.input, 2, 1));
    }

    public void testInvalidInput3() throws Exception {
        EdgeNGramTokenFilterTest.expectThrows(IllegalArgumentException.class, () -> new EdgeNGramTokenFilter(this.input, -1, 2));
    }

    public void testFrontUnigram() throws Exception {
        EdgeNGramTokenFilter tokenizer = new EdgeNGramTokenFilter(this.input, 1, 1);
        EdgeNGramTokenFilterTest.assertTokenStreamContents((TokenStream)tokenizer, (String[])new String[]{"a"}, (int[])new int[]{0}, (int[])new int[]{5});
    }

    public void testOversizedNgrams() throws Exception {
        EdgeNGramTokenFilter tokenizer = new EdgeNGramTokenFilter(this.input, 6, 6);
        EdgeNGramTokenFilterTest.assertTokenStreamContents((TokenStream)tokenizer, (String[])new String[0], (int[])new int[0], (int[])new int[0]);
    }

    public void testFrontRangeOfNgrams() throws Exception {
        EdgeNGramTokenFilter tokenizer = new EdgeNGramTokenFilter(this.input, 1, 3);
        EdgeNGramTokenFilterTest.assertTokenStreamContents((TokenStream)tokenizer, (String[])new String[]{"a", "ab", "abc"}, (int[])new int[]{0, 0, 0}, (int[])new int[]{5, 5, 5});
    }

    public void testFilterPositions() throws Exception {
        MockTokenizer ts = EdgeNGramTokenFilterTest.whitespaceMockTokenizer((String)"abcde vwxyz");
        EdgeNGramTokenFilter tokenizer = new EdgeNGramTokenFilter((TokenStream)ts, 1, 3);
        EdgeNGramTokenFilterTest.assertTokenStreamContents((TokenStream)tokenizer, (String[])new String[]{"a", "ab", "abc", "v", "vw", "vwx"}, (int[])new int[]{0, 0, 0, 6, 6, 6}, (int[])new int[]{5, 5, 5, 11, 11, 11}, null, (int[])new int[]{1, 0, 0, 1, 0, 0}, null, null, (boolean)false);
    }

    public void testFirstTokenPositionIncrement() throws Exception {
        Object ts = EdgeNGramTokenFilterTest.whitespaceMockTokenizer((String)"a abc");
        ts = new PositionFilter((TokenStream)ts);
        EdgeNGramTokenFilter filter = new EdgeNGramTokenFilter((TokenStream)ts, 2, 3);
        EdgeNGramTokenFilterTest.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"ab", "abc"}, (int[])new int[]{2, 2}, (int[])new int[]{5, 5}, (int[])new int[]{1, 0});
    }

    public void testSmallTokenInStream() throws Exception {
        this.input = EdgeNGramTokenFilterTest.whitespaceMockTokenizer((String)"abc de fgh");
        EdgeNGramTokenFilter tokenizer = new EdgeNGramTokenFilter(this.input, 3, 3);
        EdgeNGramTokenFilterTest.assertTokenStreamContents((TokenStream)tokenizer, (String[])new String[]{"abc", "fgh"}, (int[])new int[]{0, 7}, (int[])new int[]{3, 10});
    }

    public void testReset() throws Exception {
        WhitespaceTokenizer tokenizer = new WhitespaceTokenizer();
        tokenizer.setReader((Reader)new StringReader("abcde"));
        EdgeNGramTokenFilter filter = new EdgeNGramTokenFilter((TokenStream)tokenizer, 1, 3);
        EdgeNGramTokenFilterTest.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"a", "ab", "abc"}, (int[])new int[]{0, 0, 0}, (int[])new int[]{5, 5, 5});
        tokenizer.setReader((Reader)new StringReader("abcde"));
        EdgeNGramTokenFilterTest.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"a", "ab", "abc"}, (int[])new int[]{0, 0, 0}, (int[])new int[]{5, 5, 5});
    }

    public void testRandomStrings() throws Exception {
        for (int i = 0; i < 10; ++i) {
            final int min = TestUtil.nextInt((Random)EdgeNGramTokenFilterTest.random(), (int)2, (int)10);
            final int max = TestUtil.nextInt((Random)EdgeNGramTokenFilterTest.random(), (int)min, (int)20);
            Analyzer a = new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                    return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new EdgeNGramTokenFilter((TokenStream)tokenizer, min, max));
                }
            };
            EdgeNGramTokenFilterTest.checkRandomData((Random)EdgeNGramTokenFilterTest.random(), (Analyzer)a, (int)(100 * RANDOM_MULTIPLIER));
            a.close();
        }
    }

    public void testEmptyTerm() throws Exception {
        Random random = EdgeNGramTokenFilterTest.random();
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new EdgeNGramTokenFilter((TokenStream)tokenizer, 2, 15));
            }
        };
        EdgeNGramTokenFilterTest.checkAnalysisConsistency((Random)random, (Analyzer)a, (boolean)random.nextBoolean(), (String)"");
        a.close();
    }

    public void testGraphs() throws IOException {
        LetterTokenizer tk = new LetterTokenizer();
        ((Tokenizer)tk).setReader((Reader)new StringReader("abc d efgh ij klmno p q"));
        tk = new ShingleFilter((TokenStream)tk);
        tk = new EdgeNGramTokenFilter((TokenStream)tk, 7, 10);
        EdgeNGramTokenFilterTest.assertTokenStreamContents((TokenStream)tk, (String[])new String[]{"efgh ij", "ij klmn", "ij klmno", "klmno p"}, (int[])new int[]{6, 11, 11, 14}, (int[])new int[]{13, 19, 19, 21}, (int[])new int[]{3, 1, 0, 1}, (int[])new int[]{2, 2, 2, 2}, (Integer)23);
    }

    public void testSupplementaryCharacters() throws IOException {
        String s = TestUtil.randomUnicodeString((Random)EdgeNGramTokenFilterTest.random(), (int)10);
        int codePointCount = s.codePointCount(0, s.length());
        int minGram = TestUtil.nextInt((Random)EdgeNGramTokenFilterTest.random(), (int)1, (int)3);
        int maxGram = TestUtil.nextInt((Random)EdgeNGramTokenFilterTest.random(), (int)minGram, (int)10);
        KeywordTokenizer tk = new KeywordTokenizer();
        ((Tokenizer)tk).setReader((Reader)new StringReader(s));
        tk = new EdgeNGramTokenFilter((TokenStream)tk, minGram, maxGram);
        CharTermAttribute termAtt = (CharTermAttribute)tk.addAttribute(CharTermAttribute.class);
        OffsetAttribute offsetAtt = (OffsetAttribute)tk.addAttribute(OffsetAttribute.class);
        tk.reset();
        for (int i = minGram; i <= Math.min(codePointCount, maxGram); ++i) {
            EdgeNGramTokenFilterTest.assertTrue((boolean)tk.incrementToken());
            EdgeNGramTokenFilterTest.assertEquals((long)0L, (long)offsetAtt.startOffset());
            EdgeNGramTokenFilterTest.assertEquals((long)s.length(), (long)offsetAtt.endOffset());
            int end = Character.offsetByCodePoints(s, 0, i);
            EdgeNGramTokenFilterTest.assertEquals((Object)s.substring(0, end), (Object)termAtt.toString());
        }
        EdgeNGramTokenFilterTest.assertFalse((boolean)tk.incrementToken());
    }

    private static class PositionFilter
    extends TokenFilter {
        private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        private boolean started;

        PositionFilter(TokenStream input) {
            super(input);
        }

        public final boolean incrementToken() throws IOException {
            if (this.input.incrementToken()) {
                if (this.started) {
                    this.posIncrAtt.setPositionIncrement(0);
                } else {
                    this.started = true;
                }
                return true;
            }
            return false;
        }

        public void reset() throws IOException {
            super.reset();
            this.started = false;
        }
    }
}

