/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import com.carrotsearch.randomizedtesting.generators.RandomStrings;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenizer;
import org.apache.lucene.analysis.ngram.NGramTokenizerTest;
import org.apache.lucene.util.TestUtil;

public class EdgeNGramTokenizerTest
extends BaseTokenStreamTestCase {
    private StringReader input;

    public void setUp() throws Exception {
        super.setUp();
        this.input = new StringReader("abcde");
    }

    public void testInvalidInput() throws Exception {
        EdgeNGramTokenizerTest.expectThrows(IllegalArgumentException.class, () -> new EdgeNGramTokenizer(0, 0).setReader((Reader)this.input));
    }

    public void testInvalidInput2() throws Exception {
        EdgeNGramTokenizerTest.expectThrows(IllegalArgumentException.class, () -> new EdgeNGramTokenizer(2, 1).setReader((Reader)this.input));
    }

    public void testInvalidInput3() throws Exception {
        EdgeNGramTokenizerTest.expectThrows(IllegalArgumentException.class, () -> new EdgeNGramTokenizer(-1, 2).setReader((Reader)this.input));
    }

    public void testFrontUnigram() throws Exception {
        EdgeNGramTokenizer tokenizer = new EdgeNGramTokenizer(1, 1);
        tokenizer.setReader((Reader)this.input);
        EdgeNGramTokenizerTest.assertTokenStreamContents((TokenStream)tokenizer, (String[])new String[]{"a"}, (int[])new int[]{0}, (int[])new int[]{1}, (Integer)5);
    }

    public void testOversizedNgrams() throws Exception {
        EdgeNGramTokenizer tokenizer = new EdgeNGramTokenizer(6, 6);
        tokenizer.setReader((Reader)this.input);
        EdgeNGramTokenizerTest.assertTokenStreamContents((TokenStream)tokenizer, (String[])new String[0], (int[])new int[0], (int[])new int[0], (Integer)5);
    }

    public void testFrontRangeOfNgrams() throws Exception {
        EdgeNGramTokenizer tokenizer = new EdgeNGramTokenizer(1, 3);
        tokenizer.setReader((Reader)this.input);
        EdgeNGramTokenizerTest.assertTokenStreamContents((TokenStream)tokenizer, (String[])new String[]{"a", "ab", "abc"}, (int[])new int[]{0, 0, 0}, (int[])new int[]{1, 2, 3}, (Integer)5);
    }

    public void testReset() throws Exception {
        EdgeNGramTokenizer tokenizer = new EdgeNGramTokenizer(1, 3);
        tokenizer.setReader((Reader)this.input);
        EdgeNGramTokenizerTest.assertTokenStreamContents((TokenStream)tokenizer, (String[])new String[]{"a", "ab", "abc"}, (int[])new int[]{0, 0, 0}, (int[])new int[]{1, 2, 3}, (Integer)5);
        tokenizer.setReader((Reader)new StringReader("abcde"));
        EdgeNGramTokenizerTest.assertTokenStreamContents((TokenStream)tokenizer, (String[])new String[]{"a", "ab", "abc"}, (int[])new int[]{0, 0, 0}, (int[])new int[]{1, 2, 3}, (Integer)5);
    }

    public void testRandomStrings() throws Exception {
        int numIters = TEST_NIGHTLY ? 10 : 1;
        for (int i = 0; i < numIters; ++i) {
            final int min = TestUtil.nextInt((Random)EdgeNGramTokenizerTest.random(), (int)2, (int)10);
            final int max = TestUtil.nextInt((Random)EdgeNGramTokenizerTest.random(), (int)min, (int)20);
            Analyzer a = new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    EdgeNGramTokenizer tokenizer = new EdgeNGramTokenizer(min, max);
                    return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)tokenizer);
                }
            };
            EdgeNGramTokenizerTest.checkRandomData((Random)EdgeNGramTokenizerTest.random(), (Analyzer)a, (int)(100 * RANDOM_MULTIPLIER), (int)20);
            EdgeNGramTokenizerTest.checkRandomData((Random)EdgeNGramTokenizerTest.random(), (Analyzer)a, (int)(10 * RANDOM_MULTIPLIER), (int)8192);
            a.close();
        }
    }

    public void testTokenizerPositions() throws Exception {
        EdgeNGramTokenizer tokenizer = new EdgeNGramTokenizer(1, 3);
        tokenizer.setReader((Reader)new StringReader("abcde"));
        EdgeNGramTokenizerTest.assertTokenStreamContents((TokenStream)tokenizer, (String[])new String[]{"a", "ab", "abc"}, (int[])new int[]{0, 0, 0}, (int[])new int[]{1, 2, 3}, null, (int[])new int[]{1, 1, 1}, null, null, (boolean)false);
    }

    private static void testNGrams(int minGram, int maxGram, int length, String nonTokenChars) throws IOException {
        String s = RandomStrings.randomAsciiOfLength((Random)EdgeNGramTokenizerTest.random(), (int)length);
        EdgeNGramTokenizerTest.testNGrams(minGram, maxGram, s, nonTokenChars);
    }

    private static void testNGrams(int minGram, int maxGram, String s, String nonTokenChars) throws IOException {
        NGramTokenizerTest.testNGrams(minGram, maxGram, s, nonTokenChars, true);
    }

    public void testLargeInput() throws IOException {
        int minGram = TestUtil.nextInt((Random)EdgeNGramTokenizerTest.random(), (int)1, (int)100);
        int maxGram = TestUtil.nextInt((Random)EdgeNGramTokenizerTest.random(), (int)minGram, (int)100);
        EdgeNGramTokenizerTest.testNGrams(minGram, maxGram, TestUtil.nextInt((Random)EdgeNGramTokenizerTest.random(), (int)3072, (int)4096), "");
    }

    public void testLargeMaxGram() throws IOException {
        int minGram = TestUtil.nextInt((Random)EdgeNGramTokenizerTest.random(), (int)1290, (int)1300);
        int maxGram = TestUtil.nextInt((Random)EdgeNGramTokenizerTest.random(), (int)minGram, (int)1300);
        EdgeNGramTokenizerTest.testNGrams(minGram, maxGram, TestUtil.nextInt((Random)EdgeNGramTokenizerTest.random(), (int)3072, (int)4096), "");
    }

    public void testPreTokenization() throws IOException {
        int minGram = TestUtil.nextInt((Random)EdgeNGramTokenizerTest.random(), (int)1, (int)100);
        int maxGram = TestUtil.nextInt((Random)EdgeNGramTokenizerTest.random(), (int)minGram, (int)100);
        EdgeNGramTokenizerTest.testNGrams(minGram, maxGram, TestUtil.nextInt((Random)EdgeNGramTokenizerTest.random(), (int)0, (int)4096), "a");
    }

    public void testHeavyPreTokenization() throws IOException {
        int minGram = TestUtil.nextInt((Random)EdgeNGramTokenizerTest.random(), (int)1, (int)100);
        int maxGram = TestUtil.nextInt((Random)EdgeNGramTokenizerTest.random(), (int)minGram, (int)100);
        EdgeNGramTokenizerTest.testNGrams(minGram, maxGram, TestUtil.nextInt((Random)EdgeNGramTokenizerTest.random(), (int)0, (int)4096), "abcdef");
    }

    public void testFewTokenChars() throws IOException {
        char[] chrs = new char[TestUtil.nextInt((Random)EdgeNGramTokenizerTest.random(), (int)4000, (int)5000)];
        Arrays.fill(chrs, ' ');
        for (int i = 0; i < chrs.length; ++i) {
            if (!((double)EdgeNGramTokenizerTest.random().nextFloat() < 0.1)) continue;
            chrs[i] = 97;
        }
        int minGram = TestUtil.nextInt((Random)EdgeNGramTokenizerTest.random(), (int)1, (int)2);
        int maxGram = TestUtil.nextInt((Random)EdgeNGramTokenizerTest.random(), (int)minGram, (int)2);
        EdgeNGramTokenizerTest.testNGrams(minGram, maxGram, new String(chrs), " ");
    }

    public void testFullUTF8Range() throws IOException {
        int minGram = TestUtil.nextInt((Random)EdgeNGramTokenizerTest.random(), (int)1, (int)100);
        int maxGram = TestUtil.nextInt((Random)EdgeNGramTokenizerTest.random(), (int)minGram, (int)100);
        String s = TestUtil.randomUnicodeString((Random)EdgeNGramTokenizerTest.random(), (int)4096);
        EdgeNGramTokenizerTest.testNGrams(minGram, maxGram, s, "");
        EdgeNGramTokenizerTest.testNGrams(minGram, maxGram, s, "abcdef");
    }
}

