/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.ngram.NGramTokenFilter;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.util.TestUtil;

public class NGramTokenFilterTest
extends BaseTokenStreamTestCase {
    private TokenStream input;

    public void setUp() throws Exception {
        super.setUp();
        this.input = NGramTokenFilterTest.whitespaceMockTokenizer((String)"abcde");
    }

    public void testInvalidInput() throws Exception {
        NGramTokenFilterTest.expectThrows(IllegalArgumentException.class, () -> new NGramTokenFilter(this.input, 2, 1));
    }

    public void testInvalidInput2() throws Exception {
        NGramTokenFilterTest.expectThrows(IllegalArgumentException.class, () -> new NGramTokenFilter(this.input, 0, 1));
    }

    public void testUnigrams() throws Exception {
        NGramTokenFilter filter = new NGramTokenFilter(this.input, 1, 1);
        NGramTokenFilterTest.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"a", "b", "c", "d", "e"}, (int[])new int[]{0, 0, 0, 0, 0}, (int[])new int[]{5, 5, 5, 5, 5}, (int[])new int[]{1, 0, 0, 0, 0});
    }

    public void testBigrams() throws Exception {
        NGramTokenFilter filter = new NGramTokenFilter(this.input, 2, 2);
        NGramTokenFilterTest.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"ab", "bc", "cd", "de"}, (int[])new int[]{0, 0, 0, 0}, (int[])new int[]{5, 5, 5, 5}, (int[])new int[]{1, 0, 0, 0});
    }

    public void testNgrams() throws Exception {
        NGramTokenFilter filter = new NGramTokenFilter(this.input, 1, 3);
        NGramTokenFilterTest.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"a", "ab", "abc", "b", "bc", "bcd", "c", "cd", "cde", "d", "de", "e"}, (int[])new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, (int[])new int[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5}, null, (int[])new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, null, null, (boolean)false);
    }

    public void testNgramsNoIncrement() throws Exception {
        NGramTokenFilter filter = new NGramTokenFilter(this.input, 1, 3);
        NGramTokenFilterTest.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"a", "ab", "abc", "b", "bc", "bcd", "c", "cd", "cde", "d", "de", "e"}, (int[])new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, (int[])new int[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5}, null, (int[])new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, null, null, (boolean)false);
    }

    public void testOversizedNgrams() throws Exception {
        NGramTokenFilter filter = new NGramTokenFilter(this.input, 6, 7);
        NGramTokenFilterTest.assertTokenStreamContents((TokenStream)filter, (String[])new String[0], (int[])new int[0], (int[])new int[0]);
    }

    public void testSmallTokenInStream() throws Exception {
        this.input = NGramTokenFilterTest.whitespaceMockTokenizer((String)"abc de fgh");
        NGramTokenFilter filter = new NGramTokenFilter(this.input, 3, 3);
        NGramTokenFilterTest.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"abc", "fgh"}, (int[])new int[]{0, 7}, (int[])new int[]{3, 10}, (int[])new int[]{1, 2});
    }

    public void testReset() throws Exception {
        WhitespaceTokenizer tokenizer = new WhitespaceTokenizer();
        tokenizer.setReader((Reader)new StringReader("abcde"));
        NGramTokenFilter filter = new NGramTokenFilter((TokenStream)tokenizer, 1, 1);
        NGramTokenFilterTest.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"a", "b", "c", "d", "e"}, (int[])new int[]{0, 0, 0, 0, 0}, (int[])new int[]{5, 5, 5, 5, 5}, (int[])new int[]{1, 0, 0, 0, 0});
        tokenizer.setReader((Reader)new StringReader("abcde"));
        NGramTokenFilterTest.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"a", "b", "c", "d", "e"}, (int[])new int[]{0, 0, 0, 0, 0}, (int[])new int[]{5, 5, 5, 5, 5}, (int[])new int[]{1, 0, 0, 0, 0});
    }

    public void testInvalidOffsets() throws Exception {
        Analyzer analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                ASCIIFoldingFilter filters = new ASCIIFoldingFilter((TokenStream)tokenizer);
                filters = new NGramTokenFilter((TokenStream)filters, 2, 2);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)filters);
            }
        };
        NGramTokenFilterTest.assertAnalyzesTo((Analyzer)analyzer, (String)"mosfellsb\u00e6r", (String[])new String[]{"mo", "os", "sf", "fe", "el", "ll", "ls", "sb", "ba", "ae", "er"}, (int[])new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, (int[])new int[]{11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11}, (int[])new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        analyzer.close();
    }

    public void testRandomStrings() throws Exception {
        for (int i = 0; i < 10; ++i) {
            final int min = TestUtil.nextInt((Random)NGramTokenFilterTest.random(), (int)2, (int)10);
            final int max = TestUtil.nextInt((Random)NGramTokenFilterTest.random(), (int)min, (int)20);
            Analyzer a = new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                    return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new NGramTokenFilter((TokenStream)tokenizer, min, max));
                }
            };
            NGramTokenFilterTest.checkRandomData((Random)NGramTokenFilterTest.random(), (Analyzer)a, (int)(200 * RANDOM_MULTIPLIER), (int)20);
            a.close();
        }
    }

    public void testEmptyTerm() throws Exception {
        Random random = NGramTokenFilterTest.random();
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new NGramTokenFilter((TokenStream)tokenizer, 2, 15));
            }
        };
        NGramTokenFilterTest.checkAnalysisConsistency((Random)random, (Analyzer)a, (boolean)random.nextBoolean(), (String)"");
        a.close();
    }

    public void testSupplementaryCharacters() throws IOException {
        String s = TestUtil.randomUnicodeString((Random)NGramTokenFilterTest.random(), (int)10);
        int codePointCount = s.codePointCount(0, s.length());
        int minGram = TestUtil.nextInt((Random)NGramTokenFilterTest.random(), (int)1, (int)3);
        int maxGram = TestUtil.nextInt((Random)NGramTokenFilterTest.random(), (int)minGram, (int)10);
        KeywordTokenizer tk = new KeywordTokenizer();
        ((Tokenizer)tk).setReader((Reader)new StringReader(s));
        tk = new NGramTokenFilter((TokenStream)tk, minGram, maxGram);
        CharTermAttribute termAtt = (CharTermAttribute)tk.addAttribute(CharTermAttribute.class);
        OffsetAttribute offsetAtt = (OffsetAttribute)tk.addAttribute(OffsetAttribute.class);
        tk.reset();
        for (int start = 0; start < codePointCount; ++start) {
            for (int end = start + minGram; end <= Math.min(codePointCount, start + maxGram); ++end) {
                NGramTokenFilterTest.assertTrue((boolean)tk.incrementToken());
                NGramTokenFilterTest.assertEquals((long)0L, (long)offsetAtt.startOffset());
                NGramTokenFilterTest.assertEquals((long)s.length(), (long)offsetAtt.endOffset());
                int startIndex = Character.offsetByCodePoints(s, 0, start);
                int endIndex = Character.offsetByCodePoints(s, 0, end);
                NGramTokenFilterTest.assertEquals((Object)s.substring(startIndex, endIndex), (Object)termAtt.toString());
            }
        }
        NGramTokenFilterTest.assertFalse((boolean)tk.incrementToken());
    }
}

