/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.payloads.PayloadHelper;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;
import org.apache.lucene.util.BytesRef;

public class TestNGramFilters
extends BaseTokenStreamFactoryTestCase {
    public void testNGramTokenizer() throws Exception {
        StringReader reader = new StringReader("test");
        Tokenizer stream = this.tokenizerFactory("NGram", new String[0]).create();
        stream.setReader((Reader)reader);
        TestNGramFilters.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"t", "te", "e", "es", "s", "st", "t"});
    }

    public void testNGramTokenizer2() throws Exception {
        StringReader reader = new StringReader("test");
        Tokenizer stream = this.tokenizerFactory("NGram", "minGramSize", "2", "maxGramSize", "3").create();
        stream.setReader((Reader)reader);
        TestNGramFilters.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"te", "tes", "es", "est", "st"});
    }

    public void testNGramFilter() throws Exception {
        StringReader reader = new StringReader("test");
        MockTokenizer stream = TestNGramFilters.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("NGram", new String[0]).create((TokenStream)stream);
        TestNGramFilters.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"t", "te", "e", "es", "s", "st", "t"});
    }

    public void testNGramFilter2() throws Exception {
        StringReader reader = new StringReader("test");
        MockTokenizer stream = TestNGramFilters.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("NGram", "minGramSize", "2", "maxGramSize", "3").create((TokenStream)stream);
        TestNGramFilters.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"te", "tes", "es", "est", "st"});
    }

    public void testNGramFilterPayload() throws Exception {
        StringReader reader = new StringReader("test|0.1");
        MockTokenizer stream = TestNGramFilters.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("DelimitedPayload", "encoder", "float").create((TokenStream)stream);
        stream = this.tokenFilterFactory("NGram", "minGramSize", "1", "maxGramSize", "2").create((TokenStream)stream);
        stream.reset();
        while (stream.incrementToken()) {
            PayloadAttribute payAttr = (PayloadAttribute)stream.getAttribute(PayloadAttribute.class);
            TestNGramFilters.assertNotNull((Object)payAttr);
            BytesRef payData = payAttr.getPayload();
            TestNGramFilters.assertNotNull((Object)payData);
            float payFloat = PayloadHelper.decodeFloat((byte[])payData.bytes);
            TestNGramFilters.assertEquals((double)0.1f, (double)payFloat, (double)0.0);
        }
        stream.end();
        stream.close();
    }

    public void testEdgeNGramTokenizer() throws Exception {
        StringReader reader = new StringReader("test");
        Tokenizer stream = this.tokenizerFactory("EdgeNGram", new String[0]).create();
        stream.setReader((Reader)reader);
        TestNGramFilters.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"t"});
    }

    public void testEdgeNGramTokenizer2() throws Exception {
        StringReader reader = new StringReader("test");
        Tokenizer stream = this.tokenizerFactory("EdgeNGram", "minGramSize", "1", "maxGramSize", "2").create();
        stream.setReader((Reader)reader);
        TestNGramFilters.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"t", "te"});
    }

    public void testEdgeNGramFilter() throws Exception {
        StringReader reader = new StringReader("test");
        MockTokenizer stream = TestNGramFilters.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("EdgeNGram", new String[0]).create((TokenStream)stream);
        TestNGramFilters.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"t"});
    }

    public void testEdgeNGramFilter2() throws Exception {
        StringReader reader = new StringReader("test");
        MockTokenizer stream = TestNGramFilters.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("EdgeNGram", "minGramSize", "1", "maxGramSize", "2").create((TokenStream)stream);
        TestNGramFilters.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"t", "te"});
    }

    public void testEdgeNGramFilterPayload() throws Exception {
        StringReader reader = new StringReader("test|0.1");
        MockTokenizer stream = TestNGramFilters.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("DelimitedPayload", "encoder", "float").create((TokenStream)stream);
        stream = this.tokenFilterFactory("EdgeNGram", "minGramSize", "1", "maxGramSize", "2").create((TokenStream)stream);
        stream.reset();
        while (stream.incrementToken()) {
            PayloadAttribute payAttr = (PayloadAttribute)stream.getAttribute(PayloadAttribute.class);
            TestNGramFilters.assertNotNull((Object)payAttr);
            BytesRef payData = payAttr.getPayload();
            TestNGramFilters.assertNotNull((Object)payData);
            float payFloat = PayloadHelper.decodeFloat((byte[])payData.bytes);
            TestNGramFilters.assertEquals((double)0.1f, (double)payFloat, (double)0.0);
        }
        stream.end();
        stream.close();
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestNGramFilters.expectThrows(IllegalArgumentException.class, () -> this.tokenizerFactory("NGram", "bogusArg", "bogusValue"));
        TestNGramFilters.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
        expected = (IllegalArgumentException)TestNGramFilters.expectThrows(IllegalArgumentException.class, () -> this.tokenizerFactory("EdgeNGram", "bogusArg", "bogusValue"));
        TestNGramFilters.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
        expected = (IllegalArgumentException)TestNGramFilters.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("NGram", "bogusArg", "bogusValue"));
        TestNGramFilters.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
        expected = (IllegalArgumentException)TestNGramFilters.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("EdgeNGram", "bogusArg", "bogusValue"));
        TestNGramFilters.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

