/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.nl;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArrayMap;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.nl.DutchAnalyzer;

public class TestDutchAnalyzer
extends BaseTokenStreamTestCase {
    public void testWithSnowballExamples() throws Exception {
        this.check("lichaamsziek", "lichaamsziek");
        this.check("lichamelijk", "licham");
        this.check("lichamelijke", "licham");
        this.check("lichamelijkheden", "licham");
        this.check("lichamen", "licham");
        this.check("lichere", "licher");
        this.check("licht", "licht");
        this.check("lichtbeeld", "lichtbeeld");
        this.check("lichtbruin", "lichtbruin");
        this.check("lichtdoorlatende", "lichtdoorlat");
        this.check("lichte", "licht");
        this.check("lichten", "licht");
        this.check("lichtende", "lichtend");
        this.check("lichtenvoorde", "lichtenvoord");
        this.check("lichter", "lichter");
        this.check("lichtere", "lichter");
        this.check("lichters", "lichter");
        this.check("lichtgevoeligheid", "lichtgevoel");
        this.check("lichtgewicht", "lichtgewicht");
        this.check("lichtgrijs", "lichtgrijs");
        this.check("lichthoeveelheid", "lichthoevel");
        this.check("lichtintensiteit", "lichtintensiteit");
        this.check("lichtje", "lichtj");
        this.check("lichtjes", "lichtjes");
        this.check("lichtkranten", "lichtkrant");
        this.check("lichtkring", "lichtkring");
        this.check("lichtkringen", "lichtkring");
        this.check("lichtregelsystemen", "lichtregelsystem");
        this.check("lichtste", "lichtst");
        this.check("lichtstromende", "lichtstrom");
        this.check("lichtte", "licht");
        this.check("lichtten", "licht");
        this.check("lichttoetreding", "lichttoetred");
        this.check("lichtverontreinigde", "lichtverontreinigd");
        this.check("lichtzinnige", "lichtzinn");
        this.check("lid", "lid");
        this.check("lidia", "lidia");
        this.check("lidmaatschap", "lidmaatschap");
        this.check("lidstaten", "lidstat");
        this.check("lidvereniging", "lidveren");
        this.check("opgingen", "opging");
        this.check("opglanzing", "opglanz");
        this.check("opglanzingen", "opglanz");
        this.check("opglimlachten", "opglimlacht");
        this.check("opglimpen", "opglimp");
        this.check("opglimpende", "opglimp");
        this.check("opglimping", "opglimp");
        this.check("opglimpingen", "opglimp");
        this.check("opgraven", "opgrav");
        this.check("opgrijnzen", "opgrijnz");
        this.check("opgrijzende", "opgrijz");
        this.check("opgroeien", "opgroei");
        this.check("opgroeiende", "opgroei");
        this.check("opgroeiplaats", "opgroeiplat");
        this.check("ophaal", "ophal");
        this.check("ophaaldienst", "ophaaldienst");
        this.check("ophaalkosten", "ophaalkost");
        this.check("ophaalsystemen", "ophaalsystem");
        this.check("ophaalt", "ophaalt");
        this.check("ophaaltruck", "ophaaltruck");
        this.check("ophalen", "ophal");
        this.check("ophalend", "ophal");
        this.check("ophalers", "ophaler");
        this.check("ophef", "ophef");
        this.check("opheldering", "ophelder");
        this.check("ophemelde", "ophemeld");
        this.check("ophemelen", "ophemel");
        this.check("opheusden", "opheusd");
        this.check("ophief", "ophief");
        this.check("ophield", "ophield");
        this.check("ophieven", "ophiev");
        this.check("ophoepelt", "ophoepelt");
        this.check("ophoog", "ophog");
        this.check("ophoogzand", "ophoogzand");
        this.check("ophopen", "ophop");
        this.check("ophoping", "ophop");
        this.check("ophouden", "ophoud");
    }

    public void testSnowballCorrectness() throws Exception {
        DutchAnalyzer a = new DutchAnalyzer();
        TestDutchAnalyzer.checkOneTerm((Analyzer)a, (String)"opheffen", (String)"opheff");
        TestDutchAnalyzer.checkOneTerm((Analyzer)a, (String)"opheffende", (String)"opheff");
        TestDutchAnalyzer.checkOneTerm((Analyzer)a, (String)"opheffing", (String)"opheff");
        a.close();
    }

    public void testReusableTokenStream() throws Exception {
        DutchAnalyzer a = new DutchAnalyzer();
        TestDutchAnalyzer.checkOneTerm((Analyzer)a, (String)"lichaamsziek", (String)"lichaamsziek");
        TestDutchAnalyzer.checkOneTerm((Analyzer)a, (String)"lichamelijk", (String)"licham");
        TestDutchAnalyzer.checkOneTerm((Analyzer)a, (String)"lichamelijke", (String)"licham");
        TestDutchAnalyzer.checkOneTerm((Analyzer)a, (String)"lichamelijkheden", (String)"licham");
        a.close();
    }

    public void testExclusionTableViaCtor() throws IOException {
        CharArraySet set = new CharArraySet(1, true);
        set.add("lichamelijk");
        DutchAnalyzer a = new DutchAnalyzer(CharArraySet.EMPTY_SET, set);
        TestDutchAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"lichamelijk lichamelijke", (String[])new String[]{"lichamelijk", "licham"});
        a.close();
        a = new DutchAnalyzer(CharArraySet.EMPTY_SET, set);
        TestDutchAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"lichamelijk lichamelijke", (String[])new String[]{"lichamelijk", "licham"});
        a.close();
    }

    public void testStemOverrides() throws IOException {
        DutchAnalyzer a = new DutchAnalyzer(CharArraySet.EMPTY_SET);
        TestDutchAnalyzer.checkOneTerm((Analyzer)a, (String)"fiets", (String)"fiets");
        a.close();
    }

    public void testEmptyStemDictionary() throws IOException {
        DutchAnalyzer a = new DutchAnalyzer(CharArraySet.EMPTY_SET, CharArraySet.EMPTY_SET, CharArrayMap.emptyMap());
        TestDutchAnalyzer.checkOneTerm((Analyzer)a, (String)"fiets", (String)"fiet");
        a.close();
    }

    public void testStopwordsCasing() throws IOException {
        DutchAnalyzer a = new DutchAnalyzer();
        TestDutchAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"Zelf", (String[])new String[0]);
        a.close();
    }

    private void check(String input, String expected) throws Exception {
        DutchAnalyzer analyzer = new DutchAnalyzer();
        TestDutchAnalyzer.checkOneTerm((Analyzer)analyzer, (String)input, (String)expected);
        analyzer.close();
    }

    public void testRandomStrings() throws Exception {
        DutchAnalyzer analyzer = new DutchAnalyzer();
        TestDutchAnalyzer.checkRandomData((Random)TestDutchAnalyzer.random(), (Analyzer)analyzer, (int)(1000 * RANDOM_MULTIPLIER));
        analyzer.close();
    }
}

