/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.no;

import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.no.NorwegianAnalyzer;

public class TestNorwegianAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new NorwegianAnalyzer().close();
    }

    public void testBasics() throws IOException {
        NorwegianAnalyzer a = new NorwegianAnalyzer();
        TestNorwegianAnalyzer.checkOneTerm((Analyzer)a, (String)"havnedistriktene", (String)"havnedistrikt");
        TestNorwegianAnalyzer.checkOneTerm((Analyzer)a, (String)"havnedistrikter", (String)"havnedistrikt");
        TestNorwegianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"det", (String[])new String[0]);
        a.close();
    }

    public void testExclude() throws IOException {
        CharArraySet exclusionSet = new CharArraySet((Collection)TestNorwegianAnalyzer.asSet((Object[])new String[]{"havnedistriktene"}), false);
        NorwegianAnalyzer a = new NorwegianAnalyzer(NorwegianAnalyzer.getDefaultStopSet(), exclusionSet);
        TestNorwegianAnalyzer.checkOneTerm((Analyzer)a, (String)"havnedistriktene", (String)"havnedistriktene");
        TestNorwegianAnalyzer.checkOneTerm((Analyzer)a, (String)"havnedistrikter", (String)"havnedistrikt");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        NorwegianAnalyzer analyzer = new NorwegianAnalyzer();
        TestNorwegianAnalyzer.checkRandomData((Random)TestNorwegianAnalyzer.random(), (Analyzer)analyzer, (int)(1000 * RANDOM_MULTIPLIER));
        analyzer.close();
    }
}

