/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.no;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.VocabularyAssert;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.no.NorwegianLightStemFilter;

public class TestNorwegianLightStemFilter
extends BaseTokenStreamTestCase {
    private Analyzer analyzer;

    public void setUp() throws Exception {
        super.setUp();
        this.analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer source = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new NorwegianLightStemFilter((TokenStream)source, 1));
            }
        };
    }

    public void tearDown() throws Exception {
        this.analyzer.close();
        super.tearDown();
    }

    public void testVocabulary() throws IOException {
        VocabularyAssert.assertVocabulary((Analyzer)this.analyzer, (InputStream)Files.newInputStream(this.getDataPath("nb_light.txt"), new OpenOption[0]));
    }

    public void testNynorskVocabulary() throws IOException {
        Analyzer analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer source = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new NorwegianLightStemFilter((TokenStream)source, 2));
            }
        };
        VocabularyAssert.assertVocabulary((Analyzer)analyzer, (InputStream)Files.newInputStream(this.getDataPath("nn_light.txt"), new OpenOption[0]));
        analyzer.close();
    }

    public void testKeyword() throws IOException {
        final CharArraySet exclusionSet = new CharArraySet((Collection)TestNorwegianLightStemFilter.asSet((Object[])new String[]{"sekret\u00e6ren"}), false);
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer source = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                SetKeywordMarkerFilter sink = new SetKeywordMarkerFilter((TokenStream)source, exclusionSet);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new NorwegianLightStemFilter((TokenStream)sink));
            }
        };
        TestNorwegianLightStemFilter.checkOneTerm((Analyzer)a, (String)"sekret\u00e6ren", (String)"sekret\u00e6ren");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        Random random = TestNorwegianLightStemFilter.random();
        TestNorwegianLightStemFilter.checkRandomData((Random)random, (Analyzer)this.analyzer, (int)(1000 * RANDOM_MULTIPLIER));
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new NorwegianLightStemFilter((TokenStream)tokenizer));
            }
        };
        TestNorwegianLightStemFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

