/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.no;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestNorwegianLightStemFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testStemming() throws Exception {
        StringReader reader = new StringReader("epler eple");
        MockTokenizer stream = TestNorwegianLightStemFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("NorwegianLightStem", new String[0]).create((TokenStream)stream);
        TestNorwegianLightStemFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"epl", "epl"});
    }

    public void testBokmaalStemming() throws Exception {
        StringReader reader = new StringReader("epler eple");
        MockTokenizer stream = TestNorwegianLightStemFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("NorwegianLightStem", "variant", "nb").create((TokenStream)stream);
        TestNorwegianLightStemFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"epl", "epl"});
    }

    public void testNynorskStemming() throws Exception {
        StringReader reader = new StringReader("gutar gutane");
        MockTokenizer stream = TestNorwegianLightStemFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("NorwegianLightStem", "variant", "nn").create((TokenStream)stream);
        TestNorwegianLightStemFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"gut", "gut"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestNorwegianLightStemFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("NorwegianLightStem", "bogusArg", "bogusValue"));
        TestNorwegianLightStemFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

