/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.no;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestNorwegianMinimalStemFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testStemming() throws Exception {
        StringReader reader = new StringReader("eple eplet epler eplene eplets eplenes");
        MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)stream).setReader((Reader)reader);
        stream = this.tokenFilterFactory("NorwegianMinimalStem", new String[0]).create((TokenStream)stream);
        TestNorwegianMinimalStemFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"epl", "epl", "epl", "epl", "epl", "epl"});
    }

    public void testBokmaalStemming() throws Exception {
        StringReader reader = new StringReader("eple eplet epler eplene eplets eplenes");
        MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)stream).setReader((Reader)reader);
        stream = this.tokenFilterFactory("NorwegianMinimalStem", "variant", "nb").create((TokenStream)stream);
        TestNorwegianMinimalStemFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"epl", "epl", "epl", "epl", "epl", "epl"});
    }

    public void testNynorskStemming() throws Exception {
        StringReader reader = new StringReader("gut guten gutar gutane gutens gutanes");
        MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)stream).setReader((Reader)reader);
        stream = this.tokenFilterFactory("NorwegianMinimalStem", "variant", "nn").create((TokenStream)stream);
        TestNorwegianMinimalStemFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"gut", "gut", "gut", "gut", "gut", "gut"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestNorwegianMinimalStemFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("NorwegianMinimalStem", "bogusArg", "bogusValue"));
        TestNorwegianMinimalStemFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

