/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.path;

import java.io.Reader;
import java.io.StringReader;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.charfilter.MappingCharFilter;
import org.apache.lucene.analysis.charfilter.NormalizeCharMap;
import org.apache.lucene.analysis.path.PathHierarchyTokenizer;

public class TestPathHierarchyTokenizer
extends BaseTokenStreamTestCase {
    public void testBasic() throws Exception {
        String path = "/a/b/c";
        PathHierarchyTokenizer t = new PathHierarchyTokenizer(TestPathHierarchyTokenizer.newAttributeFactory(), '/', '/', 0);
        t.setReader((Reader)new StringReader(path));
        TestPathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"/a", "/a/b", "/a/b/c"}, (int[])new int[]{0, 0, 0}, (int[])new int[]{2, 4, 6}, (int[])new int[]{1, 0, 0}, (Integer)path.length());
    }

    public void testEndOfDelimiter() throws Exception {
        String path = "/a/b/c/";
        PathHierarchyTokenizer t = new PathHierarchyTokenizer(TestPathHierarchyTokenizer.newAttributeFactory(), '/', '/', 0);
        t.setReader((Reader)new StringReader(path));
        TestPathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"/a", "/a/b", "/a/b/c", "/a/b/c/"}, (int[])new int[]{0, 0, 0, 0}, (int[])new int[]{2, 4, 6, 7}, (int[])new int[]{1, 0, 0, 0}, (Integer)path.length());
    }

    public void testStartOfChar() throws Exception {
        String path = "a/b/c";
        PathHierarchyTokenizer t = new PathHierarchyTokenizer(TestPathHierarchyTokenizer.newAttributeFactory(), '/', '/', 0);
        t.setReader((Reader)new StringReader(path));
        TestPathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"a", "a/b", "a/b/c"}, (int[])new int[]{0, 0, 0}, (int[])new int[]{1, 3, 5}, (int[])new int[]{1, 0, 0}, (Integer)path.length());
    }

    public void testStartOfCharEndOfDelimiter() throws Exception {
        String path = "a/b/c/";
        PathHierarchyTokenizer t = new PathHierarchyTokenizer(TestPathHierarchyTokenizer.newAttributeFactory(), '/', '/', 0);
        t.setReader((Reader)new StringReader(path));
        TestPathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"a", "a/b", "a/b/c", "a/b/c/"}, (int[])new int[]{0, 0, 0, 0}, (int[])new int[]{1, 3, 5, 6}, (int[])new int[]{1, 0, 0, 0}, (Integer)path.length());
    }

    public void testOnlyDelimiter() throws Exception {
        String path = "/";
        PathHierarchyTokenizer t = new PathHierarchyTokenizer(TestPathHierarchyTokenizer.newAttributeFactory(), '/', '/', 0);
        t.setReader((Reader)new StringReader(path));
        TestPathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"/"}, (int[])new int[]{0}, (int[])new int[]{1}, (int[])new int[]{1}, (Integer)path.length());
    }

    public void testOnlyDelimiters() throws Exception {
        String path = "//";
        PathHierarchyTokenizer t = new PathHierarchyTokenizer(TestPathHierarchyTokenizer.newAttributeFactory(), '/', '/', 0);
        t.setReader((Reader)new StringReader(path));
        TestPathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"/", "//"}, (int[])new int[]{0, 0}, (int[])new int[]{1, 2}, (int[])new int[]{1, 0}, (Integer)path.length());
    }

    public void testReplace() throws Exception {
        String path = "/a/b/c";
        PathHierarchyTokenizer t = new PathHierarchyTokenizer(TestPathHierarchyTokenizer.newAttributeFactory(), '/', '\\', 0);
        t.setReader((Reader)new StringReader(path));
        TestPathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"\\a", "\\a\\b", "\\a\\b\\c"}, (int[])new int[]{0, 0, 0}, (int[])new int[]{2, 4, 6}, (int[])new int[]{1, 0, 0}, (Integer)path.length());
    }

    public void testWindowsPath() throws Exception {
        String path = "c:\\a\\b\\c";
        PathHierarchyTokenizer t = new PathHierarchyTokenizer(TestPathHierarchyTokenizer.newAttributeFactory(), '\\', '\\', 0);
        t.setReader((Reader)new StringReader(path));
        TestPathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"c:", "c:\\a", "c:\\a\\b", "c:\\a\\b\\c"}, (int[])new int[]{0, 0, 0, 0}, (int[])new int[]{2, 4, 6, 8}, (int[])new int[]{1, 0, 0, 0}, (Integer)path.length());
    }

    public void testNormalizeWinDelimToLinuxDelim() throws Exception {
        NormalizeCharMap.Builder builder = new NormalizeCharMap.Builder();
        builder.add("\\", "/");
        NormalizeCharMap normMap = builder.build();
        String path = "c:\\a\\b\\c";
        MappingCharFilter cs = new MappingCharFilter(normMap, (Reader)new StringReader(path));
        PathHierarchyTokenizer t = new PathHierarchyTokenizer(TestPathHierarchyTokenizer.newAttributeFactory(), '/', '/', 0);
        t.setReader((Reader)cs);
        TestPathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"c:", "c:/a", "c:/a/b", "c:/a/b/c"}, (int[])new int[]{0, 0, 0, 0}, (int[])new int[]{2, 4, 6, 8}, (int[])new int[]{1, 0, 0, 0}, (Integer)path.length());
    }

    public void testBasicSkip() throws Exception {
        String path = "/a/b/c";
        PathHierarchyTokenizer t = new PathHierarchyTokenizer(TestPathHierarchyTokenizer.newAttributeFactory(), '/', '/', 1);
        t.setReader((Reader)new StringReader(path));
        TestPathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"/b", "/b/c"}, (int[])new int[]{2, 2}, (int[])new int[]{4, 6}, (int[])new int[]{1, 0}, (Integer)path.length());
    }

    public void testEndOfDelimiterSkip() throws Exception {
        String path = "/a/b/c/";
        PathHierarchyTokenizer t = new PathHierarchyTokenizer(TestPathHierarchyTokenizer.newAttributeFactory(), '/', '/', 1);
        t.setReader((Reader)new StringReader(path));
        TestPathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"/b", "/b/c", "/b/c/"}, (int[])new int[]{2, 2, 2}, (int[])new int[]{4, 6, 7}, (int[])new int[]{1, 0, 0}, (Integer)path.length());
    }

    public void testStartOfCharSkip() throws Exception {
        String path = "a/b/c";
        PathHierarchyTokenizer t = new PathHierarchyTokenizer(TestPathHierarchyTokenizer.newAttributeFactory(), '/', '/', 1);
        t.setReader((Reader)new StringReader(path));
        TestPathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"/b", "/b/c"}, (int[])new int[]{1, 1}, (int[])new int[]{3, 5}, (int[])new int[]{1, 0}, (Integer)path.length());
    }

    public void testStartOfCharEndOfDelimiterSkip() throws Exception {
        String path = "a/b/c/";
        PathHierarchyTokenizer t = new PathHierarchyTokenizer(TestPathHierarchyTokenizer.newAttributeFactory(), '/', '/', 1);
        t.setReader((Reader)new StringReader(path));
        TestPathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"/b", "/b/c", "/b/c/"}, (int[])new int[]{1, 1, 1}, (int[])new int[]{3, 5, 6}, (int[])new int[]{1, 0, 0}, (Integer)path.length());
    }

    public void testOnlyDelimiterSkip() throws Exception {
        String path = "/";
        PathHierarchyTokenizer t = new PathHierarchyTokenizer(TestPathHierarchyTokenizer.newAttributeFactory(), '/', '/', 1);
        t.setReader((Reader)new StringReader(path));
        TestPathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[0], (int[])new int[0], (int[])new int[0], (int[])new int[0], (Integer)path.length());
    }

    public void testOnlyDelimitersSkip() throws Exception {
        String path = "//";
        PathHierarchyTokenizer t = new PathHierarchyTokenizer(TestPathHierarchyTokenizer.newAttributeFactory(), '/', '/', 1);
        t.setReader((Reader)new StringReader(path));
        TestPathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"/"}, (int[])new int[]{1}, (int[])new int[]{2}, (int[])new int[]{1}, (Integer)path.length());
    }

    public void testRandomStrings() throws Exception {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                PathHierarchyTokenizer tokenizer = new PathHierarchyTokenizer(BaseTokenStreamTestCase.newAttributeFactory(), '/', '/', 0);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)tokenizer);
            }
        };
        TestPathHierarchyTokenizer.checkRandomData((Random)TestPathHierarchyTokenizer.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER), (int)20, (boolean)false, (boolean)false);
        a.close();
    }

    public void testRandomHugeStrings() throws Exception {
        Random random = TestPathHierarchyTokenizer.random();
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                PathHierarchyTokenizer tokenizer = new PathHierarchyTokenizer(BaseTokenStreamTestCase.newAttributeFactory(), '/', '/', 0);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)tokenizer);
            }
        };
        TestPathHierarchyTokenizer.checkRandomData((Random)random, (Analyzer)a, (int)(100 * RANDOM_MULTIPLIER), (int)1027, (boolean)false, (boolean)false);
        a.close();
    }
}

