/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.path;

import java.io.Reader;
import java.io.StringReader;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.path.ReversePathHierarchyTokenizer;

public class TestReversePathHierarchyTokenizer
extends BaseTokenStreamTestCase {
    public void testBasicReverse() throws Exception {
        String path = "/a/b/c";
        ReversePathHierarchyTokenizer t = new ReversePathHierarchyTokenizer(TestReversePathHierarchyTokenizer.newAttributeFactory(), '/', '/', 0);
        t.setReader((Reader)new StringReader(path));
        TestReversePathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"/a/b/c", "a/b/c", "b/c", "c"}, (int[])new int[]{0, 1, 3, 5}, (int[])new int[]{6, 6, 6, 6}, (int[])new int[]{1, 0, 0, 0}, (Integer)path.length());
    }

    public void testEndOfDelimiterReverse() throws Exception {
        String path = "/a/b/c/";
        ReversePathHierarchyTokenizer t = new ReversePathHierarchyTokenizer(TestReversePathHierarchyTokenizer.newAttributeFactory(), '/', '/', 0);
        t.setReader((Reader)new StringReader(path));
        TestReversePathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"/a/b/c/", "a/b/c/", "b/c/", "c/"}, (int[])new int[]{0, 1, 3, 5}, (int[])new int[]{7, 7, 7, 7}, (int[])new int[]{1, 0, 0, 0}, (Integer)path.length());
    }

    public void testStartOfCharReverse() throws Exception {
        String path = "a/b/c";
        ReversePathHierarchyTokenizer t = new ReversePathHierarchyTokenizer(TestReversePathHierarchyTokenizer.newAttributeFactory(), '/', '/', 0);
        t.setReader((Reader)new StringReader(path));
        TestReversePathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"a/b/c", "b/c", "c"}, (int[])new int[]{0, 2, 4}, (int[])new int[]{5, 5, 5}, (int[])new int[]{1, 0, 0}, (Integer)path.length());
    }

    public void testStartOfCharEndOfDelimiterReverse() throws Exception {
        String path = "a/b/c/";
        ReversePathHierarchyTokenizer t = new ReversePathHierarchyTokenizer(TestReversePathHierarchyTokenizer.newAttributeFactory(), '/', '/', 0);
        t.setReader((Reader)new StringReader(path));
        TestReversePathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"a/b/c/", "b/c/", "c/"}, (int[])new int[]{0, 2, 4}, (int[])new int[]{6, 6, 6}, (int[])new int[]{1, 0, 0}, (Integer)path.length());
    }

    public void testOnlyDelimiterReverse() throws Exception {
        String path = "/";
        ReversePathHierarchyTokenizer t = new ReversePathHierarchyTokenizer(TestReversePathHierarchyTokenizer.newAttributeFactory(), '/', '/', 0);
        t.setReader((Reader)new StringReader(path));
        TestReversePathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"/"}, (int[])new int[]{0}, (int[])new int[]{1}, (int[])new int[]{1}, (Integer)path.length());
    }

    public void testOnlyDelimitersReverse() throws Exception {
        String path = "//";
        ReversePathHierarchyTokenizer t = new ReversePathHierarchyTokenizer(TestReversePathHierarchyTokenizer.newAttributeFactory(), '/', '/', 0);
        t.setReader((Reader)new StringReader(path));
        TestReversePathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"//", "/"}, (int[])new int[]{0, 1}, (int[])new int[]{2, 2}, (int[])new int[]{1, 0}, (Integer)path.length());
    }

    public void testEndOfDelimiterReverseSkip() throws Exception {
        String path = "/a/b/c/";
        ReversePathHierarchyTokenizer t = new ReversePathHierarchyTokenizer(TestReversePathHierarchyTokenizer.newAttributeFactory(), '/', '/', 1);
        t.setReader((Reader)new StringReader(path));
        new StringReader(path);
        TestReversePathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"/a/b/", "a/b/", "b/"}, (int[])new int[]{0, 1, 3}, (int[])new int[]{5, 5, 5}, (int[])new int[]{1, 0, 0}, (Integer)path.length());
    }

    public void testStartOfCharReverseSkip() throws Exception {
        String path = "a/b/c";
        ReversePathHierarchyTokenizer t = new ReversePathHierarchyTokenizer(TestReversePathHierarchyTokenizer.newAttributeFactory(), '/', '/', 1);
        t.setReader((Reader)new StringReader(path));
        TestReversePathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"a/b/", "b/"}, (int[])new int[]{0, 2}, (int[])new int[]{4, 4}, (int[])new int[]{1, 0}, (Integer)path.length());
    }

    public void testStartOfCharEndOfDelimiterReverseSkip() throws Exception {
        String path = "a/b/c/";
        ReversePathHierarchyTokenizer t = new ReversePathHierarchyTokenizer(TestReversePathHierarchyTokenizer.newAttributeFactory(), '/', '/', 1);
        t.setReader((Reader)new StringReader(path));
        TestReversePathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"a/b/", "b/"}, (int[])new int[]{0, 2}, (int[])new int[]{4, 4}, (int[])new int[]{1, 0}, (Integer)path.length());
    }

    public void testOnlyDelimiterReverseSkip() throws Exception {
        String path = "/";
        ReversePathHierarchyTokenizer t = new ReversePathHierarchyTokenizer(TestReversePathHierarchyTokenizer.newAttributeFactory(), '/', '/', 1);
        t.setReader((Reader)new StringReader(path));
        TestReversePathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[0], (int[])new int[0], (int[])new int[0], (int[])new int[0], (Integer)path.length());
    }

    public void testOnlyDelimitersReverseSkip() throws Exception {
        String path = "//";
        ReversePathHierarchyTokenizer t = new ReversePathHierarchyTokenizer(TestReversePathHierarchyTokenizer.newAttributeFactory(), '/', '/', 1);
        t.setReader((Reader)new StringReader(path));
        TestReversePathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"/"}, (int[])new int[]{0}, (int[])new int[]{1}, (int[])new int[]{1}, (Integer)path.length());
    }

    public void testReverseSkip2() throws Exception {
        String path = "/a/b/c/";
        ReversePathHierarchyTokenizer t = new ReversePathHierarchyTokenizer(TestReversePathHierarchyTokenizer.newAttributeFactory(), '/', '/', 2);
        t.setReader((Reader)new StringReader(path));
        TestReversePathHierarchyTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"/a/", "a/"}, (int[])new int[]{0, 1}, (int[])new int[]{3, 3}, (int[])new int[]{1, 0}, (Integer)path.length());
    }

    public void testRandomStrings() throws Exception {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                ReversePathHierarchyTokenizer tokenizer = new ReversePathHierarchyTokenizer(BaseTokenStreamTestCase.newAttributeFactory(), '/', '/', 0);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)tokenizer);
            }
        };
        TestReversePathHierarchyTokenizer.checkRandomData((Random)TestReversePathHierarchyTokenizer.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER), (int)20, (boolean)false, (boolean)false);
        a.close();
    }

    public void testRandomHugeStrings() throws Exception {
        Random random = TestReversePathHierarchyTokenizer.random();
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                ReversePathHierarchyTokenizer tokenizer = new ReversePathHierarchyTokenizer(BaseTokenStreamTestCase.newAttributeFactory(), '/', '/', 0);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)tokenizer);
            }
        };
        TestReversePathHierarchyTokenizer.checkRandomData((Random)random, (Analyzer)a, (int)(100 * RANDOM_MULTIPLIER), (int)1027, (boolean)false, (boolean)false);
        a.close();
    }
}

