/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pattern;

import java.io.Reader;
import java.io.StringReader;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.pattern.PatternCaptureGroupTokenFilter;

public class TestPatternCaptureGroupTokenFilter
extends BaseTokenStreamTestCase {
    public void testNoPattern() throws Exception {
        this.testPatterns("foobarbaz", new String[0], new String[]{"foobarbaz"}, new int[]{0}, new int[]{9}, new int[]{1}, false);
        this.testPatterns("foobarbaz", new String[0], new String[]{"foobarbaz"}, new int[]{0}, new int[]{9}, new int[]{1}, true);
        this.testPatterns("foo bar baz", new String[0], new String[]{"foo", "bar", "baz"}, new int[]{0, 4, 8}, new int[]{3, 7, 11}, new int[]{1, 1, 1}, false);
        this.testPatterns("foo bar baz", new String[0], new String[]{"foo", "bar", "baz"}, new int[]{0, 4, 8}, new int[]{3, 7, 11}, new int[]{1, 1, 1}, true);
    }

    public void testNoMatch() throws Exception {
        this.testPatterns("foobarbaz", new String[]{"xx"}, new String[]{"foobarbaz"}, new int[]{0}, new int[]{9}, new int[]{1}, false);
        this.testPatterns("foobarbaz", new String[]{"xx"}, new String[]{"foobarbaz"}, new int[]{0}, new int[]{9}, new int[]{1}, true);
        this.testPatterns("foo bar baz", new String[]{"xx"}, new String[]{"foo", "bar", "baz"}, new int[]{0, 4, 8}, new int[]{3, 7, 11}, new int[]{1, 1, 1}, false);
        this.testPatterns("foo bar baz", new String[]{"xx"}, new String[]{"foo", "bar", "baz"}, new int[]{0, 4, 8}, new int[]{3, 7, 11}, new int[]{1, 1, 1}, true);
    }

    public void testNoCapture() throws Exception {
        this.testPatterns("foobarbaz", new String[]{".."}, new String[]{"foobarbaz"}, new int[]{0}, new int[]{9}, new int[]{1}, false);
        this.testPatterns("foobarbaz", new String[]{".."}, new String[]{"foobarbaz"}, new int[]{0}, new int[]{9}, new int[]{1}, true);
        this.testPatterns("foo bar baz", new String[]{".."}, new String[]{"foo", "bar", "baz"}, new int[]{0, 4, 8}, new int[]{3, 7, 11}, new int[]{1, 1, 1}, false);
        this.testPatterns("foo bar baz", new String[]{".."}, new String[]{"foo", "bar", "baz"}, new int[]{0, 4, 8}, new int[]{3, 7, 11}, new int[]{1, 1, 1}, true);
    }

    public void testEmptyCapture() throws Exception {
        this.testPatterns("foobarbaz", new String[]{".(y*)"}, new String[]{"foobarbaz"}, new int[]{0}, new int[]{9}, new int[]{1}, false);
        this.testPatterns("foobarbaz", new String[]{".(y*)"}, new String[]{"foobarbaz"}, new int[]{0}, new int[]{9}, new int[]{1}, true);
        this.testPatterns("foo bar baz", new String[]{".(y*)"}, new String[]{"foo", "bar", "baz"}, new int[]{0, 4, 8}, new int[]{3, 7, 11}, new int[]{1, 1, 1}, false);
        this.testPatterns("foo bar baz", new String[]{".(y*)"}, new String[]{"foo", "bar", "baz"}, new int[]{0, 4, 8}, new int[]{3, 7, 11}, new int[]{1, 1, 1}, true);
    }

    public void testCaptureAll() throws Exception {
        this.testPatterns("foobarbaz", new String[]{"(.+)"}, new String[]{"foobarbaz"}, new int[]{0}, new int[]{9}, new int[]{1}, false);
        this.testPatterns("foobarbaz", new String[]{"(.+)"}, new String[]{"foobarbaz"}, new int[]{0}, new int[]{9}, new int[]{1}, true);
        this.testPatterns("foo bar baz", new String[]{"(.+)"}, new String[]{"foo", "bar", "baz"}, new int[]{0, 4, 8}, new int[]{3, 7, 11}, new int[]{1, 1, 1}, false);
        this.testPatterns("foo bar baz", new String[]{"(.+)"}, new String[]{"foo", "bar", "baz"}, new int[]{0, 4, 8}, new int[]{3, 7, 11}, new int[]{1, 1, 1}, true);
    }

    public void testCaptureStart() throws Exception {
        this.testPatterns("foobarbaz", new String[]{"^(.)"}, new String[]{"f"}, new int[]{0}, new int[]{9}, new int[]{1}, false);
        this.testPatterns("foobarbaz", new String[]{"^(.)"}, new String[]{"foobarbaz", "f"}, new int[]{0, 0}, new int[]{9, 9}, new int[]{1, 0}, true);
        this.testPatterns("foo bar baz", new String[]{"^(.)"}, new String[]{"f", "b", "b"}, new int[]{0, 4, 8}, new int[]{3, 7, 11}, new int[]{1, 1, 1}, false);
        this.testPatterns("foo bar baz", new String[]{"^(.)"}, new String[]{"foo", "f", "bar", "b", "baz", "b"}, new int[]{0, 0, 4, 4, 8, 8}, new int[]{3, 3, 7, 7, 11, 11}, new int[]{1, 0, 1, 0, 1, 0}, true);
    }

    public void testCaptureMiddle() throws Exception {
        this.testPatterns("foobarbaz", new String[]{"^.(.)."}, new String[]{"o"}, new int[]{0}, new int[]{9}, new int[]{1}, false);
        this.testPatterns("foobarbaz", new String[]{"^.(.)."}, new String[]{"foobarbaz", "o"}, new int[]{0, 0}, new int[]{9, 9}, new int[]{1, 0}, true);
        this.testPatterns("foo bar baz", new String[]{"^.(.)."}, new String[]{"o", "a", "a"}, new int[]{0, 4, 8}, new int[]{3, 7, 11}, new int[]{1, 1, 1}, false);
        this.testPatterns("foo bar baz", new String[]{"^.(.)."}, new String[]{"foo", "o", "bar", "a", "baz", "a"}, new int[]{0, 0, 4, 4, 8, 8}, new int[]{3, 3, 7, 7, 11, 11}, new int[]{1, 0, 1, 0, 1, 0}, true);
    }

    public void testCaptureEnd() throws Exception {
        this.testPatterns("foobarbaz", new String[]{"(.)$"}, new String[]{"z"}, new int[]{0}, new int[]{9}, new int[]{1}, false);
        this.testPatterns("foobarbaz", new String[]{"(.)$"}, new String[]{"foobarbaz", "z"}, new int[]{0, 0}, new int[]{9, 9}, new int[]{1, 0}, true);
        this.testPatterns("foo bar baz", new String[]{"(.)$"}, new String[]{"o", "r", "z"}, new int[]{0, 4, 8}, new int[]{3, 7, 11}, new int[]{1, 1, 1}, false);
        this.testPatterns("foo bar baz", new String[]{"(.)$"}, new String[]{"foo", "o", "bar", "r", "baz", "z"}, new int[]{0, 0, 4, 4, 8, 8}, new int[]{3, 3, 7, 7, 11, 11}, new int[]{1, 0, 1, 0, 1, 0}, true);
    }

    public void testCaptureStartMiddle() throws Exception {
        this.testPatterns("foobarbaz", new String[]{"^(.)(.)"}, new String[]{"f", "o"}, new int[]{0, 0}, new int[]{9, 9}, new int[]{1, 0}, false);
        this.testPatterns("foobarbaz", new String[]{"^(.)(.)"}, new String[]{"foobarbaz", "f", "o"}, new int[]{0, 0, 0}, new int[]{9, 9, 9}, new int[]{1, 0, 0}, true);
        this.testPatterns("foo bar baz", new String[]{"^(.)(.)"}, new String[]{"f", "o", "b", "a", "b", "a"}, new int[]{0, 0, 4, 4, 8, 8}, new int[]{3, 3, 7, 7, 11, 11}, new int[]{1, 0, 1, 0, 1, 0}, false);
        this.testPatterns("foo bar baz", new String[]{"^(.)(.)"}, new String[]{"foo", "f", "o", "bar", "b", "a", "baz", "b", "a"}, new int[]{0, 0, 0, 4, 4, 4, 8, 8, 8}, new int[]{3, 3, 3, 7, 7, 7, 11, 11, 11}, new int[]{1, 0, 0, 1, 0, 0, 1, 0, 0}, true);
    }

    public void testCaptureStartEnd() throws Exception {
        this.testPatterns("foobarbaz", new String[]{"^(.).+(.)$"}, new String[]{"f", "z"}, new int[]{0, 0}, new int[]{9, 9}, new int[]{1, 0}, false);
        this.testPatterns("foobarbaz", new String[]{"^(.).+(.)$"}, new String[]{"foobarbaz", "f", "z"}, new int[]{0, 0, 0}, new int[]{9, 9, 9}, new int[]{1, 0, 0}, true);
        this.testPatterns("foo bar baz", new String[]{"^(.).+(.)$"}, new String[]{"f", "o", "b", "r", "b", "z"}, new int[]{0, 0, 4, 4, 8, 8}, new int[]{3, 3, 7, 7, 11, 11}, new int[]{1, 0, 1, 0, 1, 0}, false);
        this.testPatterns("foo bar baz", new String[]{"^(.).+(.)$"}, new String[]{"foo", "f", "o", "bar", "b", "r", "baz", "b", "z"}, new int[]{0, 0, 0, 4, 4, 4, 8, 8, 8}, new int[]{3, 3, 3, 7, 7, 7, 11, 11, 11}, new int[]{1, 0, 0, 1, 0, 0, 1, 0, 0}, true);
    }

    public void testCaptureMiddleEnd() throws Exception {
        this.testPatterns("foobarbaz", new String[]{"(.)(.)$"}, new String[]{"a", "z"}, new int[]{0, 0}, new int[]{9, 9}, new int[]{1, 0}, false);
        this.testPatterns("foobarbaz", new String[]{"(.)(.)$"}, new String[]{"foobarbaz", "a", "z"}, new int[]{0, 0, 0}, new int[]{9, 9, 9}, new int[]{1, 0, 0}, true);
        this.testPatterns("foo bar baz", new String[]{"(.)(.)$"}, new String[]{"o", "o", "a", "r", "a", "z"}, new int[]{0, 0, 4, 4, 8, 8}, new int[]{3, 3, 7, 7, 11, 11}, new int[]{1, 0, 1, 0, 1, 0}, false);
        this.testPatterns("foo bar baz", new String[]{"(.)(.)$"}, new String[]{"foo", "o", "o", "bar", "a", "r", "baz", "a", "z"}, new int[]{0, 0, 0, 4, 4, 4, 8, 8, 8}, new int[]{3, 3, 3, 7, 7, 7, 11, 11, 11}, new int[]{1, 0, 0, 1, 0, 0, 1, 0, 0}, true);
    }

    public void testMultiCaptureOverlap() throws Exception {
        this.testPatterns("foobarbaz", new String[]{"(.(.(.)))"}, new String[]{"foo", "oo", "o", "bar", "ar", "r", "baz", "az", "z"}, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{9, 9, 9, 9, 9, 9, 9, 9, 9}, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0}, false);
        this.testPatterns("foobarbaz", new String[]{"(.(.(.)))"}, new String[]{"foobarbaz", "foo", "oo", "o", "bar", "ar", "r", "baz", "az", "z"}, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9}, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, true);
        this.testPatterns("foo bar baz", new String[]{"(.(.(.)))"}, new String[]{"foo", "oo", "o", "bar", "ar", "r", "baz", "az", "z"}, new int[]{0, 0, 0, 4, 4, 4, 8, 8, 8}, new int[]{3, 3, 3, 7, 7, 7, 11, 11, 11}, new int[]{1, 0, 0, 1, 0, 0, 1, 0, 0}, false);
        this.testPatterns("foo bar baz", new String[]{"(.(.(.)))"}, new String[]{"foo", "oo", "o", "bar", "ar", "r", "baz", "az", "z"}, new int[]{0, 0, 0, 4, 4, 4, 8, 8, 8}, new int[]{3, 3, 3, 7, 7, 7, 11, 11, 11}, new int[]{1, 0, 0, 1, 0, 0, 1, 0, 0}, true);
    }

    public void testMultiPattern() throws Exception {
        this.testPatterns("aaabbbaaa", new String[]{"(aaa)", "(bbb)", "(ccc)"}, new String[]{"aaa", "bbb", "aaa"}, new int[]{0, 0, 0}, new int[]{9, 9, 9}, new int[]{1, 0, 0}, false);
        this.testPatterns("aaabbbaaa", new String[]{"(aaa)", "(bbb)", "(ccc)"}, new String[]{"aaabbbaaa", "aaa", "bbb", "aaa"}, new int[]{0, 0, 0, 0}, new int[]{9, 9, 9, 9}, new int[]{1, 0, 0, 0}, true);
        this.testPatterns("aaa bbb aaa", new String[]{"(aaa)", "(bbb)", "(ccc)"}, new String[]{"aaa", "bbb", "aaa"}, new int[]{0, 4, 8}, new int[]{3, 7, 11}, new int[]{1, 1, 1}, false);
        this.testPatterns("aaa bbb aaa", new String[]{"(aaa)", "(bbb)", "(ccc)"}, new String[]{"aaa", "bbb", "aaa"}, new int[]{0, 4, 8}, new int[]{3, 7, 11}, new int[]{1, 1, 1}, true);
    }

    public void testCamelCase() throws Exception {
        this.testPatterns("letsPartyLIKEits1999_dude", new String[]{"([A-Z]{2,})", "(?<![A-Z])([A-Z][a-z]+)", "(?:^|\\b|(?<=[0-9_])|(?<=[A-Z]{2}))([a-z]+)", "([0-9]+)"}, new String[]{"lets", "Party", "LIKE", "its", "1999", "dude"}, new int[]{0, 0, 0, 0, 0, 0}, new int[]{25, 25, 25, 25, 25, 25}, new int[]{1, 0, 0, 0, 0, 0, 0}, false);
        this.testPatterns("letsPartyLIKEits1999_dude", new String[]{"([A-Z]{2,})", "(?<![A-Z])([A-Z][a-z]+)", "(?:^|\\b|(?<=[0-9_])|(?<=[A-Z]{2}))([a-z]+)", "([0-9]+)"}, new String[]{"letsPartyLIKEits1999_dude", "lets", "Party", "LIKE", "its", "1999", "dude"}, new int[]{0, 0, 0, 0, 0, 0, 0}, new int[]{25, 25, 25, 25, 25, 25, 25}, new int[]{1, 0, 0, 0, 0, 0, 0, 0}, true);
    }

    public void testRandomString() throws Exception {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new PatternCaptureGroupTokenFilter((TokenStream)tokenizer, false, new Pattern[]{Pattern.compile("((..)(..))")}));
            }
        };
        TestPatternCaptureGroupTokenFilter.checkRandomData((Random)TestPatternCaptureGroupTokenFilter.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
    }

    private void testPatterns(String input, String[] regexes, String[] tokens, int[] startOffsets, int[] endOffsets, int[] positions, boolean preserveOriginal) throws Exception {
        Pattern[] patterns = new Pattern[regexes.length];
        for (int i = 0; i < regexes.length; ++i) {
            patterns[i] = Pattern.compile(regexes[i]);
        }
        MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        tokenizer.setReader((Reader)new StringReader(input));
        PatternCaptureGroupTokenFilter ts = new PatternCaptureGroupTokenFilter((TokenStream)tokenizer, preserveOriginal, patterns);
        TestPatternCaptureGroupTokenFilter.assertTokenStreamContents((TokenStream)ts, (String[])tokens, (int[])startOffsets, (int[])endOffsets, (int[])positions);
    }
}

