/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pattern;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.pattern.PatternReplaceCharFilter;
import org.apache.lucene.util.TestUtil;
import org.junit.Ignore;

public class TestPatternReplaceCharFilter
extends BaseTokenStreamTestCase {
    public void testFailingDot() throws IOException {
        this.checkOutput("A. .B.", "\\.[\\s]*", ".", "A..B.", "A..B.");
    }

    public void testLongerReplacement() throws IOException {
        this.checkOutput("XXabcZZabcYY", "abc", "abcde", "XXabcdeZZabcdeYY", "XXabcccZZabcccYY");
        this.checkOutput("XXabcabcYY", "abc", "abcde", "XXabcdeabcdeYY", "XXabcccabcccYY");
        this.checkOutput("abcabcYY", "abc", "abcde", "abcdeabcdeYY", "abcccabcccYY");
        this.checkOutput("YY", "^", "abcde", "abcdeYY", "YYYYYYY");
        this.checkOutput("YY", "$", "abcde", "YYabcde", "YYYYYYY");
        this.checkOutput("XYZ", ".", "abc", "abcabcabc", "XXXYYYZZZ");
        this.checkOutput("XYZ", ".", "$0abc", "XabcYabcZabc", "XXXXYYYYZZZZ");
    }

    public void testShorterReplacement() throws IOException {
        this.checkOutput("XXabcZZabcYY", "abc", "xy", "XXxyZZxyYY", "XXabZZabYY");
        this.checkOutput("XXabcabcYY", "abc", "xy", "XXxyxyYY", "XXababYY");
        this.checkOutput("abcabcYY", "abc", "xy", "xyxyYY", "ababYY");
        this.checkOutput("abcabcYY", "abc", "", "YY", "YY");
        this.checkOutput("YYabcabc", "abc", "", "YY", "YY");
    }

    private void checkOutput(String input, String pattern, String replacement, String expectedOutput, String expectedIndexMatchedOutput) throws IOException {
        PatternReplaceCharFilter cs = new PatternReplaceCharFilter(this.pattern(pattern), replacement, (Reader)new StringReader(input));
        StringBuilder output = new StringBuilder();
        int chr = cs.read();
        while (chr > 0) {
            output.append((char)chr);
            chr = cs.read();
        }
        StringBuilder indexMatched = new StringBuilder();
        for (int i = 0; i < output.length(); ++i) {
            indexMatched.append(cs.correctOffset(i) < 0 ? "-" : Character.valueOf(input.charAt(cs.correctOffset(i))));
        }
        boolean outputGood = expectedOutput.equals(output.toString());
        boolean indexMatchedGood = expectedIndexMatchedOutput.equals(indexMatched.toString());
        if (!outputGood || !indexMatchedGood) {
            System.out.println("Pattern : " + pattern);
            System.out.println("Replac. : " + replacement);
            System.out.println("Input   : " + input);
            System.out.println("Output  : " + output);
            System.out.println("Expected: " + expectedOutput);
            System.out.println("Output/i: " + indexMatched);
            System.out.println("Expected: " + expectedIndexMatchedOutput);
            System.out.println();
        }
        TestPatternReplaceCharFilter.assertTrue((String)"Output doesn't match.", (boolean)outputGood);
        TestPatternReplaceCharFilter.assertTrue((String)"Index-matched output doesn't match.", (boolean)indexMatchedGood);
    }

    public void testNothingChange() throws IOException {
        String BLOCK = "this is test.";
        PatternReplaceCharFilter cs = new PatternReplaceCharFilter(this.pattern("(aa)\\s+(bb)\\s+(cc)"), "$1$2$3", (Reader)new StringReader("this is test."));
        MockTokenizer ts = TestPatternReplaceCharFilter.whitespaceMockTokenizer((Reader)cs);
        TestPatternReplaceCharFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"this", "is", "test."}, (int[])new int[]{0, 5, 8}, (int[])new int[]{4, 7, 13}, (Integer)"this is test.".length());
    }

    public void testReplaceByEmpty() throws IOException {
        String BLOCK = "aa bb cc";
        PatternReplaceCharFilter cs = new PatternReplaceCharFilter(this.pattern("(aa)\\s+(bb)\\s+(cc)"), "", (Reader)new StringReader("aa bb cc"));
        MockTokenizer ts = TestPatternReplaceCharFilter.whitespaceMockTokenizer((Reader)cs);
        TestPatternReplaceCharFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[0]);
    }

    public void test1block1matchSameLength() throws IOException {
        String BLOCK = "aa bb cc";
        PatternReplaceCharFilter cs = new PatternReplaceCharFilter(this.pattern("(aa)\\s+(bb)\\s+(cc)"), "$1#$2#$3", (Reader)new StringReader("aa bb cc"));
        MockTokenizer ts = TestPatternReplaceCharFilter.whitespaceMockTokenizer((Reader)cs);
        TestPatternReplaceCharFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"aa#bb#cc"}, (int[])new int[]{0}, (int[])new int[]{8}, (Integer)"aa bb cc".length());
    }

    public void test1block1matchLonger() throws IOException {
        String BLOCK = "aa bb cc dd";
        PatternReplaceCharFilter cs = new PatternReplaceCharFilter(this.pattern("(aa)\\s+(bb)\\s+(cc)"), "$1##$2###$3", (Reader)new StringReader("aa bb cc dd"));
        MockTokenizer ts = TestPatternReplaceCharFilter.whitespaceMockTokenizer((Reader)cs);
        TestPatternReplaceCharFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"aa##bb###cc", "dd"}, (int[])new int[]{0, 9}, (int[])new int[]{8, 11}, (Integer)"aa bb cc dd".length());
    }

    public void test1block2matchLonger() throws IOException {
        String BLOCK = " a  a";
        PatternReplaceCharFilter cs = new PatternReplaceCharFilter(this.pattern("a"), "aa", (Reader)new StringReader(" a  a"));
        MockTokenizer ts = TestPatternReplaceCharFilter.whitespaceMockTokenizer((Reader)cs);
        TestPatternReplaceCharFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"aa", "aa"}, (int[])new int[]{1, 4}, (int[])new int[]{2, 5}, (Integer)" a  a".length());
    }

    public void test1block1matchShorter() throws IOException {
        String BLOCK = "aa  bb   cc dd";
        PatternReplaceCharFilter cs = new PatternReplaceCharFilter(this.pattern("(aa)\\s+(bb)\\s+(cc)"), "$1#$2", (Reader)new StringReader("aa  bb   cc dd"));
        MockTokenizer ts = TestPatternReplaceCharFilter.whitespaceMockTokenizer((Reader)cs);
        TestPatternReplaceCharFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"aa#bb", "dd"}, (int[])new int[]{0, 12}, (int[])new int[]{11, 14}, (Integer)"aa  bb   cc dd".length());
    }

    public void test1blockMultiMatches() throws IOException {
        String BLOCK = "  aa bb cc --- aa bb aa   bb   cc";
        PatternReplaceCharFilter cs = new PatternReplaceCharFilter(this.pattern("(aa)\\s+(bb)\\s+(cc)"), "$1  $2  $3", (Reader)new StringReader("  aa bb cc --- aa bb aa   bb   cc"));
        MockTokenizer ts = TestPatternReplaceCharFilter.whitespaceMockTokenizer((Reader)cs);
        TestPatternReplaceCharFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"aa", "bb", "cc", "---", "aa", "bb", "aa", "bb", "cc"}, (int[])new int[]{2, 6, 9, 11, 15, 18, 21, 25, 29}, (int[])new int[]{4, 8, 10, 14, 17, 20, 23, 27, 33}, (Integer)"  aa bb cc --- aa bb aa   bb   cc".length());
    }

    public void test2blocksMultiMatches() throws IOException {
        String BLOCK = "  aa bb cc --- aa bb aa. bb aa   bb cc";
        PatternReplaceCharFilter cs = new PatternReplaceCharFilter(this.pattern("(aa)\\s+(bb)"), "$1##$2", (Reader)new StringReader("  aa bb cc --- aa bb aa. bb aa   bb cc"));
        MockTokenizer ts = TestPatternReplaceCharFilter.whitespaceMockTokenizer((Reader)cs);
        TestPatternReplaceCharFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"aa##bb", "cc", "---", "aa##bb", "aa.", "bb", "aa##bb", "cc"}, (int[])new int[]{2, 8, 11, 15, 21, 25, 28, 36}, (int[])new int[]{7, 10, 14, 20, 24, 27, 35, 38}, (Integer)"  aa bb cc --- aa bb aa. bb aa   bb cc".length());
    }

    public void testChain() throws IOException {
        String BLOCK = " a bb - ccc . --- bb a . ccc ccc bb";
        PatternReplaceCharFilter cs = new PatternReplaceCharFilter(this.pattern("a"), "aa", (Reader)new StringReader(" a bb - ccc . --- bb a . ccc ccc bb"));
        cs = new PatternReplaceCharFilter(this.pattern("bb"), "b", (Reader)cs);
        cs = new PatternReplaceCharFilter(this.pattern("ccc"), "c", (Reader)cs);
        MockTokenizer ts = TestPatternReplaceCharFilter.whitespaceMockTokenizer((Reader)cs);
        TestPatternReplaceCharFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"aa", "b", "-", "c", ".", "---", "b", "aa", ".", "c", "c", "b"}, (int[])new int[]{1, 3, 6, 8, 12, 14, 18, 21, 23, 25, 29, 33}, (int[])new int[]{2, 5, 7, 11, 13, 17, 20, 22, 24, 28, 32, 35}, (Integer)" a bb - ccc . --- bb a . ccc ccc bb".length());
    }

    private Pattern pattern(String p) {
        return Pattern.compile(p);
    }

    @Ignore
    public void testNastyPattern() throws Exception {
        Pattern p = Pattern.compile("(c.+)*xy");
        String input = "[;<!--aecbbaa--><    febcfdc fbb = \"fbeeebff\" fc = dd   >\\';<eefceceaa e= babae\" eacbaff =\"fcfaccacd\" = bcced>>><  bccaafe edb = ecfccdff\"   <?</script><    edbd ebbcd=\"faacfcc\" aeca= bedbc ceeaac =adeafde aadccdaf = \"afcc ffda=aafbe &#x16921ed5\"1843785582']";
        for (int i = 0; i < input.length(); ++i) {
            Matcher matcher = p.matcher(input.substring(0, i));
            long t = System.currentTimeMillis();
            if (matcher.find()) {
                System.out.println(matcher.group());
            }
            System.out.println(i + " > " + (double)(System.currentTimeMillis() - t) / 1000.0);
        }
    }

    public void testRandomStrings() throws Exception {
        int numPatterns = 10 + TestPatternReplaceCharFilter.random().nextInt(20);
        Random random = new Random(TestPatternReplaceCharFilter.random().nextLong());
        for (int i = 0; i < numPatterns; ++i) {
            final Pattern p = TestUtil.randomPattern((Random)TestPatternReplaceCharFilter.random());
            final String replacement = TestUtil.randomSimpleString((Random)random);
            Analyzer a = new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                    return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)tokenizer);
                }

                protected Reader initReader(String fieldName, Reader reader) {
                    return new PatternReplaceCharFilter(p, replacement, reader);
                }
            };
            int maxInputLength = 30;
            boolean asciiOnly = true;
            TestPatternReplaceCharFilter.checkRandomData((Random)random, (Analyzer)a, (int)(250 * RANDOM_MULTIPLIER), (int)30, (boolean)true);
            a.close();
        }
    }
}

