/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pattern;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestPatternReplaceCharFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testNothingChange() throws Exception {
        Reader reader = new StringReader("this is test.");
        reader = this.charFilterFactory("PatternReplace", "pattern", "(aa)\\s+(bb)\\s+(cc)", "replacement", "$1$2$3").create(reader);
        MockTokenizer ts = TestPatternReplaceCharFilterFactory.whitespaceMockTokenizer((Reader)reader);
        TestPatternReplaceCharFilterFactory.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"this", "is", "test."}, (int[])new int[]{0, 5, 8}, (int[])new int[]{4, 7, 13});
    }

    public void testReplaceByEmpty() throws Exception {
        Reader reader = new StringReader("aa bb cc");
        reader = this.charFilterFactory("PatternReplace", "pattern", "(aa)\\s+(bb)\\s+(cc)").create(reader);
        MockTokenizer ts = TestPatternReplaceCharFilterFactory.whitespaceMockTokenizer((Reader)reader);
        TestPatternReplaceCharFilterFactory.assertTokenStreamContents((TokenStream)ts, (String[])new String[0]);
    }

    public void test1block1matchSameLength() throws Exception {
        Reader reader = new StringReader("aa bb cc");
        reader = this.charFilterFactory("PatternReplace", "pattern", "(aa)\\s+(bb)\\s+(cc)", "replacement", "$1#$2#$3").create(reader);
        MockTokenizer ts = TestPatternReplaceCharFilterFactory.whitespaceMockTokenizer((Reader)reader);
        TestPatternReplaceCharFilterFactory.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"aa#bb#cc"}, (int[])new int[]{0}, (int[])new int[]{8});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestPatternReplaceCharFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.charFilterFactory("PatternReplace", "pattern", "something", "bogusArg", "bogusValue"));
        TestPatternReplaceCharFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

