/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pattern;

import java.io.IOException;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.pattern.PatternReplaceFilter;

public class TestPatternReplaceFilter
extends BaseTokenStreamTestCase {
    public void testReplaceAll() throws Exception {
        String input = "aabfooaabfooabfoob ab caaaaaaaaab";
        PatternReplaceFilter ts = new PatternReplaceFilter((TokenStream)TestPatternReplaceFilter.whitespaceMockTokenizer((String)input), Pattern.compile("a*b"), "-", true);
        TestPatternReplaceFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"-foo-foo-foo-", "-", "c-"});
    }

    public void testReplaceFirst() throws Exception {
        String input = "aabfooaabfooabfoob ab caaaaaaaaab";
        PatternReplaceFilter ts = new PatternReplaceFilter((TokenStream)TestPatternReplaceFilter.whitespaceMockTokenizer((String)input), Pattern.compile("a*b"), "-", false);
        TestPatternReplaceFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"-fooaabfooabfoob", "-", "c-"});
    }

    public void testStripFirst() throws Exception {
        String input = "aabfooaabfooabfoob ab caaaaaaaaab";
        PatternReplaceFilter ts = new PatternReplaceFilter((TokenStream)TestPatternReplaceFilter.whitespaceMockTokenizer((String)input), Pattern.compile("a*b"), null, false);
        TestPatternReplaceFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"fooaabfooabfoob", "", "c"});
    }

    public void testStripAll() throws Exception {
        String input = "aabfooaabfooabfoob ab caaaaaaaaab";
        PatternReplaceFilter ts = new PatternReplaceFilter((TokenStream)TestPatternReplaceFilter.whitespaceMockTokenizer((String)input), Pattern.compile("a*b"), null, true);
        TestPatternReplaceFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"foofoofoo", "", "c"});
    }

    public void testReplaceAllWithBackRef() throws Exception {
        String input = "aabfooaabfooabfoob ab caaaaaaaaab";
        PatternReplaceFilter ts = new PatternReplaceFilter((TokenStream)TestPatternReplaceFilter.whitespaceMockTokenizer((String)input), Pattern.compile("(a*)b"), "$1\\$", true);
        TestPatternReplaceFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"aa$fooaa$fooa$foo$", "a$", "caaaaaaaaa$"});
    }

    public void testRandomStrings() throws Exception {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                PatternReplaceFilter filter = new PatternReplaceFilter((TokenStream)tokenizer, Pattern.compile("a"), "b", false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)filter);
            }
        };
        TestPatternReplaceFilter.checkRandomData((Random)TestPatternReplaceFilter.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
        Analyzer b = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                PatternReplaceFilter filter = new PatternReplaceFilter((TokenStream)tokenizer, Pattern.compile("a"), "b", true);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)filter);
            }
        };
        TestPatternReplaceFilter.checkRandomData((Random)TestPatternReplaceFilter.random(), (Analyzer)b, (int)(1000 * RANDOM_MULTIPLIER));
        b.close();
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new PatternReplaceFilter((TokenStream)tokenizer, Pattern.compile("a"), "b", true));
            }
        };
        TestPatternReplaceFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

