/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pattern;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestPatternReplaceFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testReplaceAll() throws Exception {
        StringReader reader = new StringReader("aabfooaabfooabfoob ab caaaaaaaaab");
        MockTokenizer stream = TestPatternReplaceFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("PatternReplace", "pattern", "a*b", "replacement", "-").create((TokenStream)stream);
        TestPatternReplaceFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"-foo-foo-foo-", "-", "c-"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestPatternReplaceFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("PatternReplace", "pattern", "something", "bogusArg", "bogusValue"));
        TestPatternReplaceFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

