/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pattern;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.charfilter.MappingCharFilter;
import org.apache.lucene.analysis.charfilter.NormalizeCharMap;
import org.apache.lucene.analysis.pattern.PatternTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class TestPatternTokenizer
extends BaseTokenStreamTestCase {
    public void testSplitting() throws Exception {
        String[][] tests;
        String qpattern = "\\'([^\\']+)\\'";
        for (String[] test : tests = new String[][]{{"-1", "--", "aaa--bbb--ccc", "aaa bbb ccc"}, {"-1", ":", "aaa:bbb:ccc", "aaa bbb ccc"}, {"-1", "\\p{Space}", "aaa   bbb \t\tccc  ", "aaa bbb ccc"}, {"-1", ":", "boo:and:foo", "boo and foo"}, {"-1", "o", "boo:and:foo", "b :and:f"}, {"0", ":", "boo:and:foo", ": :"}, {"0", qpattern, "aaa 'bbb' 'ccc'", "'bbb' 'ccc'"}, {"1", qpattern, "aaa 'bbb' 'ccc'", "bbb ccc"}}) {
            PatternTokenizer stream = new PatternTokenizer(TestPatternTokenizer.newAttributeFactory(), Pattern.compile(test[1]), Integer.parseInt(test[0]));
            ((Tokenizer)stream).setReader((Reader)new StringReader(test[2]));
            String out = TestPatternTokenizer.tsToString((TokenStream)stream);
            TestPatternTokenizer.assertEquals((String)("pattern: " + test[1] + " with input: " + test[2]), (Object)test[3], (Object)out);
        }
    }

    public void testOffsetCorrection() throws Exception {
        String INPUT = "G&uuml;nther G&uuml;nther is here";
        ArrayList<String> mappingRules = new ArrayList<String>();
        mappingRules.add("\"&uuml;\" => \"\u00fc\"");
        NormalizeCharMap.Builder builder = new NormalizeCharMap.Builder();
        builder.add("&uuml;", "\u00fc");
        NormalizeCharMap normMap = builder.build();
        MappingCharFilter charStream = new MappingCharFilter(normMap, (Reader)new StringReader("G&uuml;nther G&uuml;nther is here"));
        PatternTokenizer stream = new PatternTokenizer(TestPatternTokenizer.newAttributeFactory(), Pattern.compile("[,;/\\s]+"), -1);
        stream.setReader((Reader)charStream);
        TestPatternTokenizer.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"G\u00fcnther", "G\u00fcnther", "is", "here"}, (int[])new int[]{0, 13, 26, 29}, (int[])new int[]{12, 25, 28, 33}, (Integer)"G&uuml;nther G&uuml;nther is here".length());
        charStream = new MappingCharFilter(normMap, (Reader)new StringReader("G&uuml;nther G&uuml;nther is here"));
        stream = new PatternTokenizer(TestPatternTokenizer.newAttributeFactory(), Pattern.compile("G\u00fcnther"), 0);
        stream.setReader((Reader)charStream);
        TestPatternTokenizer.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"G\u00fcnther", "G\u00fcnther"}, (int[])new int[]{0, 13}, (int[])new int[]{12, 25}, (Integer)"G&uuml;nther G&uuml;nther is here".length());
    }

    private static String tsToString(TokenStream in) throws IOException {
        StringBuilder out = new StringBuilder();
        CharTermAttribute termAtt = (CharTermAttribute)in.addAttribute(CharTermAttribute.class);
        in.clearAttributes();
        termAtt.setEmpty().append("bogusTerm");
        in.reset();
        while (in.incrementToken()) {
            if (out.length() > 0) {
                out.append(' ');
            }
            out.append(termAtt.toString());
            in.clearAttributes();
            termAtt.setEmpty().append("bogusTerm");
        }
        in.close();
        return out.toString();
    }

    public void testRandomStrings() throws Exception {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                PatternTokenizer tokenizer = new PatternTokenizer(BaseTokenStreamTestCase.newAttributeFactory(), Pattern.compile("a"), -1);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer);
            }
        };
        TestPatternTokenizer.checkRandomData((Random)TestPatternTokenizer.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
        Analyzer b = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                PatternTokenizer tokenizer = new PatternTokenizer(BaseTokenStreamTestCase.newAttributeFactory(), Pattern.compile("a"), 0);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer);
            }
        };
        TestPatternTokenizer.checkRandomData((Random)TestPatternTokenizer.random(), (Analyzer)b, (int)(1000 * RANDOM_MULTIPLIER));
        b.close();
    }

    public void testHeapFreedAfterClose() throws Exception {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 1024; ++i) {
            for (int j = 0; j < 1023; ++j) {
                b.append(' ');
            }
            b.append('x');
        }
        String big = b.toString();
        Pattern x = Pattern.compile("x");
        ArrayList<PatternTokenizer> tokenizers = new ArrayList<PatternTokenizer>();
        for (int i = 0; i < 512; ++i) {
            PatternTokenizer stream = new PatternTokenizer(x, -1);
            tokenizers.add(stream);
            stream.setReader((Reader)new StringReader(big));
            stream.reset();
            for (int j = 0; j < 1024; ++j) {
                TestPatternTokenizer.assertTrue((boolean)stream.incrementToken());
            }
            TestPatternTokenizer.assertFalse((boolean)stream.incrementToken());
            stream.end();
            stream.close();
        }
    }
}

