/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pattern;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestPatternTokenizerFactory
extends BaseTokenStreamFactoryTestCase {
    public void testFactory() throws Exception {
        StringReader reader = new StringReader("G\u00fcnther G\u00fcnther is here");
        Tokenizer stream = this.tokenizerFactory("Pattern", "pattern", "[,;/\\s]+").create(TestPatternTokenizerFactory.newAttributeFactory());
        stream.setReader((Reader)reader);
        TestPatternTokenizerFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"G\u00fcnther", "G\u00fcnther", "is", "here"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestPatternTokenizerFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenizerFactory("Pattern", "pattern", "something", "bogusArg", "bogusValue"));
        TestPatternTokenizerFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

