/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pattern;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.charfilter.MappingCharFilter;
import org.apache.lucene.analysis.charfilter.NormalizeCharMap;
import org.apache.lucene.analysis.pattern.SimplePatternSplitTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.util.TestUtil;
import org.apache.lucene.util.automaton.Automaton;

public class TestSimplePatternSplitTokenizer
extends BaseTokenStreamTestCase {
    public void testGreedy() throws Exception {
        SimplePatternSplitTokenizer t = new SimplePatternSplitTokenizer("(foo)+");
        t.setReader((Reader)new StringReader("bar foofoo baz"));
        TestSimplePatternSplitTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"bar ", " baz"}, (int[])new int[]{0, 10}, (int[])new int[]{4, 14});
    }

    public void testBackToBack() throws Exception {
        SimplePatternSplitTokenizer t = new SimplePatternSplitTokenizer("foo");
        t.setReader((Reader)new StringReader("bar foofoo baz"));
        TestSimplePatternSplitTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"bar ", " baz"}, (int[])new int[]{0, 10}, (int[])new int[]{4, 14});
    }

    public void testBigLookahead() throws Exception {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            b.append('a');
        }
        b.append('b');
        SimplePatternSplitTokenizer t = new SimplePatternSplitTokenizer(b.toString());
        CharTermAttribute termAtt = (CharTermAttribute)t.getAttribute(CharTermAttribute.class);
        b = new StringBuilder();
        for (int i = 0; i < 200; ++i) {
            b.append('a');
        }
        t.setReader((Reader)new StringReader(b.toString()));
        t.reset();
        TestSimplePatternSplitTokenizer.assertTrue((boolean)t.incrementToken());
        TestSimplePatternSplitTokenizer.assertEquals((Object)b.toString(), (Object)termAtt.toString());
        TestSimplePatternSplitTokenizer.assertFalse((boolean)t.incrementToken());
    }

    public void testNoTokens() throws Exception {
        String s;
        SimplePatternSplitTokenizer t = new SimplePatternSplitTokenizer(".*");
        CharTermAttribute termAtt = (CharTermAttribute)t.getAttribute(CharTermAttribute.class);
        while ((s = TestUtil.randomUnicodeString((Random)TestSimplePatternSplitTokenizer.random())).length() <= 0) {
        }
        t.setReader((Reader)new StringReader(s));
        t.reset();
        TestSimplePatternSplitTokenizer.assertFalse((boolean)t.incrementToken());
    }

    public void testEmptyStringPatternNoMatch() throws Exception {
        SimplePatternSplitTokenizer t = new SimplePatternSplitTokenizer("a*");
        CharTermAttribute termAtt = (CharTermAttribute)t.getAttribute(CharTermAttribute.class);
        t.setReader((Reader)new StringReader("bbb"));
        t.reset();
        TestSimplePatternSplitTokenizer.assertTrue((boolean)t.incrementToken());
        TestSimplePatternSplitTokenizer.assertEquals((Object)"bbb", (Object)termAtt.toString());
        TestSimplePatternSplitTokenizer.assertFalse((boolean)t.incrementToken());
    }

    public void testSplitSingleCharWhitespace() throws Exception {
        SimplePatternSplitTokenizer t = new SimplePatternSplitTokenizer("[ \t\r\n]");
        CharTermAttribute termAtt = (CharTermAttribute)t.getAttribute(CharTermAttribute.class);
        t.setReader((Reader)new StringReader("a \tb   c"));
        TestSimplePatternSplitTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"a", "b", "c"}, (int[])new int[]{0, 3, 7}, (int[])new int[]{1, 4, 8});
    }

    public void testSplitMultiCharWhitespace() throws Exception {
        SimplePatternSplitTokenizer t = new SimplePatternSplitTokenizer("[ \t\r\n]*");
        CharTermAttribute termAtt = (CharTermAttribute)t.getAttribute(CharTermAttribute.class);
        t.setReader((Reader)new StringReader("a \tb   c"));
        TestSimplePatternSplitTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"a", "b", "c"}, (int[])new int[]{0, 3, 7}, (int[])new int[]{1, 4, 8});
    }

    public void testLeadingNonToken() throws Exception {
        SimplePatternSplitTokenizer t = new SimplePatternSplitTokenizer("[ \t\r\n]*");
        CharTermAttribute termAtt = (CharTermAttribute)t.getAttribute(CharTermAttribute.class);
        t.setReader((Reader)new StringReader("    a c"));
        TestSimplePatternSplitTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"a", "c"}, (int[])new int[]{4, 6}, (int[])new int[]{5, 7});
    }

    public void testTrailingNonToken() throws Exception {
        SimplePatternSplitTokenizer t = new SimplePatternSplitTokenizer("[ \t\r\n]*");
        CharTermAttribute termAtt = (CharTermAttribute)t.getAttribute(CharTermAttribute.class);
        t.setReader((Reader)new StringReader("a c   "));
        TestSimplePatternSplitTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"a", "c"}, (int[])new int[]{0, 2}, (int[])new int[]{1, 3});
    }

    public void testEmptyStringPatternOneMatch() throws Exception {
        SimplePatternSplitTokenizer t = new SimplePatternSplitTokenizer("a*");
        CharTermAttribute termAtt = (CharTermAttribute)t.getAttribute(CharTermAttribute.class);
        t.setReader((Reader)new StringReader("bbab"));
        TestSimplePatternSplitTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"bb", "b"}, (int[])new int[]{0, 3}, (int[])new int[]{2, 4});
    }

    public void testEndOffset() throws Exception {
        SimplePatternSplitTokenizer t = new SimplePatternSplitTokenizer("a+");
        CharTermAttribute termAtt = (CharTermAttribute)t.getAttribute(CharTermAttribute.class);
        OffsetAttribute offsetAtt = (OffsetAttribute)t.getAttribute(OffsetAttribute.class);
        t.setReader((Reader)new StringReader("aaabbb"));
        t.reset();
        TestSimplePatternSplitTokenizer.assertTrue((boolean)t.incrementToken());
        TestSimplePatternSplitTokenizer.assertEquals((Object)"bbb", (Object)termAtt.toString());
        TestSimplePatternSplitTokenizer.assertFalse((boolean)t.incrementToken());
        t.end();
        TestSimplePatternSplitTokenizer.assertEquals((long)6L, (long)offsetAtt.endOffset());
    }

    public void testFixedToken() throws Exception {
        SimplePatternSplitTokenizer t = new SimplePatternSplitTokenizer("aaaa");
        t.setReader((Reader)new StringReader("aaaaaaaaaaaaaaa"));
        TestSimplePatternSplitTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"aaa"}, (int[])new int[]{12}, (int[])new int[]{15});
    }

    public void testBasic() throws Exception {
        String[][] tests;
        for (String[] test : tests = new String[][]{{"--", "aaa--bbb--ccc", "aaa bbb ccc"}, {":", "aaa:bbb:ccc", "aaa bbb ccc"}, {":", "boo:and:foo", "boo and foo"}, {"o", "boo:and:foo", "b :and:f"}}) {
            SimplePatternSplitTokenizer stream = new SimplePatternSplitTokenizer(test[0]);
            ((Tokenizer)stream).setReader((Reader)new StringReader(test[1]));
            String out = TestSimplePatternSplitTokenizer.tsToString((TokenStream)stream);
            TestSimplePatternSplitTokenizer.assertEquals((String)("pattern: " + test[0] + " with input: " + test[1]), (Object)test[2], (Object)out);
        }
    }

    public void testNotDeterminized() throws Exception {
        Automaton a = new Automaton();
        int start = a.createState();
        int mid1 = a.createState();
        int mid2 = a.createState();
        int end = a.createState();
        a.setAccept(end, true);
        a.addTransition(start, mid1, 97, 122);
        a.addTransition(start, mid2, 97, 122);
        a.addTransition(mid1, end, 98);
        a.addTransition(mid2, end, 98);
        TestSimplePatternSplitTokenizer.expectThrows(IllegalArgumentException.class, () -> new SimplePatternSplitTokenizer(a));
    }

    public void testOffsetCorrection() throws Exception {
        String INPUT = "G&uuml;nther G&uuml;nther is here";
        ArrayList<String> mappingRules = new ArrayList<String>();
        mappingRules.add("\"&uuml;\" => \"\u00fc\"");
        NormalizeCharMap.Builder builder = new NormalizeCharMap.Builder();
        builder.add("&uuml;", "\u00fc");
        NormalizeCharMap normMap = builder.build();
        MappingCharFilter charStream = new MappingCharFilter(normMap, (Reader)new StringReader("G&uuml;nther G&uuml;nther is here"));
        SimplePatternSplitTokenizer stream = new SimplePatternSplitTokenizer("G\u00fcnther");
        stream.setReader((Reader)charStream);
        TestSimplePatternSplitTokenizer.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{" ", " is here"}, (int[])new int[]{12, 25}, (int[])new int[]{13, 33}, (Integer)"G&uuml;nther G&uuml;nther is here".length());
    }

    private static String tsToString(TokenStream in) throws IOException {
        StringBuilder out = new StringBuilder();
        CharTermAttribute termAtt = (CharTermAttribute)in.addAttribute(CharTermAttribute.class);
        in.clearAttributes();
        termAtt.setEmpty().append("bogusTerm");
        in.reset();
        while (in.incrementToken()) {
            if (out.length() > 0) {
                out.append(' ');
            }
            out.append(termAtt.toString());
            in.clearAttributes();
            termAtt.setEmpty().append("bogusTerm");
        }
        in.close();
        return out.toString();
    }

    public void testRandomStrings() throws Exception {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                SimplePatternSplitTokenizer tokenizer = new SimplePatternSplitTokenizer("a");
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer);
            }
        };
        TestSimplePatternSplitTokenizer.checkRandomData((Random)TestSimplePatternSplitTokenizer.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
        Analyzer b = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                SimplePatternSplitTokenizer tokenizer = new SimplePatternSplitTokenizer("a");
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer);
            }
        };
        TestSimplePatternSplitTokenizer.checkRandomData((Random)TestSimplePatternSplitTokenizer.random(), (Analyzer)b, (int)(1000 * RANDOM_MULTIPLIER));
        b.close();
    }

    public void testEndLookahead() throws Exception {
        SimplePatternSplitTokenizer t = new SimplePatternSplitTokenizer("(ab)+");
        t.setReader((Reader)new StringReader("aba"));
        TestSimplePatternSplitTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"a"}, (int[])new int[]{2}, (int[])new int[]{3}, (Integer)3);
    }
}

