/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pattern;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.charfilter.MappingCharFilter;
import org.apache.lucene.analysis.charfilter.NormalizeCharMap;
import org.apache.lucene.analysis.pattern.SimplePatternTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.util.TestUtil;
import org.apache.lucene.util.automaton.Automaton;

public class TestSimplePatternTokenizer
extends BaseTokenStreamTestCase {
    public void testGreedy() throws Exception {
        SimplePatternTokenizer t = new SimplePatternTokenizer("(foo)+");
        t.setReader((Reader)new StringReader("bar foofoo baz"));
        TestSimplePatternTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"foofoo"}, (int[])new int[]{4}, (int[])new int[]{10});
    }

    public void testBigLookahead() throws Exception {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            b.append('a');
        }
        b.append('b');
        SimplePatternTokenizer t = new SimplePatternTokenizer(b.toString());
        b = new StringBuilder();
        for (int i = 0; i < 200; ++i) {
            b.append('a');
        }
        t.setReader((Reader)new StringReader(b.toString()));
        t.reset();
        TestSimplePatternTokenizer.assertFalse((boolean)t.incrementToken());
    }

    public void testOneToken() throws Exception {
        String s;
        SimplePatternTokenizer t = new SimplePatternTokenizer(".*");
        CharTermAttribute termAtt = (CharTermAttribute)t.getAttribute(CharTermAttribute.class);
        while ((s = TestUtil.randomUnicodeString((Random)TestSimplePatternTokenizer.random())).length() <= 0) {
        }
        t.setReader((Reader)new StringReader(s));
        t.reset();
        TestSimplePatternTokenizer.assertTrue((boolean)t.incrementToken());
        TestSimplePatternTokenizer.assertEquals((Object)s, (Object)termAtt.toString());
    }

    public void testEmptyStringPatternNoMatch() throws Exception {
        SimplePatternTokenizer t = new SimplePatternTokenizer("a*");
        t.setReader((Reader)new StringReader("bbb"));
        t.reset();
        TestSimplePatternTokenizer.assertFalse((boolean)t.incrementToken());
    }

    public void testEmptyStringPatternOneMatch() throws Exception {
        SimplePatternTokenizer t = new SimplePatternTokenizer("a*");
        CharTermAttribute termAtt = (CharTermAttribute)t.getAttribute(CharTermAttribute.class);
        t.setReader((Reader)new StringReader("bbab"));
        t.reset();
        TestSimplePatternTokenizer.assertTrue((boolean)t.incrementToken());
        TestSimplePatternTokenizer.assertEquals((Object)"a", (Object)termAtt.toString());
        TestSimplePatternTokenizer.assertFalse((boolean)t.incrementToken());
    }

    public void testEndOffset() throws Exception {
        SimplePatternTokenizer t = new SimplePatternTokenizer("a+");
        CharTermAttribute termAtt = (CharTermAttribute)t.getAttribute(CharTermAttribute.class);
        OffsetAttribute offsetAtt = (OffsetAttribute)t.getAttribute(OffsetAttribute.class);
        t.setReader((Reader)new StringReader("aaabbb"));
        t.reset();
        TestSimplePatternTokenizer.assertTrue((boolean)t.incrementToken());
        TestSimplePatternTokenizer.assertEquals((Object)"aaa", (Object)termAtt.toString());
        TestSimplePatternTokenizer.assertFalse((boolean)t.incrementToken());
        t.end();
        TestSimplePatternTokenizer.assertEquals((long)6L, (long)offsetAtt.endOffset());
    }

    public void testFixedToken() throws Exception {
        SimplePatternTokenizer t = new SimplePatternTokenizer("aaaa");
        t.setReader((Reader)new StringReader("aaaaaaaaaaaaaaa"));
        TestSimplePatternTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"aaaa", "aaaa", "aaaa"}, (int[])new int[]{0, 4, 8}, (int[])new int[]{4, 8, 12});
    }

    public void testBasic() throws Exception {
        String[][] tests;
        String qpattern = "\\'([^\\']+)\\'";
        for (String[] test : tests = new String[][]{{":", "boo:and:foo", ": :"}, {qpattern, "aaa 'bbb' 'ccc'", "'bbb' 'ccc'"}}) {
            SimplePatternTokenizer stream = new SimplePatternTokenizer(test[0]);
            ((Tokenizer)stream).setReader((Reader)new StringReader(test[1]));
            String out = TestSimplePatternTokenizer.tsToString((TokenStream)stream);
            TestSimplePatternTokenizer.assertEquals((String)("pattern: " + test[0] + " with input: " + test[1]), (Object)test[2], (Object)out);
        }
    }

    public void testNotDeterminized() throws Exception {
        Automaton a = new Automaton();
        int start = a.createState();
        int mid1 = a.createState();
        int mid2 = a.createState();
        int end = a.createState();
        a.setAccept(end, true);
        a.addTransition(start, mid1, 97, 122);
        a.addTransition(start, mid2, 97, 122);
        a.addTransition(mid1, end, 98);
        a.addTransition(mid2, end, 98);
        TestSimplePatternTokenizer.expectThrows(IllegalArgumentException.class, () -> new SimplePatternTokenizer(a));
    }

    public void testOffsetCorrection() throws Exception {
        String INPUT = "G&uuml;nther G&uuml;nther is here";
        ArrayList<String> mappingRules = new ArrayList<String>();
        mappingRules.add("\"&uuml;\" => \"\u00fc\"");
        NormalizeCharMap.Builder builder = new NormalizeCharMap.Builder();
        builder.add("&uuml;", "\u00fc");
        NormalizeCharMap normMap = builder.build();
        MappingCharFilter charStream = new MappingCharFilter(normMap, (Reader)new StringReader("G&uuml;nther G&uuml;nther is here"));
        SimplePatternTokenizer stream = new SimplePatternTokenizer("G\u00fcnther");
        stream.setReader((Reader)charStream);
        TestSimplePatternTokenizer.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"G\u00fcnther", "G\u00fcnther"}, (int[])new int[]{0, 13}, (int[])new int[]{12, 25}, (Integer)"G&uuml;nther G&uuml;nther is here".length());
    }

    private static String tsToString(TokenStream in) throws IOException {
        StringBuilder out = new StringBuilder();
        CharTermAttribute termAtt = (CharTermAttribute)in.addAttribute(CharTermAttribute.class);
        in.clearAttributes();
        termAtt.setEmpty().append("bogusTerm");
        in.reset();
        while (in.incrementToken()) {
            if (out.length() > 0) {
                out.append(' ');
            }
            out.append(termAtt.toString());
            in.clearAttributes();
            termAtt.setEmpty().append("bogusTerm");
        }
        in.close();
        return out.toString();
    }

    public void testRandomStrings() throws Exception {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                SimplePatternTokenizer tokenizer = new SimplePatternTokenizer("a");
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer);
            }
        };
        TestSimplePatternTokenizer.checkRandomData((Random)TestSimplePatternTokenizer.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
        Analyzer b = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                SimplePatternTokenizer tokenizer = new SimplePatternTokenizer("a");
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer);
            }
        };
        TestSimplePatternTokenizer.checkRandomData((Random)TestSimplePatternTokenizer.random(), (Analyzer)b, (int)(1000 * RANDOM_MULTIPLIER));
        b.close();
    }

    public void testEndLookahead() throws Exception {
        SimplePatternTokenizer t = new SimplePatternTokenizer("(ab)+");
        t.setReader((Reader)new StringReader("aba"));
        TestSimplePatternTokenizer.assertTokenStreamContents((TokenStream)t, (String[])new String[]{"ab"}, (int[])new int[]{0}, (int[])new int[]{2}, (Integer)3);
    }
}

