/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.payloads;

import java.nio.charset.StandardCharsets;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.payloads.DelimitedPayloadTokenFilter;
import org.apache.lucene.analysis.payloads.FloatEncoder;
import org.apache.lucene.analysis.payloads.IdentityEncoder;
import org.apache.lucene.analysis.payloads.IntegerEncoder;
import org.apache.lucene.analysis.payloads.PayloadEncoder;
import org.apache.lucene.analysis.payloads.PayloadHelper;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.util.BytesRef;

public class DelimitedPayloadTokenFilterTest
extends BaseTokenStreamTestCase {
    public void testPayloads() throws Exception {
        String test = "The quick|JJ red|JJ fox|NN jumped|VB over the lazy|JJ brown|JJ dogs|NN";
        DelimitedPayloadTokenFilter filter = new DelimitedPayloadTokenFilter((TokenStream)DelimitedPayloadTokenFilterTest.whitespaceMockTokenizer((String)test), '|', (PayloadEncoder)new IdentityEncoder());
        CharTermAttribute termAtt = (CharTermAttribute)filter.getAttribute(CharTermAttribute.class);
        PayloadAttribute payAtt = (PayloadAttribute)filter.getAttribute(PayloadAttribute.class);
        filter.reset();
        this.assertTermEquals("The", (TokenStream)filter, termAtt, payAtt, null);
        this.assertTermEquals("quick", (TokenStream)filter, termAtt, payAtt, "JJ".getBytes(StandardCharsets.UTF_8));
        this.assertTermEquals("red", (TokenStream)filter, termAtt, payAtt, "JJ".getBytes(StandardCharsets.UTF_8));
        this.assertTermEquals("fox", (TokenStream)filter, termAtt, payAtt, "NN".getBytes(StandardCharsets.UTF_8));
        this.assertTermEquals("jumped", (TokenStream)filter, termAtt, payAtt, "VB".getBytes(StandardCharsets.UTF_8));
        this.assertTermEquals("over", (TokenStream)filter, termAtt, payAtt, null);
        this.assertTermEquals("the", (TokenStream)filter, termAtt, payAtt, null);
        this.assertTermEquals("lazy", (TokenStream)filter, termAtt, payAtt, "JJ".getBytes(StandardCharsets.UTF_8));
        this.assertTermEquals("brown", (TokenStream)filter, termAtt, payAtt, "JJ".getBytes(StandardCharsets.UTF_8));
        this.assertTermEquals("dogs", (TokenStream)filter, termAtt, payAtt, "NN".getBytes(StandardCharsets.UTF_8));
        DelimitedPayloadTokenFilterTest.assertFalse((boolean)filter.incrementToken());
        filter.end();
        filter.close();
    }

    public void testNext() throws Exception {
        String test = "The quick|JJ red|JJ fox|NN jumped|VB over the lazy|JJ brown|JJ dogs|NN";
        DelimitedPayloadTokenFilter filter = new DelimitedPayloadTokenFilter((TokenStream)DelimitedPayloadTokenFilterTest.whitespaceMockTokenizer((String)test), '|', (PayloadEncoder)new IdentityEncoder());
        filter.reset();
        this.assertTermEquals("The", (TokenStream)filter, null);
        this.assertTermEquals("quick", (TokenStream)filter, "JJ".getBytes(StandardCharsets.UTF_8));
        this.assertTermEquals("red", (TokenStream)filter, "JJ".getBytes(StandardCharsets.UTF_8));
        this.assertTermEquals("fox", (TokenStream)filter, "NN".getBytes(StandardCharsets.UTF_8));
        this.assertTermEquals("jumped", (TokenStream)filter, "VB".getBytes(StandardCharsets.UTF_8));
        this.assertTermEquals("over", (TokenStream)filter, null);
        this.assertTermEquals("the", (TokenStream)filter, null);
        this.assertTermEquals("lazy", (TokenStream)filter, "JJ".getBytes(StandardCharsets.UTF_8));
        this.assertTermEquals("brown", (TokenStream)filter, "JJ".getBytes(StandardCharsets.UTF_8));
        this.assertTermEquals("dogs", (TokenStream)filter, "NN".getBytes(StandardCharsets.UTF_8));
        DelimitedPayloadTokenFilterTest.assertFalse((boolean)filter.incrementToken());
        filter.end();
        filter.close();
    }

    public void testFloatEncoding() throws Exception {
        String test = "The quick|1.0 red|2.0 fox|3.5 jumped|0.5 over the lazy|5 brown|99.3 dogs|83.7";
        DelimitedPayloadTokenFilter filter = new DelimitedPayloadTokenFilter((TokenStream)DelimitedPayloadTokenFilterTest.whitespaceMockTokenizer((String)test), '|', (PayloadEncoder)new FloatEncoder());
        CharTermAttribute termAtt = (CharTermAttribute)filter.getAttribute(CharTermAttribute.class);
        PayloadAttribute payAtt = (PayloadAttribute)filter.getAttribute(PayloadAttribute.class);
        filter.reset();
        this.assertTermEquals("The", (TokenStream)filter, termAtt, payAtt, null);
        this.assertTermEquals("quick", (TokenStream)filter, termAtt, payAtt, PayloadHelper.encodeFloat((float)1.0f));
        this.assertTermEquals("red", (TokenStream)filter, termAtt, payAtt, PayloadHelper.encodeFloat((float)2.0f));
        this.assertTermEquals("fox", (TokenStream)filter, termAtt, payAtt, PayloadHelper.encodeFloat((float)3.5f));
        this.assertTermEquals("jumped", (TokenStream)filter, termAtt, payAtt, PayloadHelper.encodeFloat((float)0.5f));
        this.assertTermEquals("over", (TokenStream)filter, termAtt, payAtt, null);
        this.assertTermEquals("the", (TokenStream)filter, termAtt, payAtt, null);
        this.assertTermEquals("lazy", (TokenStream)filter, termAtt, payAtt, PayloadHelper.encodeFloat((float)5.0f));
        this.assertTermEquals("brown", (TokenStream)filter, termAtt, payAtt, PayloadHelper.encodeFloat((float)99.3f));
        this.assertTermEquals("dogs", (TokenStream)filter, termAtt, payAtt, PayloadHelper.encodeFloat((float)83.7f));
        DelimitedPayloadTokenFilterTest.assertFalse((boolean)filter.incrementToken());
        filter.end();
        filter.close();
    }

    public void testIntEncoding() throws Exception {
        String test = "The quick|1 red|2 fox|3 jumped over the lazy|5 brown|99 dogs|83";
        DelimitedPayloadTokenFilter filter = new DelimitedPayloadTokenFilter((TokenStream)DelimitedPayloadTokenFilterTest.whitespaceMockTokenizer((String)test), '|', (PayloadEncoder)new IntegerEncoder());
        CharTermAttribute termAtt = (CharTermAttribute)filter.getAttribute(CharTermAttribute.class);
        PayloadAttribute payAtt = (PayloadAttribute)filter.getAttribute(PayloadAttribute.class);
        filter.reset();
        this.assertTermEquals("The", (TokenStream)filter, termAtt, payAtt, null);
        this.assertTermEquals("quick", (TokenStream)filter, termAtt, payAtt, PayloadHelper.encodeInt((int)1));
        this.assertTermEquals("red", (TokenStream)filter, termAtt, payAtt, PayloadHelper.encodeInt((int)2));
        this.assertTermEquals("fox", (TokenStream)filter, termAtt, payAtt, PayloadHelper.encodeInt((int)3));
        this.assertTermEquals("jumped", (TokenStream)filter, termAtt, payAtt, null);
        this.assertTermEquals("over", (TokenStream)filter, termAtt, payAtt, null);
        this.assertTermEquals("the", (TokenStream)filter, termAtt, payAtt, null);
        this.assertTermEquals("lazy", (TokenStream)filter, termAtt, payAtt, PayloadHelper.encodeInt((int)5));
        this.assertTermEquals("brown", (TokenStream)filter, termAtt, payAtt, PayloadHelper.encodeInt((int)99));
        this.assertTermEquals("dogs", (TokenStream)filter, termAtt, payAtt, PayloadHelper.encodeInt((int)83));
        DelimitedPayloadTokenFilterTest.assertFalse((boolean)filter.incrementToken());
        filter.end();
        filter.close();
    }

    void assertTermEquals(String expected, TokenStream stream, byte[] expectPay) throws Exception {
        CharTermAttribute termAtt = (CharTermAttribute)stream.getAttribute(CharTermAttribute.class);
        PayloadAttribute payloadAtt = (PayloadAttribute)stream.getAttribute(PayloadAttribute.class);
        DelimitedPayloadTokenFilterTest.assertTrue((boolean)stream.incrementToken());
        DelimitedPayloadTokenFilterTest.assertEquals((Object)expected, (Object)termAtt.toString());
        BytesRef payload = payloadAtt.getPayload();
        if (payload != null) {
            DelimitedPayloadTokenFilterTest.assertTrue((String)(payload.length + " does not equal: " + expectPay.length), (payload.length == expectPay.length ? 1 : 0) != 0);
            for (int i = 0; i < expectPay.length; ++i) {
                DelimitedPayloadTokenFilterTest.assertTrue((String)(expectPay[i] + " does not equal: " + payload.bytes[i + payload.offset]), (expectPay[i] == payload.bytes[i + payload.offset] ? 1 : 0) != 0);
            }
        } else {
            DelimitedPayloadTokenFilterTest.assertTrue((String)"expectPay is not null and it should be", (expectPay == null ? 1 : 0) != 0);
        }
    }

    void assertTermEquals(String expected, TokenStream stream, CharTermAttribute termAtt, PayloadAttribute payAtt, byte[] expectPay) throws Exception {
        DelimitedPayloadTokenFilterTest.assertTrue((boolean)stream.incrementToken());
        DelimitedPayloadTokenFilterTest.assertEquals((Object)expected, (Object)termAtt.toString());
        BytesRef payload = payAtt.getPayload();
        if (payload != null) {
            DelimitedPayloadTokenFilterTest.assertTrue((String)(payload.length + " does not equal: " + expectPay.length), (payload.length == expectPay.length ? 1 : 0) != 0);
            for (int i = 0; i < expectPay.length; ++i) {
                DelimitedPayloadTokenFilterTest.assertTrue((String)(expectPay[i] + " does not equal: " + payload.bytes[i + payload.offset]), (expectPay[i] == payload.bytes[i + payload.offset] ? 1 : 0) != 0);
            }
        } else {
            DelimitedPayloadTokenFilterTest.assertTrue((String)"expectPay is not null and it should be", (expectPay == null ? 1 : 0) != 0);
        }
    }
}

