/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.payloads;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.payloads.NumericPayloadTokenFilter;
import org.apache.lucene.analysis.payloads.PayloadHelper;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public class NumericPayloadTokenFilterTest
extends BaseTokenStreamTestCase {
    public void test() throws IOException {
        String test = "The quick red fox jumped over the lazy brown dogs";
        MockTokenizer input = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        input.setReader((Reader)new StringReader(test));
        NumericPayloadTokenFilter nptf = new NumericPayloadTokenFilter((TokenStream)new WordTokenFilter((TokenStream)input), 3.0f, "D");
        boolean seenDogs = false;
        CharTermAttribute termAtt = (CharTermAttribute)nptf.getAttribute(CharTermAttribute.class);
        TypeAttribute typeAtt = (TypeAttribute)nptf.getAttribute(TypeAttribute.class);
        PayloadAttribute payloadAtt = (PayloadAttribute)nptf.getAttribute(PayloadAttribute.class);
        nptf.reset();
        while (nptf.incrementToken()) {
            if (termAtt.toString().equals("dogs")) {
                seenDogs = true;
                NumericPayloadTokenFilterTest.assertTrue((String)(typeAtt.type() + " is not equal to D"), (typeAtt.type().equals("D") ? 1 : 0) != 0);
                NumericPayloadTokenFilterTest.assertTrue((String)"payloadAtt.getPayload() is null and it shouldn't be", (payloadAtt.getPayload() != null ? 1 : 0) != 0);
                byte[] bytes = payloadAtt.getPayload().bytes;
                NumericPayloadTokenFilterTest.assertTrue((String)(bytes.length + " does not equal: " + payloadAtt.getPayload().length), (bytes.length == payloadAtt.getPayload().length ? 1 : 0) != 0);
                NumericPayloadTokenFilterTest.assertTrue((String)(payloadAtt.getPayload().offset + " does not equal: " + 0), (payloadAtt.getPayload().offset == 0 ? 1 : 0) != 0);
                float pay = PayloadHelper.decodeFloat((byte[])bytes);
                NumericPayloadTokenFilterTest.assertTrue((String)(pay + " does not equal: " + 3), (pay == 3.0f ? 1 : 0) != 0);
                continue;
            }
            NumericPayloadTokenFilterTest.assertTrue((String)(typeAtt.type() + " is not null and it should be"), (boolean)typeAtt.type().equals("word"));
        }
        NumericPayloadTokenFilterTest.assertTrue((String)(seenDogs + " does not equal: " + true), (seenDogs ? 1 : 0) != 0);
    }

    private static final class WordTokenFilter
    extends TokenFilter {
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);

        private WordTokenFilter(TokenStream input) {
            super(input);
        }

        public boolean incrementToken() throws IOException {
            if (this.input.incrementToken()) {
                if (this.termAtt.toString().equals("dogs")) {
                    this.typeAtt.setType("D");
                }
                return true;
            }
            return false;
        }
    }
}

