/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.payloads;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.payloads.PayloadHelper;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestDelimitedPayloadTokenFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testEncoder() throws Exception {
        StringReader reader = new StringReader("the|0.1 quick|0.1 red|0.1");
        MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)stream).setReader((Reader)reader);
        stream = this.tokenFilterFactory("DelimitedPayload", "encoder", "float").create((TokenStream)stream);
        stream.reset();
        while (stream.incrementToken()) {
            PayloadAttribute payAttr = (PayloadAttribute)stream.getAttribute(PayloadAttribute.class);
            TestDelimitedPayloadTokenFilterFactory.assertNotNull((Object)payAttr);
            byte[] payData = payAttr.getPayload().bytes;
            TestDelimitedPayloadTokenFilterFactory.assertNotNull((Object)payData);
            float payFloat = PayloadHelper.decodeFloat((byte[])payData);
            TestDelimitedPayloadTokenFilterFactory.assertEquals((double)0.1f, (double)payFloat, (double)0.0);
        }
        stream.end();
        stream.close();
    }

    public void testDelim() throws Exception {
        StringReader reader = new StringReader("the*0.1 quick*0.1 red*0.1");
        MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)stream).setReader((Reader)reader);
        stream = this.tokenFilterFactory("DelimitedPayload", "encoder", "float", "delimiter", "*").create((TokenStream)stream);
        stream.reset();
        while (stream.incrementToken()) {
            PayloadAttribute payAttr = (PayloadAttribute)stream.getAttribute(PayloadAttribute.class);
            TestDelimitedPayloadTokenFilterFactory.assertNotNull((Object)payAttr);
            byte[] payData = payAttr.getPayload().bytes;
            TestDelimitedPayloadTokenFilterFactory.assertNotNull((Object)payData);
            float payFloat = PayloadHelper.decodeFloat((byte[])payData);
            TestDelimitedPayloadTokenFilterFactory.assertEquals((double)0.1f, (double)payFloat, (double)0.0);
        }
        stream.end();
        stream.close();
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestDelimitedPayloadTokenFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("DelimitedPayload", "encoder", "float", "bogusArg", "bogusValue"));
        TestDelimitedPayloadTokenFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

