/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.payloads;

import java.io.IOException;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.payloads.PayloadHelper;
import org.apache.lucene.analysis.payloads.TokenOffsetPayloadTokenFilter;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.util.BytesRef;

public class TokenOffsetPayloadTokenFilterTest
extends BaseTokenStreamTestCase {
    public void test() throws IOException {
        String test = "The quick red fox jumped over the lazy brown dogs";
        TokenOffsetPayloadTokenFilter nptf = new TokenOffsetPayloadTokenFilter((TokenStream)TokenOffsetPayloadTokenFilterTest.whitespaceMockTokenizer((String)test));
        int count = 0;
        PayloadAttribute payloadAtt = (PayloadAttribute)nptf.getAttribute(PayloadAttribute.class);
        OffsetAttribute offsetAtt = (OffsetAttribute)nptf.getAttribute(OffsetAttribute.class);
        nptf.reset();
        while (nptf.incrementToken()) {
            BytesRef pay = payloadAtt.getPayload();
            TokenOffsetPayloadTokenFilterTest.assertTrue((String)"pay is null and it shouldn't be", (pay != null ? 1 : 0) != 0);
            byte[] data = pay.bytes;
            int start = PayloadHelper.decodeInt((byte[])data, (int)0);
            TokenOffsetPayloadTokenFilterTest.assertTrue((String)(start + " does not equal: " + offsetAtt.startOffset()), (start == offsetAtt.startOffset() ? 1 : 0) != 0);
            int end = PayloadHelper.decodeInt((byte[])data, (int)4);
            TokenOffsetPayloadTokenFilterTest.assertTrue((String)(end + " does not equal: " + offsetAtt.endOffset()), (end == offsetAtt.endOffset() ? 1 : 0) != 0);
            ++count;
        }
        TokenOffsetPayloadTokenFilterTest.assertTrue((String)(count + " does not equal: " + 10), (count == 10 ? 1 : 0) != 0);
    }
}

