/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.payloads;

import java.io.IOException;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.payloads.TypeAsPayloadTokenFilter;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public class TypeAsPayloadTokenFilterTest
extends BaseTokenStreamTestCase {
    public void test() throws IOException {
        String test = "The quick red fox jumped over the lazy brown dogs";
        TypeAsPayloadTokenFilter nptf = new TypeAsPayloadTokenFilter((TokenStream)new WordTokenFilter((TokenStream)TypeAsPayloadTokenFilterTest.whitespaceMockTokenizer((String)test)));
        int count = 0;
        CharTermAttribute termAtt = (CharTermAttribute)nptf.getAttribute(CharTermAttribute.class);
        TypeAttribute typeAtt = (TypeAttribute)nptf.getAttribute(TypeAttribute.class);
        PayloadAttribute payloadAtt = (PayloadAttribute)nptf.getAttribute(PayloadAttribute.class);
        nptf.reset();
        while (nptf.incrementToken()) {
            TypeAsPayloadTokenFilterTest.assertTrue((String)(typeAtt.type() + " is not null and it should be"), (boolean)typeAtt.type().equals(String.valueOf(Character.toUpperCase(termAtt.buffer()[0]))));
            TypeAsPayloadTokenFilterTest.assertTrue((String)"nextToken.getPayload() is null and it shouldn't be", (payloadAtt.getPayload() != null ? 1 : 0) != 0);
            String type = payloadAtt.getPayload().utf8ToString();
            TypeAsPayloadTokenFilterTest.assertTrue((String)(type + " is not equal to " + typeAtt.type()), (boolean)type.equals(typeAtt.type()));
            ++count;
        }
        TypeAsPayloadTokenFilterTest.assertTrue((String)(count + " does not equal: " + 10), (count == 10 ? 1 : 0) != 0);
    }

    private static final class WordTokenFilter
    extends TokenFilter {
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);

        private WordTokenFilter(TokenStream input) {
            super(input);
        }

        public boolean incrementToken() throws IOException {
            if (this.input.incrementToken()) {
                this.typeAtt.setType(String.valueOf(Character.toUpperCase(this.termAtt.buffer()[0])));
                return true;
            }
            return false;
        }
    }
}

