/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pt;

import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.pt.PortugueseAnalyzer;

public class TestPortugueseAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new PortugueseAnalyzer().close();
    }

    public void testBasics() throws IOException {
        PortugueseAnalyzer a = new PortugueseAnalyzer();
        TestPortugueseAnalyzer.checkOneTerm((Analyzer)a, (String)"quilom\u00e9tricas", (String)"quilometric");
        TestPortugueseAnalyzer.checkOneTerm((Analyzer)a, (String)"quilom\u00e9tricos", (String)"quilometric");
        TestPortugueseAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"n\u00e3o", (String[])new String[0]);
        a.close();
    }

    public void testExclude() throws IOException {
        CharArraySet exclusionSet = new CharArraySet((Collection)TestPortugueseAnalyzer.asSet((Object[])new String[]{"quilom\u00e9tricas"}), false);
        PortugueseAnalyzer a = new PortugueseAnalyzer(PortugueseAnalyzer.getDefaultStopSet(), exclusionSet);
        TestPortugueseAnalyzer.checkOneTerm((Analyzer)a, (String)"quilom\u00e9tricas", (String)"quilom\u00e9tricas");
        TestPortugueseAnalyzer.checkOneTerm((Analyzer)a, (String)"quilom\u00e9tricos", (String)"quilometric");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        PortugueseAnalyzer analyzer = new PortugueseAnalyzer();
        TestPortugueseAnalyzer.checkRandomData((Random)TestPortugueseAnalyzer.random(), (Analyzer)analyzer, (int)(1000 * RANDOM_MULTIPLIER));
        analyzer.close();
    }
}

