/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pt;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.VocabularyAssert;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.pt.PortugueseLightStemFilter;

public class TestPortugueseLightStemFilter
extends BaseTokenStreamTestCase {
    private Analyzer analyzer;

    public void setUp() throws Exception {
        super.setUp();
        this.analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer source = new MockTokenizer(MockTokenizer.SIMPLE, true);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new PortugueseLightStemFilter((TokenStream)source));
            }
        };
    }

    public void tearDown() throws Exception {
        this.analyzer.close();
        super.tearDown();
    }

    public void testExamples() throws IOException {
        TestPortugueseLightStemFilter.assertAnalyzesTo((Analyzer)this.analyzer, (String)"O debate pol\u00edtico, pelo menos o que vem a p\u00fablico, parece, de modo nada surpreendente, restrito a temas menores. Mas h\u00e1, evidentemente, grandes quest\u00f5es em jogo nas elei\u00e7\u00f5es que se aproximam.", (String[])new String[]{"o", "debat", "politic", "pelo", "meno", "o", "que", "vem", "a", "public", "parec", "de", "modo", "nada", "surpreendent", "restrit", "a", "tema", "menor", "mas", "h\u00e1", "evident", "grand", "questa", "em", "jogo", "nas", "eleica", "que", "se", "aproximam"});
    }

    public void testMoreExamples() throws IOException {
        TestPortugueseLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"doutores", (String)"doutor");
        TestPortugueseLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"doutor", (String)"doutor");
        TestPortugueseLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"homens", (String)"homem");
        TestPortugueseLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"homem", (String)"homem");
        TestPortugueseLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"pap\u00e9is", (String)"papel");
        TestPortugueseLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"papel", (String)"papel");
        TestPortugueseLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"normais", (String)"normal");
        TestPortugueseLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"normal", (String)"normal");
        TestPortugueseLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"lenc\u00f3is", (String)"lencol");
        TestPortugueseLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"lencol", (String)"lencol");
        TestPortugueseLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"barris", (String)"barril");
        TestPortugueseLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"barril", (String)"barril");
        TestPortugueseLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"bot\u00f5es", (String)"bota");
        TestPortugueseLightStemFilter.checkOneTerm((Analyzer)this.analyzer, (String)"bot\u00e3o", (String)"bota");
    }

    public void testVocabulary() throws IOException {
        VocabularyAssert.assertVocabulary((Analyzer)this.analyzer, (Path)this.getDataPath("ptlighttestdata.zip"), (String)"ptlight.txt");
    }

    public void testKeyword() throws IOException {
        final CharArraySet exclusionSet = new CharArraySet((Collection)TestPortugueseLightStemFilter.asSet((Object[])new String[]{"quilom\u00e9tricas"}), false);
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer source = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                SetKeywordMarkerFilter sink = new SetKeywordMarkerFilter((TokenStream)source, exclusionSet);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new PortugueseLightStemFilter((TokenStream)sink));
            }
        };
        TestPortugueseLightStemFilter.checkOneTerm((Analyzer)a, (String)"quilom\u00e9tricas", (String)"quilom\u00e9tricas");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        TestPortugueseLightStemFilter.checkRandomData((Random)TestPortugueseLightStemFilter.random(), (Analyzer)this.analyzer, (int)(1000 * RANDOM_MULTIPLIER));
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new PortugueseLightStemFilter((TokenStream)tokenizer));
            }
        };
        TestPortugueseLightStemFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

