/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pt;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.VocabularyAssert;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.pt.PortugueseMinimalStemFilter;

public class TestPortugueseMinimalStemFilter
extends BaseTokenStreamTestCase {
    private Analyzer analyzer;

    public void setUp() throws Exception {
        super.setUp();
        this.analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer source = new MockTokenizer(MockTokenizer.SIMPLE, true);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new PortugueseMinimalStemFilter((TokenStream)source));
            }
        };
    }

    public void tearDown() throws Exception {
        this.analyzer.close();
        super.tearDown();
    }

    public void testExamples() throws IOException {
        TestPortugueseMinimalStemFilter.assertAnalyzesTo((Analyzer)this.analyzer, (String)"O debate pol\u00edtico, pelo menos o que vem a p\u00fablico, parece, de modo nada surpreendente, restrito a temas menores. Mas h\u00e1, evidentemente, grandes quest\u00f5es em jogo nas elei\u00e7\u00f5es que se aproximam.", (String[])new String[]{"o", "debate", "pol\u00edtico", "pelo", "menos", "o", "que", "vem", "a", "p\u00fablico", "parece", "de", "modo", "nada", "surpreendente", "restrito", "a", "tema", "menor", "mas", "h\u00e1", "evidentemente", "grande", "quest\u00e3o", "em", "jogo", "na", "elei\u00e7\u00e3o", "que", "se", "aproximam"});
    }

    public void testVocabulary() throws IOException {
        VocabularyAssert.assertVocabulary((Analyzer)this.analyzer, (Path)this.getDataPath("ptminimaltestdata.zip"), (String)"ptminimal.txt");
    }

    public void testKeyword() throws IOException {
        final CharArraySet exclusionSet = new CharArraySet((Collection)TestPortugueseMinimalStemFilter.asSet((Object[])new String[]{"quilom\u00e9tricas"}), false);
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer source = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                SetKeywordMarkerFilter sink = new SetKeywordMarkerFilter((TokenStream)source, exclusionSet);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new PortugueseMinimalStemFilter((TokenStream)sink));
            }
        };
        TestPortugueseMinimalStemFilter.checkOneTerm((Analyzer)a, (String)"quilom\u00e9tricas", (String)"quilom\u00e9tricas");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        TestPortugueseMinimalStemFilter.checkRandomData((Random)TestPortugueseMinimalStemFilter.random(), (Analyzer)this.analyzer, (int)(1000 * RANDOM_MULTIPLIER));
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new PortugueseMinimalStemFilter((TokenStream)tokenizer));
            }
        };
        TestPortugueseMinimalStemFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

