/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pt;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.VocabularyAssert;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.pt.PortugueseStemFilter;

public class TestPortugueseStemFilter
extends BaseTokenStreamTestCase {
    private Analyzer analyzer;

    public void setUp() throws Exception {
        super.setUp();
        this.analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer source = new MockTokenizer(MockTokenizer.SIMPLE, true);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new PortugueseStemFilter((TokenStream)source));
            }
        };
    }

    public void tearDown() throws Exception {
        this.analyzer.close();
        super.tearDown();
    }

    public void testExamples() throws IOException {
        TestPortugueseStemFilter.assertAnalyzesTo((Analyzer)this.analyzer, (String)"O debate pol\u00edtico, pelo menos o que vem a p\u00fablico, parece, de modo nada surpreendente, restrito a temas menores. Mas h\u00e1, evidentemente, grandes quest\u00f5es em jogo nas elei\u00e7\u00f5es que se aproximam.", (String[])new String[]{"o", "debat", "politic", "pel", "menos", "o", "que", "vem", "a", "public", "parec", "de", "mod", "nad", "surpreend", "restrit", "a", "tem", "men", "mas", "ha", "evid", "grand", "quest", "em", "jog", "na", "eleic", "que", "se", "aproxim"});
    }

    public void testVocabulary() throws IOException {
        VocabularyAssert.assertVocabulary((Analyzer)this.analyzer, (Path)this.getDataPath("ptrslptestdata.zip"), (String)"ptrslp.txt");
    }

    public void testKeyword() throws IOException {
        final CharArraySet exclusionSet = new CharArraySet((Collection)TestPortugueseStemFilter.asSet((Object[])new String[]{"quilom\u00e9tricas"}), false);
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer source = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                SetKeywordMarkerFilter sink = new SetKeywordMarkerFilter((TokenStream)source, exclusionSet);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new PortugueseStemFilter((TokenStream)sink));
            }
        };
        TestPortugueseStemFilter.checkOneTerm((Analyzer)a, (String)"quilom\u00e9tricas", (String)"quilom\u00e9tricas");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        TestPortugueseStemFilter.checkRandomData((Random)TestPortugueseStemFilter.random(), (Analyzer)this.analyzer, (int)(1000 * RANDOM_MULTIPLIER));
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new PortugueseStemFilter((TokenStream)tokenizer));
            }
        };
        TestPortugueseStemFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

