/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.query;

import java.util.Arrays;
import java.util.Collections;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.query.QueryAutoStopWordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class QueryAutoStopWordAnalyzerTest
extends BaseTokenStreamTestCase {
    String[] variedFieldValues = new String[]{"the", "quick", "brown", "fox", "jumped", "over", "the", "lazy", "boring", "dog"};
    String[] repetitiveFieldValues = new String[]{"boring", "boring", "vaguelyboring"};
    RAMDirectory dir;
    Analyzer appAnalyzer;
    IndexReader reader;
    QueryAutoStopWordAnalyzer protectedAnalyzer;

    public void setUp() throws Exception {
        super.setUp();
        this.dir = new RAMDirectory();
        this.appAnalyzer = new MockAnalyzer(QueryAutoStopWordAnalyzerTest.random(), MockTokenizer.WHITESPACE, false);
        IndexWriter writer = new IndexWriter((Directory)this.dir, new IndexWriterConfig(this.appAnalyzer));
        int numDocs = 200;
        for (int i = 0; i < numDocs; ++i) {
            Document doc = new Document();
            String variedFieldValue = this.variedFieldValues[i % this.variedFieldValues.length];
            String repetitiveFieldValue = this.repetitiveFieldValues[i % this.repetitiveFieldValues.length];
            doc.add((IndexableField)new TextField("variedField", variedFieldValue, Field.Store.YES));
            doc.add((IndexableField)new TextField("repetitiveField", repetitiveFieldValue, Field.Store.YES));
            writer.addDocument((Iterable)doc);
        }
        writer.close();
        this.reader = DirectoryReader.open((Directory)this.dir);
    }

    public void tearDown() throws Exception {
        this.appAnalyzer.close();
        this.reader.close();
        super.tearDown();
    }

    public void testNoStopwords() throws Exception {
        this.protectedAnalyzer = new QueryAutoStopWordAnalyzer(this.appAnalyzer, this.reader, Collections.emptyList(), 1);
        TokenStream protectedTokenStream = this.protectedAnalyzer.tokenStream("variedField", "quick");
        QueryAutoStopWordAnalyzerTest.assertTokenStreamContents((TokenStream)protectedTokenStream, (String[])new String[]{"quick"});
        protectedTokenStream = this.protectedAnalyzer.tokenStream("repetitiveField", "boring");
        QueryAutoStopWordAnalyzerTest.assertTokenStreamContents((TokenStream)protectedTokenStream, (String[])new String[]{"boring"});
        this.protectedAnalyzer.close();
    }

    public void testDefaultStopwordsAllFields() throws Exception {
        this.protectedAnalyzer = new QueryAutoStopWordAnalyzer(this.appAnalyzer, this.reader);
        TokenStream protectedTokenStream = this.protectedAnalyzer.tokenStream("repetitiveField", "boring");
        QueryAutoStopWordAnalyzerTest.assertTokenStreamContents((TokenStream)protectedTokenStream, (String[])new String[0]);
        this.protectedAnalyzer.close();
    }

    public void testStopwordsAllFieldsMaxPercentDocs() throws Exception {
        this.protectedAnalyzer = new QueryAutoStopWordAnalyzer(this.appAnalyzer, this.reader, 0.5f);
        TokenStream protectedTokenStream = this.protectedAnalyzer.tokenStream("repetitiveField", "boring");
        QueryAutoStopWordAnalyzerTest.assertTokenStreamContents((TokenStream)protectedTokenStream, (String[])new String[0]);
        protectedTokenStream = this.protectedAnalyzer.tokenStream("repetitiveField", "vaguelyboring");
        QueryAutoStopWordAnalyzerTest.assertTokenStreamContents((TokenStream)protectedTokenStream, (String[])new String[]{"vaguelyboring"});
        this.protectedAnalyzer.close();
        this.protectedAnalyzer = new QueryAutoStopWordAnalyzer(this.appAnalyzer, this.reader, 0.25f);
        protectedTokenStream = this.protectedAnalyzer.tokenStream("repetitiveField", "vaguelyboring");
        QueryAutoStopWordAnalyzerTest.assertTokenStreamContents((TokenStream)protectedTokenStream, (String[])new String[0]);
        this.protectedAnalyzer.close();
    }

    public void testStopwordsPerFieldMaxPercentDocs() throws Exception {
        this.protectedAnalyzer = new QueryAutoStopWordAnalyzer(this.appAnalyzer, this.reader, Arrays.asList("variedField"), 0.5f);
        TokenStream protectedTokenStream = this.protectedAnalyzer.tokenStream("repetitiveField", "boring");
        QueryAutoStopWordAnalyzerTest.assertTokenStreamContents((TokenStream)protectedTokenStream, (String[])new String[]{"boring"});
        this.protectedAnalyzer.close();
        this.protectedAnalyzer = new QueryAutoStopWordAnalyzer(this.appAnalyzer, this.reader, Arrays.asList("variedField", "repetitiveField"), 0.5f);
        protectedTokenStream = this.protectedAnalyzer.tokenStream("repetitiveField", "boring");
        QueryAutoStopWordAnalyzerTest.assertTokenStreamContents((TokenStream)protectedTokenStream, (String[])new String[0]);
        this.protectedAnalyzer.close();
    }

    public void testStopwordsPerFieldMaxDocFreq() throws Exception {
        this.protectedAnalyzer = new QueryAutoStopWordAnalyzer(this.appAnalyzer, this.reader, Arrays.asList("repetitiveField"), 10);
        int numStopWords = this.protectedAnalyzer.getStopWords("repetitiveField").length;
        QueryAutoStopWordAnalyzerTest.assertTrue((String)"Should have identified stop words", (numStopWords > 0 ? 1 : 0) != 0);
        this.protectedAnalyzer.close();
        this.protectedAnalyzer = new QueryAutoStopWordAnalyzer(this.appAnalyzer, this.reader, Arrays.asList("repetitiveField", "variedField"), 10);
        int numNewStopWords = this.protectedAnalyzer.getStopWords("repetitiveField").length + this.protectedAnalyzer.getStopWords("variedField").length;
        QueryAutoStopWordAnalyzerTest.assertTrue((String)"Should have identified more stop words", (numNewStopWords > numStopWords ? 1 : 0) != 0);
        this.protectedAnalyzer.close();
    }

    public void testNoFieldNamePollution() throws Exception {
        this.protectedAnalyzer = new QueryAutoStopWordAnalyzer(this.appAnalyzer, this.reader, Arrays.asList("repetitiveField"), 10);
        TokenStream protectedTokenStream = this.protectedAnalyzer.tokenStream("repetitiveField", "boring");
        QueryAutoStopWordAnalyzerTest.assertTokenStreamContents((TokenStream)protectedTokenStream, (String[])new String[0]);
        protectedTokenStream = this.protectedAnalyzer.tokenStream("variedField", "boring");
        QueryAutoStopWordAnalyzerTest.assertTokenStreamContents((TokenStream)protectedTokenStream, (String[])new String[]{"boring"});
        this.protectedAnalyzer.close();
    }

    public void testTokenStream() throws Exception {
        QueryAutoStopWordAnalyzer a = new QueryAutoStopWordAnalyzer((Analyzer)new MockAnalyzer(QueryAutoStopWordAnalyzerTest.random(), MockTokenizer.WHITESPACE, false), this.reader, 10);
        TokenStream ts = a.tokenStream("repetitiveField", "this boring");
        QueryAutoStopWordAnalyzerTest.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"this"});
        a.close();
    }
}

