/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.reverse;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.reverse.ReverseStringFilter;

public class TestReverseStringFilter
extends BaseTokenStreamTestCase {
    public void testFilter() throws Exception {
        MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)stream).setReader((Reader)new StringReader("Do have a nice day"));
        ReverseStringFilter filter = new ReverseStringFilter((TokenStream)stream);
        TestReverseStringFilter.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"oD", "evah", "a", "ecin", "yad"});
    }

    public void testFilterWithMark() throws Exception {
        MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)stream).setReader((Reader)new StringReader("Do have a nice day"));
        ReverseStringFilter filter = new ReverseStringFilter((TokenStream)stream, '\u0001');
        TestReverseStringFilter.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"\u0001oD", "\u0001evah", "\u0001a", "\u0001ecin", "\u0001yad"});
    }

    public void testReverseString() throws Exception {
        TestReverseStringFilter.assertEquals((Object)"A", (Object)ReverseStringFilter.reverse((String)"A"));
        TestReverseStringFilter.assertEquals((Object)"BA", (Object)ReverseStringFilter.reverse((String)"AB"));
        TestReverseStringFilter.assertEquals((Object)"CBA", (Object)ReverseStringFilter.reverse((String)"ABC"));
    }

    public void testReverseChar() throws Exception {
        char[] buffer = new char[]{'A', 'B', 'C', 'D', 'E', 'F'};
        ReverseStringFilter.reverse((char[])buffer, (int)2, (int)3);
        TestReverseStringFilter.assertEquals((Object)"ABEDCF", (Object)new String(buffer));
    }

    public void testReverseSupplementary() throws Exception {
        TestReverseStringFilter.assertEquals((Object)"\ud866\udf05\u8271\u935f\u41f9\u612f\u701b", (Object)ReverseStringFilter.reverse((String)"\u701b\u612f\u41f9\u935f\u8271\ud866\udf05"));
        TestReverseStringFilter.assertEquals((Object)"a\ud866\udf05\u8271\u935f\u41f9\u612f\u701b", (Object)ReverseStringFilter.reverse((String)"\u701b\u612f\u41f9\u935f\u8271\ud866\udf05a"));
        TestReverseStringFilter.assertEquals((Object)"fedcba\ud866\udf05", (Object)ReverseStringFilter.reverse((String)"\ud866\udf05abcdef"));
        TestReverseStringFilter.assertEquals((Object)"fedcba\ud866\udf05z", (Object)ReverseStringFilter.reverse((String)"z\ud866\udf05abcdef"));
        TestReverseStringFilter.assertEquals((Object)"gfe\ud866\udf05dcba", (Object)ReverseStringFilter.reverse((String)"abcd\ud866\udf05efg"));
    }

    public void testReverseSupplementaryChar() throws Exception {
        char[] buffer = "abc\u701b\u612f\u41f9\u935f\u8271\ud866\udf05".toCharArray();
        ReverseStringFilter.reverse((char[])buffer, (int)3, (int)7);
        TestReverseStringFilter.assertEquals((Object)"abc\ud866\udf05\u8271\u935f\u41f9\u612f\u701b", (Object)new String(buffer));
        buffer = "abc\u701b\u612f\u41f9\u935f\u8271\ud866\udf05d".toCharArray();
        ReverseStringFilter.reverse((char[])buffer, (int)3, (int)8);
        TestReverseStringFilter.assertEquals((Object)"abcd\ud866\udf05\u8271\u935f\u41f9\u612f\u701b", (Object)new String(buffer));
        buffer = "abc\ud866\udf05\u701b\u612f\u41f9\u935f\u8271".toCharArray();
        ReverseStringFilter.reverse((char[])buffer, (int)3, (int)7);
        TestReverseStringFilter.assertEquals((Object)"abc\u8271\u935f\u41f9\u612f\u701b\ud866\udf05", (Object)new String(buffer));
        buffer = "abcd\ud866\udf05\u701b\u612f\u41f9\u935f\u8271".toCharArray();
        ReverseStringFilter.reverse((char[])buffer, (int)3, (int)8);
        TestReverseStringFilter.assertEquals((Object)"abc\u8271\u935f\u41f9\u612f\u701b\ud866\udf05d", (Object)new String(buffer));
        buffer = "abc\u701b\u612f\ud866\udf05def".toCharArray();
        ReverseStringFilter.reverse((char[])buffer, (int)3, (int)7);
        TestReverseStringFilter.assertEquals((Object)"abcfed\ud866\udf05\u612f\u701b", (Object)new String(buffer));
    }

    public void testRandomStrings() throws Exception {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new ReverseStringFilter((TokenStream)tokenizer));
            }
        };
        TestReverseStringFilter.checkRandomData((Random)TestReverseStringFilter.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new ReverseStringFilter((TokenStream)tokenizer));
            }
        };
        TestReverseStringFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

