/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ro;

import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.ro.RomanianAnalyzer;

public class TestRomanianAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new RomanianAnalyzer().close();
    }

    public void testBasics() throws IOException {
        RomanianAnalyzer a = new RomanianAnalyzer();
        TestRomanianAnalyzer.checkOneTerm((Analyzer)a, (String)"absen\u0163a", (String)"absen\u0163");
        TestRomanianAnalyzer.checkOneTerm((Analyzer)a, (String)"absen\u0163i", (String)"absen\u0163");
        TestRomanianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u00eel", (String[])new String[0]);
        a.close();
    }

    public void testExclude() throws IOException {
        CharArraySet exclusionSet = new CharArraySet((Collection)TestRomanianAnalyzer.asSet((Object[])new String[]{"absen\u0163a"}), false);
        RomanianAnalyzer a = new RomanianAnalyzer(RomanianAnalyzer.getDefaultStopSet(), exclusionSet);
        TestRomanianAnalyzer.checkOneTerm((Analyzer)a, (String)"absen\u0163a", (String)"absen\u0163a");
        TestRomanianAnalyzer.checkOneTerm((Analyzer)a, (String)"absen\u0163i", (String)"absen\u0163");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        RomanianAnalyzer analyzer = new RomanianAnalyzer();
        TestRomanianAnalyzer.checkRandomData((Random)TestRomanianAnalyzer.random(), (Analyzer)analyzer, (int)(1000 * RANDOM_MULTIPLIER));
        analyzer.close();
    }
}

