/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ru;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.ru.RussianAnalyzer;

public class TestRussianAnalyzer
extends BaseTokenStreamTestCase {
    public void testDigitsInRussianCharset() throws IOException {
        RussianAnalyzer ra = new RussianAnalyzer();
        TestRussianAnalyzer.assertAnalyzesTo((Analyzer)ra, (String)"text 1000", (String[])new String[]{"text", "1000"});
        ra.close();
    }

    public void testReusableTokenStream() throws Exception {
        RussianAnalyzer a = new RussianAnalyzer();
        TestRussianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0412\u043c\u0435\u0441\u0442\u0435 \u0441 \u0442\u0435\u043c \u043e \u0441\u0438\u043b\u0435 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043c\u0430\u0433\u043d\u0438\u0442\u043d\u043e\u0439 \u044d\u043d\u0435\u0440\u0433\u0438\u0438 \u0438\u043c\u0435\u043b\u0438 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0435\u0449\u0435", (String[])new String[]{"\u0432\u043c\u0435\u0441\u0442", "\u0441\u0438\u043b", "\u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043c\u0430\u0433\u043d\u0438\u0442\u043d", "\u044d\u043d\u0435\u0440\u0433", "\u0438\u043c\u0435\u043b", "\u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d"});
        TestRussianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u041d\u043e \u0437\u043d\u0430\u043d\u0438\u0435 \u044d\u0442\u043e \u0445\u0440\u0430\u043d\u0438\u043b\u043e\u0441\u044c \u0432 \u0442\u0430\u0439\u043d\u0435", (String[])new String[]{"\u0437\u043d\u0430\u043d", "\u044d\u0442", "\u0445\u0440\u0430\u043d", "\u0442\u0430\u0439\u043d"});
        a.close();
    }

    public void testWithStemExclusionSet() throws Exception {
        CharArraySet set = new CharArraySet(1, true);
        set.add("\u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435");
        RussianAnalyzer a = new RussianAnalyzer(RussianAnalyzer.getDefaultStopSet(), set);
        TestRussianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0412\u043c\u0435\u0441\u0442\u0435 \u0441 \u0442\u0435\u043c \u043e \u0441\u0438\u043b\u0435 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043c\u0430\u0433\u043d\u0438\u0442\u043d\u043e\u0439 \u044d\u043d\u0435\u0440\u0433\u0438\u0438 \u0438\u043c\u0435\u043b\u0438 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0435\u0449\u0435", (String[])new String[]{"\u0432\u043c\u0435\u0441\u0442", "\u0441\u0438\u043b", "\u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043c\u0430\u0433\u043d\u0438\u0442\u043d", "\u044d\u043d\u0435\u0440\u0433", "\u0438\u043c\u0435\u043b", "\u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435"});
        a.close();
    }

    public void testRandomStrings() throws Exception {
        RussianAnalyzer analyzer = new RussianAnalyzer();
        TestRussianAnalyzer.checkRandomData((Random)TestRussianAnalyzer.random(), (Analyzer)analyzer, (int)(1000 * RANDOM_MULTIPLIER));
        analyzer.close();
    }
}

