/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.shingle;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.shingle.ShingleAnalyzerWrapper;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;

public class ShingleAnalyzerWrapperTest
extends BaseTokenStreamTestCase {
    private Analyzer analyzer;
    private IndexSearcher searcher;
    private IndexReader reader;
    private Directory directory;

    public void setUp() throws Exception {
        super.setUp();
        this.analyzer = new ShingleAnalyzerWrapper((Analyzer)new MockAnalyzer(ShingleAnalyzerWrapperTest.random(), MockTokenizer.WHITESPACE, false), 2);
        this.directory = ShingleAnalyzerWrapperTest.newDirectory();
        IndexWriter writer = new IndexWriter(this.directory, new IndexWriterConfig(this.analyzer));
        Document doc = new Document();
        doc.add((IndexableField)new TextField("content", "please divide this sentence into shingles", Field.Store.YES));
        writer.addDocument((Iterable)doc);
        doc = new Document();
        doc.add((IndexableField)new TextField("content", "just another test sentence", Field.Store.YES));
        writer.addDocument((Iterable)doc);
        doc = new Document();
        doc.add((IndexableField)new TextField("content", "a sentence which contains no test", Field.Store.YES));
        writer.addDocument((Iterable)doc);
        writer.close();
        this.reader = DirectoryReader.open((Directory)this.directory);
        this.searcher = ShingleAnalyzerWrapperTest.newSearcher((IndexReader)this.reader);
    }

    public void tearDown() throws Exception {
        this.reader.close();
        this.directory.close();
        this.analyzer.close();
        super.tearDown();
    }

    protected void compareRanks(ScoreDoc[] hits, int[] ranks) throws Exception {
        ShingleAnalyzerWrapperTest.assertEquals((long)ranks.length, (long)hits.length);
        for (int i = 0; i < ranks.length; ++i) {
            ShingleAnalyzerWrapperTest.assertEquals((long)ranks[i], (long)hits[i].doc);
        }
    }

    public void testShingleAnalyzerWrapperPhraseQuery() throws Exception {
        PhraseQuery.Builder builder = new PhraseQuery.Builder();
        try (TokenStream ts = this.analyzer.tokenStream("content", "this sentence");){
            int j = -1;
            PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)ts.addAttribute(PositionIncrementAttribute.class);
            CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            ts.reset();
            while (ts.incrementToken()) {
                String termText = termAtt.toString();
                builder.add(new Term("content", termText), j += posIncrAtt.getPositionIncrement());
            }
            ts.end();
        }
        PhraseQuery q = builder.build();
        ScoreDoc[] hits = this.searcher.search((Query)q, (int)1000).scoreDocs;
        int[] ranks = new int[]{0};
        this.compareRanks(hits, ranks);
    }

    public void testShingleAnalyzerWrapperBooleanQuery() throws Exception {
        BooleanQuery.Builder q = new BooleanQuery.Builder();
        try (TokenStream ts = this.analyzer.tokenStream("content", "test sentence");){
            CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            ts.reset();
            while (ts.incrementToken()) {
                String termText = termAtt.toString();
                q.add((Query)new TermQuery(new Term("content", termText)), BooleanClause.Occur.SHOULD);
            }
            ts.end();
        }
        ScoreDoc[] hits = this.searcher.search((Query)q.build(), (int)1000).scoreDocs;
        int[] ranks = new int[]{1, 2, 0};
        this.compareRanks(hits, ranks);
    }

    public void testReusableTokenStream() throws Exception {
        ShingleAnalyzerWrapper a = new ShingleAnalyzerWrapper((Analyzer)new MockAnalyzer(ShingleAnalyzerWrapperTest.random(), MockTokenizer.WHITESPACE, false), 2);
        ShingleAnalyzerWrapperTest.assertAnalyzesTo((Analyzer)a, (String)"please divide into shingles", (String[])new String[]{"please", "please divide", "divide", "divide into", "into", "into shingles", "shingles"}, (int[])new int[]{0, 0, 7, 7, 14, 14, 19}, (int[])new int[]{6, 13, 13, 18, 18, 27, 27}, (int[])new int[]{1, 0, 1, 0, 1, 0, 1});
        ShingleAnalyzerWrapperTest.assertAnalyzesTo((Analyzer)a, (String)"divide me up again", (String[])new String[]{"divide", "divide me", "me", "me up", "up", "up again", "again"}, (int[])new int[]{0, 0, 7, 7, 10, 10, 13}, (int[])new int[]{6, 9, 9, 12, 12, 18, 18}, (int[])new int[]{1, 0, 1, 0, 1, 0, 1});
        a.close();
    }

    public void testNonDefaultMinShingleSize() throws Exception {
        ShingleAnalyzerWrapper analyzer = new ShingleAnalyzerWrapper((Analyzer)new MockAnalyzer(ShingleAnalyzerWrapperTest.random(), MockTokenizer.WHITESPACE, false), 3, 4);
        ShingleAnalyzerWrapperTest.assertAnalyzesTo((Analyzer)analyzer, (String)"please divide this sentence into shingles", (String[])new String[]{"please", "please divide this", "please divide this sentence", "divide", "divide this sentence", "divide this sentence into", "this", "this sentence into", "this sentence into shingles", "sentence", "sentence into shingles", "into", "shingles"}, (int[])new int[]{0, 0, 0, 7, 7, 7, 14, 14, 14, 19, 19, 28, 33}, (int[])new int[]{6, 18, 27, 13, 27, 32, 18, 32, 41, 27, 41, 32, 41}, (int[])new int[]{1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 1});
        analyzer.close();
        analyzer = new ShingleAnalyzerWrapper((Analyzer)new MockAnalyzer(ShingleAnalyzerWrapperTest.random(), MockTokenizer.WHITESPACE, false), 3, 4, " ", false, false, "_");
        ShingleAnalyzerWrapperTest.assertAnalyzesTo((Analyzer)analyzer, (String)"please divide this sentence into shingles", (String[])new String[]{"please divide this", "please divide this sentence", "divide this sentence", "divide this sentence into", "this sentence into", "this sentence into shingles", "sentence into shingles"}, (int[])new int[]{0, 0, 7, 7, 14, 14, 19}, (int[])new int[]{18, 27, 27, 32, 32, 41, 41}, (int[])new int[]{1, 0, 1, 0, 1, 0, 1});
        analyzer.close();
    }

    public void testNonDefaultMinAndSameMaxShingleSize() throws Exception {
        ShingleAnalyzerWrapper analyzer = new ShingleAnalyzerWrapper((Analyzer)new MockAnalyzer(ShingleAnalyzerWrapperTest.random(), MockTokenizer.WHITESPACE, false), 3, 3);
        ShingleAnalyzerWrapperTest.assertAnalyzesTo((Analyzer)analyzer, (String)"please divide this sentence into shingles", (String[])new String[]{"please", "please divide this", "divide", "divide this sentence", "this", "this sentence into", "sentence", "sentence into shingles", "into", "shingles"}, (int[])new int[]{0, 0, 7, 7, 14, 14, 19, 19, 28, 33}, (int[])new int[]{6, 18, 13, 27, 18, 32, 27, 41, 32, 41}, (int[])new int[]{1, 0, 1, 0, 1, 0, 1, 0, 1, 1});
        analyzer.close();
        analyzer = new ShingleAnalyzerWrapper((Analyzer)new MockAnalyzer(ShingleAnalyzerWrapperTest.random(), MockTokenizer.WHITESPACE, false), 3, 3, " ", false, false, "_");
        ShingleAnalyzerWrapperTest.assertAnalyzesTo((Analyzer)analyzer, (String)"please divide this sentence into shingles", (String[])new String[]{"please divide this", "divide this sentence", "this sentence into", "sentence into shingles"}, (int[])new int[]{0, 7, 14, 19}, (int[])new int[]{18, 27, 32, 41}, (int[])new int[]{1, 1, 1, 1});
        analyzer.close();
    }

    public void testNoTokenSeparator() throws Exception {
        ShingleAnalyzerWrapper analyzer = new ShingleAnalyzerWrapper((Analyzer)new MockAnalyzer(ShingleAnalyzerWrapperTest.random(), MockTokenizer.WHITESPACE, false), 2, 2, "", true, false, "_");
        ShingleAnalyzerWrapperTest.assertAnalyzesTo((Analyzer)analyzer, (String)"please divide into shingles", (String[])new String[]{"please", "pleasedivide", "divide", "divideinto", "into", "intoshingles", "shingles"}, (int[])new int[]{0, 0, 7, 7, 14, 14, 19}, (int[])new int[]{6, 13, 13, 18, 18, 27, 27}, (int[])new int[]{1, 0, 1, 0, 1, 0, 1});
        analyzer.close();
        analyzer = new ShingleAnalyzerWrapper((Analyzer)new MockAnalyzer(ShingleAnalyzerWrapperTest.random(), MockTokenizer.WHITESPACE, false), 2, 2, "", false, false, "_");
        ShingleAnalyzerWrapperTest.assertAnalyzesTo((Analyzer)analyzer, (String)"please divide into shingles", (String[])new String[]{"pleasedivide", "divideinto", "intoshingles"}, (int[])new int[]{0, 7, 14}, (int[])new int[]{13, 18, 27}, (int[])new int[]{1, 1, 1});
        analyzer.close();
    }

    public void testNullTokenSeparator() throws Exception {
        ShingleAnalyzerWrapper analyzer = new ShingleAnalyzerWrapper((Analyzer)new MockAnalyzer(ShingleAnalyzerWrapperTest.random(), MockTokenizer.WHITESPACE, false), 2, 2, null, true, false, "_");
        ShingleAnalyzerWrapperTest.assertAnalyzesTo((Analyzer)analyzer, (String)"please divide into shingles", (String[])new String[]{"please", "pleasedivide", "divide", "divideinto", "into", "intoshingles", "shingles"}, (int[])new int[]{0, 0, 7, 7, 14, 14, 19}, (int[])new int[]{6, 13, 13, 18, 18, 27, 27}, (int[])new int[]{1, 0, 1, 0, 1, 0, 1});
        analyzer.close();
        analyzer = new ShingleAnalyzerWrapper((Analyzer)new MockAnalyzer(ShingleAnalyzerWrapperTest.random(), MockTokenizer.WHITESPACE, false), 2, 2, "", false, false, "_");
        ShingleAnalyzerWrapperTest.assertAnalyzesTo((Analyzer)analyzer, (String)"please divide into shingles", (String[])new String[]{"pleasedivide", "divideinto", "intoshingles"}, (int[])new int[]{0, 7, 14}, (int[])new int[]{13, 18, 27}, (int[])new int[]{1, 1, 1});
        analyzer.close();
    }

    public void testAltTokenSeparator() throws Exception {
        ShingleAnalyzerWrapper analyzer = new ShingleAnalyzerWrapper((Analyzer)new MockAnalyzer(ShingleAnalyzerWrapperTest.random(), MockTokenizer.WHITESPACE, false), 2, 2, "<SEP>", true, false, "_");
        ShingleAnalyzerWrapperTest.assertAnalyzesTo((Analyzer)analyzer, (String)"please divide into shingles", (String[])new String[]{"please", "please<SEP>divide", "divide", "divide<SEP>into", "into", "into<SEP>shingles", "shingles"}, (int[])new int[]{0, 0, 7, 7, 14, 14, 19}, (int[])new int[]{6, 13, 13, 18, 18, 27, 27}, (int[])new int[]{1, 0, 1, 0, 1, 0, 1});
        analyzer.close();
        analyzer = new ShingleAnalyzerWrapper((Analyzer)new MockAnalyzer(ShingleAnalyzerWrapperTest.random(), MockTokenizer.WHITESPACE, false), 2, 2, "<SEP>", false, false, "_");
        ShingleAnalyzerWrapperTest.assertAnalyzesTo((Analyzer)analyzer, (String)"please divide into shingles", (String[])new String[]{"please<SEP>divide", "divide<SEP>into", "into<SEP>shingles"}, (int[])new int[]{0, 7, 14}, (int[])new int[]{13, 18, 27}, (int[])new int[]{1, 1, 1});
        analyzer.close();
    }

    public void testAltFillerToken() throws Exception {
        Analyzer delegate = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                CharArraySet stopSet = StopFilter.makeStopSet((String[])new String[]{"into"});
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                StopFilter filter = new StopFilter((TokenStream)tokenizer, stopSet);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)filter);
            }
        };
        ShingleAnalyzerWrapper analyzer = new ShingleAnalyzerWrapper(delegate, 2, 2, " ", true, false, "--");
        ShingleAnalyzerWrapperTest.assertAnalyzesTo((Analyzer)analyzer, (String)"please divide into shingles", (String[])new String[]{"please", "please divide", "divide", "divide --", "-- shingles", "shingles"}, (int[])new int[]{0, 0, 7, 7, 19, 19}, (int[])new int[]{6, 13, 13, 19, 27, 27}, (int[])new int[]{1, 0, 1, 0, 1, 1});
        analyzer.close();
        delegate = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                CharArraySet stopSet = StopFilter.makeStopSet((String[])new String[]{"into"});
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                StopFilter filter = new StopFilter((TokenStream)tokenizer, stopSet);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)filter);
            }
        };
        analyzer = new ShingleAnalyzerWrapper(delegate, 2, 2, " ", false, false, null);
        ShingleAnalyzerWrapperTest.assertAnalyzesTo((Analyzer)analyzer, (String)"please divide into shingles", (String[])new String[]{"please divide", "divide ", " shingles"}, (int[])new int[]{0, 7, 19}, (int[])new int[]{13, 19, 27}, (int[])new int[]{1, 1, 1});
        analyzer.close();
        delegate = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                CharArraySet stopSet = StopFilter.makeStopSet((String[])new String[]{"into"});
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                StopFilter filter = new StopFilter((TokenStream)tokenizer, stopSet);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)filter);
            }
        };
        analyzer = new ShingleAnalyzerWrapper(delegate, 2, 2, " ", false, false, "");
        ShingleAnalyzerWrapperTest.assertAnalyzesTo((Analyzer)analyzer, (String)"please divide into shingles", (String[])new String[]{"please divide", "divide ", " shingles"}, (int[])new int[]{0, 7, 19}, (int[])new int[]{13, 19, 27}, (int[])new int[]{1, 1, 1});
        analyzer.close();
    }

    public void testOutputUnigramsIfNoShinglesSingleToken() throws Exception {
        ShingleAnalyzerWrapper analyzer = new ShingleAnalyzerWrapper((Analyzer)new MockAnalyzer(ShingleAnalyzerWrapperTest.random(), MockTokenizer.WHITESPACE, false), 2, 2, "", false, true, "_");
        ShingleAnalyzerWrapperTest.assertAnalyzesTo((Analyzer)analyzer, (String)"please", (String[])new String[]{"please"}, (int[])new int[]{0}, (int[])new int[]{6}, (int[])new int[]{1});
        analyzer.close();
    }
}

