/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.shingle;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CannedTokenStream;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.shingle.ShingleFilter;

public class ShingleFilterTest
extends BaseTokenStreamTestCase {
    public static final Token[] TEST_TOKEN = new Token[]{ShingleFilterTest.createToken("please", 0, 6), ShingleFilterTest.createToken("divide", 7, 13), ShingleFilterTest.createToken("this", 14, 18), ShingleFilterTest.createToken("sentence", 19, 27), ShingleFilterTest.createToken("into", 28, 32), ShingleFilterTest.createToken("shingles", 33, 39)};
    public static final int[] UNIGRAM_ONLY_POSITION_INCREMENTS = new int[]{1, 1, 1, 1, 1, 1};
    public static final String[] UNIGRAM_ONLY_TYPES = new String[]{"word", "word", "word", "word", "word", "word"};
    public static Token[] testTokenWithHoles;
    public static final Token[] BI_GRAM_TOKENS;
    public static final int[] BI_GRAM_POSITION_INCREMENTS;
    public static final String[] BI_GRAM_TYPES;
    public static final Token[] BI_GRAM_TOKENS_WITH_HOLES;
    public static final int[] BI_GRAM_POSITION_INCREMENTS_WITH_HOLES;
    private static final String[] BI_GRAM_TYPES_WITH_HOLES;
    public static final Token[] BI_GRAM_TOKENS_WITHOUT_UNIGRAMS;
    public static final int[] BI_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS;
    public static final String[] BI_GRAM_TYPES_WITHOUT_UNIGRAMS;
    public static final Token[] BI_GRAM_TOKENS_WITH_HOLES_WITHOUT_UNIGRAMS;
    public static final int[] BI_GRAM_POSITION_INCREMENTS_WITH_HOLES_WITHOUT_UNIGRAMS;
    public static final Token[] TEST_SINGLE_TOKEN;
    public static final Token[] SINGLE_TOKEN;
    public static final int[] SINGLE_TOKEN_INCREMENTS;
    public static final String[] SINGLE_TOKEN_TYPES;
    public static final Token[] EMPTY_TOKEN_ARRAY;
    public static final int[] EMPTY_TOKEN_INCREMENTS_ARRAY;
    public static final String[] EMPTY_TOKEN_TYPES_ARRAY;
    public static final Token[] TRI_GRAM_TOKENS;
    public static final int[] TRI_GRAM_POSITION_INCREMENTS;
    public static final String[] TRI_GRAM_TYPES;
    public static final Token[] TRI_GRAM_TOKENS_WITHOUT_UNIGRAMS;
    public static final int[] TRI_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS;
    public static final String[] TRI_GRAM_TYPES_WITHOUT_UNIGRAMS;
    public static final Token[] FOUR_GRAM_TOKENS;
    public static final int[] FOUR_GRAM_POSITION_INCREMENTS;
    public static final String[] FOUR_GRAM_TYPES;
    public static final Token[] FOUR_GRAM_TOKENS_WITHOUT_UNIGRAMS;
    public static final int[] FOUR_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS;
    public static final String[] FOUR_GRAM_TYPES_WITHOUT_UNIGRAMS;
    public static final Token[] TRI_GRAM_TOKENS_MIN_TRI_GRAM;
    public static final int[] TRI_GRAM_POSITION_INCREMENTS_MIN_TRI_GRAM;
    public static final String[] TRI_GRAM_TYPES_MIN_TRI_GRAM;
    public static final Token[] TRI_GRAM_TOKENS_WITHOUT_UNIGRAMS_MIN_TRI_GRAM;
    public static final int[] TRI_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS_MIN_TRI_GRAM;
    public static final String[] TRI_GRAM_TYPES_WITHOUT_UNIGRAMS_MIN_TRI_GRAM;
    public static final Token[] FOUR_GRAM_TOKENS_MIN_TRI_GRAM;
    public static final int[] FOUR_GRAM_POSITION_INCREMENTS_MIN_TRI_GRAM;
    public static final String[] FOUR_GRAM_TYPES_MIN_TRI_GRAM;
    public static final Token[] FOUR_GRAM_TOKENS_WITHOUT_UNIGRAMS_MIN_TRI_GRAM;
    public static final int[] FOUR_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS_MIN_TRI_GRAM;
    public static final String[] FOUR_GRAM_TYPES_WITHOUT_UNIGRAMS_MIN_TRI_GRAM;
    public static final Token[] FOUR_GRAM_TOKENS_MIN_FOUR_GRAM;
    public static final int[] FOUR_GRAM_POSITION_INCREMENTS_MIN_FOUR_GRAM;
    public static final String[] FOUR_GRAM_TYPES_MIN_FOUR_GRAM;
    public static final Token[] FOUR_GRAM_TOKENS_WITHOUT_UNIGRAMS_MIN_FOUR_GRAM;
    public static final int[] FOUR_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS_MIN_FOUR_GRAM;
    public static final String[] FOUR_GRAM_TYPES_WITHOUT_UNIGRAMS_MIN_FOUR_GRAM;
    public static final Token[] BI_GRAM_TOKENS_NO_SEPARATOR;
    public static final int[] BI_GRAM_POSITION_INCREMENTS_NO_SEPARATOR;
    public static final String[] BI_GRAM_TYPES_NO_SEPARATOR;
    public static final Token[] BI_GRAM_TOKENS_WITHOUT_UNIGRAMS_NO_SEPARATOR;
    public static final int[] BI_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS_NO_SEPARATOR;
    public static final String[] BI_GRAM_TYPES_WITHOUT_UNIGRAMS_NO_SEPARATOR;
    public static final Token[] TRI_GRAM_TOKENS_NO_SEPARATOR;
    public static final int[] TRI_GRAM_POSITION_INCREMENTS_NO_SEPARATOR;
    public static final String[] TRI_GRAM_TYPES_NO_SEPARATOR;
    public static final Token[] TRI_GRAM_TOKENS_WITHOUT_UNIGRAMS_NO_SEPARATOR;
    public static final int[] TRI_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS_NO_SEPARATOR;
    public static final String[] TRI_GRAM_TYPES_WITHOUT_UNIGRAMS_NO_SEPARATOR;
    public static final Token[] BI_GRAM_TOKENS_ALT_SEPARATOR;
    public static final int[] BI_GRAM_POSITION_INCREMENTS_ALT_SEPARATOR;
    public static final String[] BI_GRAM_TYPES_ALT_SEPARATOR;
    public static final Token[] BI_GRAM_TOKENS_WITHOUT_UNIGRAMS_ALT_SEPARATOR;
    public static final int[] BI_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS_ALT_SEPARATOR;
    public static final String[] BI_GRAM_TYPES_WITHOUT_UNIGRAMS_ALT_SEPARATOR;
    public static final Token[] TRI_GRAM_TOKENS_ALT_SEPARATOR;
    public static final int[] TRI_GRAM_POSITION_INCREMENTS_ALT_SEPARATOR;
    public static final String[] TRI_GRAM_TYPES_ALT_SEPARATOR;
    public static final Token[] TRI_GRAM_TOKENS_WITHOUT_UNIGRAMS_ALT_SEPARATOR;
    public static final int[] TRI_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS_ALT_SEPARATOR;
    public static final String[] TRI_GRAM_TYPES_WITHOUT_UNIGRAMS_ALT_SEPARATOR;
    public static final Token[] TRI_GRAM_TOKENS_NULL_SEPARATOR;
    public static final int[] TRI_GRAM_POSITION_INCREMENTS_NULL_SEPARATOR;
    public static final String[] TRI_GRAM_TYPES_NULL_SEPARATOR;
    public static final Token[] TEST_TOKEN_POS_INCR_EQUAL_TO_N;
    public static final Token[] TRI_GRAM_TOKENS_POS_INCR_EQUAL_TO_N;
    public static final int[] TRI_GRAM_POSITION_INCREMENTS_POS_INCR_EQUAL_TO_N;
    public static final String[] TRI_GRAM_TYPES_POS_INCR_EQUAL_TO_N;
    public static final Token[] TRI_GRAM_TOKENS_POS_INCR_EQUAL_TO_N_WITHOUT_UNIGRAMS;
    public static final int[] TRI_GRAM_POSITION_INCREMENTS_POS_INCR_EQUAL_TO_N_WITHOUT_UNIGRAMS;
    public static final String[] TRI_GRAM_TYPES_POS_INCR_EQUAL_TO_N_WITHOUT_UNIGRAMS;
    public static final Token[] TEST_TOKEN_POS_INCR_GREATER_THAN_N;
    public static final Token[] TRI_GRAM_TOKENS_POS_INCR_GREATER_THAN_N;
    public static final int[] TRI_GRAM_POSITION_INCREMENTS_POS_INCR_GREATER_THAN_N;
    public static final String[] TRI_GRAM_TYPES_POS_INCR_GREATER_THAN_N;
    public static final Token[] TRI_GRAM_TOKENS_POS_INCR_GREATER_THAN_N_WITHOUT_UNIGRAMS;
    public static final int[] TRI_GRAM_POSITION_INCREMENTS_POS_INCR_GREATER_THAN_N_WITHOUT_UNIGRAMS;
    public static final String[] TRI_GRAM_TYPES_POS_INCR_GREATER_THAN_N_WITHOUT_UNIGRAMS;

    public void setUp() throws Exception {
        super.setUp();
        testTokenWithHoles = new Token[]{ShingleFilterTest.createToken("please", 0, 6), ShingleFilterTest.createToken("divide", 7, 13), ShingleFilterTest.createToken("sentence", 19, 27, 2), ShingleFilterTest.createToken("shingles", 33, 39, 2)};
    }

    public void testBiGramFilter() throws IOException {
        this.shingleFilterTest(2, TEST_TOKEN, BI_GRAM_TOKENS, BI_GRAM_POSITION_INCREMENTS, BI_GRAM_TYPES, true);
    }

    public void testBiGramFilterWithHoles() throws IOException {
        this.shingleFilterTest(2, testTokenWithHoles, BI_GRAM_TOKENS_WITH_HOLES, BI_GRAM_POSITION_INCREMENTS_WITH_HOLES, BI_GRAM_TYPES_WITH_HOLES, true);
    }

    public void testBiGramFilterWithoutUnigrams() throws IOException {
        this.shingleFilterTest(2, TEST_TOKEN, BI_GRAM_TOKENS_WITHOUT_UNIGRAMS, BI_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS, BI_GRAM_TYPES_WITHOUT_UNIGRAMS, false);
    }

    public void testBiGramFilterWithHolesWithoutUnigrams() throws IOException {
        this.shingleFilterTest(2, testTokenWithHoles, BI_GRAM_TOKENS_WITH_HOLES_WITHOUT_UNIGRAMS, BI_GRAM_POSITION_INCREMENTS_WITH_HOLES_WITHOUT_UNIGRAMS, BI_GRAM_TYPES_WITHOUT_UNIGRAMS, false);
    }

    public void testBiGramFilterWithSingleToken() throws IOException {
        this.shingleFilterTest(2, TEST_SINGLE_TOKEN, SINGLE_TOKEN, SINGLE_TOKEN_INCREMENTS, SINGLE_TOKEN_TYPES, true);
    }

    public void testBiGramFilterWithSingleTokenWithoutUnigrams() throws IOException {
        this.shingleFilterTest(2, TEST_SINGLE_TOKEN, EMPTY_TOKEN_ARRAY, EMPTY_TOKEN_INCREMENTS_ARRAY, EMPTY_TOKEN_TYPES_ARRAY, false);
    }

    public void testBiGramFilterWithEmptyTokenStream() throws IOException {
        this.shingleFilterTest(2, EMPTY_TOKEN_ARRAY, EMPTY_TOKEN_ARRAY, EMPTY_TOKEN_INCREMENTS_ARRAY, EMPTY_TOKEN_TYPES_ARRAY, true);
    }

    public void testBiGramFilterWithEmptyTokenStreamWithoutUnigrams() throws IOException {
        this.shingleFilterTest(2, EMPTY_TOKEN_ARRAY, EMPTY_TOKEN_ARRAY, EMPTY_TOKEN_INCREMENTS_ARRAY, EMPTY_TOKEN_TYPES_ARRAY, false);
    }

    public void testTriGramFilter() throws IOException {
        this.shingleFilterTest(3, TEST_TOKEN, TRI_GRAM_TOKENS, TRI_GRAM_POSITION_INCREMENTS, TRI_GRAM_TYPES, true);
    }

    public void testTriGramFilterWithoutUnigrams() throws IOException {
        this.shingleFilterTest(3, TEST_TOKEN, TRI_GRAM_TOKENS_WITHOUT_UNIGRAMS, TRI_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS, TRI_GRAM_TYPES_WITHOUT_UNIGRAMS, false);
    }

    public void testFourGramFilter() throws IOException {
        this.shingleFilterTest(4, TEST_TOKEN, FOUR_GRAM_TOKENS, FOUR_GRAM_POSITION_INCREMENTS, FOUR_GRAM_TYPES, true);
    }

    public void testFourGramFilterWithoutUnigrams() throws IOException {
        this.shingleFilterTest(4, TEST_TOKEN, FOUR_GRAM_TOKENS_WITHOUT_UNIGRAMS, FOUR_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS, FOUR_GRAM_TYPES_WITHOUT_UNIGRAMS, false);
    }

    public void testTriGramFilterMinTriGram() throws IOException {
        this.shingleFilterTest(3, 3, TEST_TOKEN, TRI_GRAM_TOKENS_MIN_TRI_GRAM, TRI_GRAM_POSITION_INCREMENTS_MIN_TRI_GRAM, TRI_GRAM_TYPES_MIN_TRI_GRAM, true);
    }

    public void testTriGramFilterWithoutUnigramsMinTriGram() throws IOException {
        this.shingleFilterTest(3, 3, TEST_TOKEN, TRI_GRAM_TOKENS_WITHOUT_UNIGRAMS_MIN_TRI_GRAM, TRI_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS_MIN_TRI_GRAM, TRI_GRAM_TYPES_WITHOUT_UNIGRAMS_MIN_TRI_GRAM, false);
    }

    public void testFourGramFilterMinTriGram() throws IOException {
        this.shingleFilterTest(3, 4, TEST_TOKEN, FOUR_GRAM_TOKENS_MIN_TRI_GRAM, FOUR_GRAM_POSITION_INCREMENTS_MIN_TRI_GRAM, FOUR_GRAM_TYPES_MIN_TRI_GRAM, true);
    }

    public void testFourGramFilterWithoutUnigramsMinTriGram() throws IOException {
        this.shingleFilterTest(3, 4, TEST_TOKEN, FOUR_GRAM_TOKENS_WITHOUT_UNIGRAMS_MIN_TRI_GRAM, FOUR_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS_MIN_TRI_GRAM, FOUR_GRAM_TYPES_WITHOUT_UNIGRAMS_MIN_TRI_GRAM, false);
    }

    public void testFourGramFilterMinFourGram() throws IOException {
        this.shingleFilterTest(4, 4, TEST_TOKEN, FOUR_GRAM_TOKENS_MIN_FOUR_GRAM, FOUR_GRAM_POSITION_INCREMENTS_MIN_FOUR_GRAM, FOUR_GRAM_TYPES_MIN_FOUR_GRAM, true);
    }

    public void testFourGramFilterWithoutUnigramsMinFourGram() throws IOException {
        this.shingleFilterTest(4, 4, TEST_TOKEN, FOUR_GRAM_TOKENS_WITHOUT_UNIGRAMS_MIN_FOUR_GRAM, FOUR_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS_MIN_FOUR_GRAM, FOUR_GRAM_TYPES_WITHOUT_UNIGRAMS_MIN_FOUR_GRAM, false);
    }

    public void testBiGramFilterNoSeparator() throws IOException {
        this.shingleFilterTest("", 2, 2, TEST_TOKEN, BI_GRAM_TOKENS_NO_SEPARATOR, BI_GRAM_POSITION_INCREMENTS_NO_SEPARATOR, BI_GRAM_TYPES_NO_SEPARATOR, true);
    }

    public void testBiGramFilterWithoutUnigramsNoSeparator() throws IOException {
        this.shingleFilterTest("", 2, 2, TEST_TOKEN, BI_GRAM_TOKENS_WITHOUT_UNIGRAMS_NO_SEPARATOR, BI_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS_NO_SEPARATOR, BI_GRAM_TYPES_WITHOUT_UNIGRAMS_NO_SEPARATOR, false);
    }

    public void testTriGramFilterNoSeparator() throws IOException {
        this.shingleFilterTest("", 2, 3, TEST_TOKEN, TRI_GRAM_TOKENS_NO_SEPARATOR, TRI_GRAM_POSITION_INCREMENTS_NO_SEPARATOR, TRI_GRAM_TYPES_NO_SEPARATOR, true);
    }

    public void testTriGramFilterWithoutUnigramsNoSeparator() throws IOException {
        this.shingleFilterTest("", 2, 3, TEST_TOKEN, TRI_GRAM_TOKENS_WITHOUT_UNIGRAMS_NO_SEPARATOR, TRI_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS_NO_SEPARATOR, TRI_GRAM_TYPES_WITHOUT_UNIGRAMS_NO_SEPARATOR, false);
    }

    public void testBiGramFilterAltSeparator() throws IOException {
        this.shingleFilterTest("<SEP>", 2, 2, TEST_TOKEN, BI_GRAM_TOKENS_ALT_SEPARATOR, BI_GRAM_POSITION_INCREMENTS_ALT_SEPARATOR, BI_GRAM_TYPES_ALT_SEPARATOR, true);
    }

    public void testBiGramFilterWithoutUnigramsAltSeparator() throws IOException {
        this.shingleFilterTest("<SEP>", 2, 2, TEST_TOKEN, BI_GRAM_TOKENS_WITHOUT_UNIGRAMS_ALT_SEPARATOR, BI_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS_ALT_SEPARATOR, BI_GRAM_TYPES_WITHOUT_UNIGRAMS_ALT_SEPARATOR, false);
    }

    public void testTriGramFilterAltSeparator() throws IOException {
        this.shingleFilterTest("<SEP>", 2, 3, TEST_TOKEN, TRI_GRAM_TOKENS_ALT_SEPARATOR, TRI_GRAM_POSITION_INCREMENTS_ALT_SEPARATOR, TRI_GRAM_TYPES_ALT_SEPARATOR, true);
    }

    public void testTriGramFilterWithoutUnigramsAltSeparator() throws IOException {
        this.shingleFilterTest("<SEP>", 2, 3, TEST_TOKEN, TRI_GRAM_TOKENS_WITHOUT_UNIGRAMS_ALT_SEPARATOR, TRI_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS_ALT_SEPARATOR, TRI_GRAM_TYPES_WITHOUT_UNIGRAMS_ALT_SEPARATOR, false);
    }

    public void testTriGramFilterNullSeparator() throws IOException {
        this.shingleFilterTest(null, 2, 3, TEST_TOKEN, TRI_GRAM_TOKENS_NULL_SEPARATOR, TRI_GRAM_POSITION_INCREMENTS_NULL_SEPARATOR, TRI_GRAM_TYPES_NULL_SEPARATOR, true);
    }

    public void testPositionIncrementEqualToN() throws IOException {
        this.shingleFilterTest(2, 3, TEST_TOKEN_POS_INCR_EQUAL_TO_N, TRI_GRAM_TOKENS_POS_INCR_EQUAL_TO_N, TRI_GRAM_POSITION_INCREMENTS_POS_INCR_EQUAL_TO_N, TRI_GRAM_TYPES_POS_INCR_EQUAL_TO_N, true);
    }

    public void testPositionIncrementEqualToNWithoutUnigrams() throws IOException {
        this.shingleFilterTest(2, 3, TEST_TOKEN_POS_INCR_EQUAL_TO_N, TRI_GRAM_TOKENS_POS_INCR_EQUAL_TO_N_WITHOUT_UNIGRAMS, TRI_GRAM_POSITION_INCREMENTS_POS_INCR_EQUAL_TO_N_WITHOUT_UNIGRAMS, TRI_GRAM_TYPES_POS_INCR_EQUAL_TO_N_WITHOUT_UNIGRAMS, false);
    }

    public void testPositionIncrementGreaterThanN() throws IOException {
        this.shingleFilterTest(2, 3, TEST_TOKEN_POS_INCR_GREATER_THAN_N, TRI_GRAM_TOKENS_POS_INCR_GREATER_THAN_N, TRI_GRAM_POSITION_INCREMENTS_POS_INCR_GREATER_THAN_N, TRI_GRAM_TYPES_POS_INCR_GREATER_THAN_N, true);
    }

    public void testPositionIncrementGreaterThanNWithoutUnigrams() throws IOException {
        this.shingleFilterTest(2, 3, TEST_TOKEN_POS_INCR_GREATER_THAN_N, TRI_GRAM_TOKENS_POS_INCR_GREATER_THAN_N_WITHOUT_UNIGRAMS, TRI_GRAM_POSITION_INCREMENTS_POS_INCR_GREATER_THAN_N_WITHOUT_UNIGRAMS, TRI_GRAM_TYPES_POS_INCR_GREATER_THAN_N_WITHOUT_UNIGRAMS, false);
    }

    public void testReset() throws Exception {
        WhitespaceTokenizer wsTokenizer = new WhitespaceTokenizer();
        wsTokenizer.setReader((Reader)new StringReader("please divide this sentence"));
        ShingleFilter filter = new ShingleFilter((TokenStream)wsTokenizer, 2);
        ShingleFilterTest.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"please", "please divide", "divide", "divide this", "this", "this sentence", "sentence"}, (int[])new int[]{0, 0, 7, 7, 14, 14, 19}, (int[])new int[]{6, 13, 13, 18, 18, 27, 27}, (String[])new String[]{"word", "shingle", "word", "shingle", "word", "shingle", "word"}, (int[])new int[]{1, 0, 1, 0, 1, 0, 1});
        wsTokenizer.setReader((Reader)new StringReader("please divide this sentence"));
        ShingleFilterTest.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"please", "please divide", "divide", "divide this", "this", "this sentence", "sentence"}, (int[])new int[]{0, 0, 7, 7, 14, 14, 19}, (int[])new int[]{6, 13, 13, 18, 18, 27, 27}, (String[])new String[]{"word", "shingle", "word", "shingle", "word", "shingle", "word"}, (int[])new int[]{1, 0, 1, 0, 1, 0, 1});
    }

    public void testOutputUnigramsIfNoShinglesSingleTokenCase() throws IOException {
        this.shingleFilterTest(2, 2, TEST_SINGLE_TOKEN, SINGLE_TOKEN, SINGLE_TOKEN_INCREMENTS, SINGLE_TOKEN_TYPES, false, true);
    }

    public void testOutputUnigramsIfNoShinglesWithSimpleBigram() throws IOException {
        this.shingleFilterTest(2, 2, TEST_TOKEN, BI_GRAM_TOKENS, BI_GRAM_POSITION_INCREMENTS, BI_GRAM_TYPES, true, true);
    }

    public void testOutputUnigramsIfNoShinglesWithSimpleUnigramlessBigram() throws IOException {
        this.shingleFilterTest(2, 2, TEST_TOKEN, BI_GRAM_TOKENS_WITHOUT_UNIGRAMS, BI_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS, BI_GRAM_TYPES_WITHOUT_UNIGRAMS, false, true);
    }

    public void testOutputUnigramsIfNoShinglesWithMultipleInputTokens() throws IOException {
        this.shingleFilterTest(7, 7, TEST_TOKEN, TEST_TOKEN, UNIGRAM_ONLY_POSITION_INCREMENTS, UNIGRAM_ONLY_TYPES, false, true);
    }

    protected void shingleFilterTest(int maxSize, Token[] tokensToShingle, Token[] tokensToCompare, int[] positionIncrements, String[] types, boolean outputUnigrams) throws IOException {
        ShingleFilter filter = new ShingleFilter((TokenStream)new CannedTokenStream(tokensToShingle), maxSize);
        filter.setOutputUnigrams(outputUnigrams);
        this.shingleFilterTestCommon(filter, tokensToCompare, positionIncrements, types);
    }

    protected void shingleFilterTest(int minSize, int maxSize, Token[] tokensToShingle, Token[] tokensToCompare, int[] positionIncrements, String[] types, boolean outputUnigrams) throws IOException {
        ShingleFilter filter = new ShingleFilter((TokenStream)new CannedTokenStream(tokensToShingle), minSize, maxSize);
        filter.setOutputUnigrams(outputUnigrams);
        this.shingleFilterTestCommon(filter, tokensToCompare, positionIncrements, types);
    }

    protected void shingleFilterTest(int minSize, int maxSize, Token[] tokensToShingle, Token[] tokensToCompare, int[] positionIncrements, String[] types, boolean outputUnigrams, boolean outputUnigramsIfNoShingles) throws IOException {
        ShingleFilter filter = new ShingleFilter((TokenStream)new CannedTokenStream(tokensToShingle), minSize, maxSize);
        filter.setOutputUnigrams(outputUnigrams);
        filter.setOutputUnigramsIfNoShingles(outputUnigramsIfNoShingles);
        this.shingleFilterTestCommon(filter, tokensToCompare, positionIncrements, types);
    }

    protected void shingleFilterTest(String tokenSeparator, int minSize, int maxSize, Token[] tokensToShingle, Token[] tokensToCompare, int[] positionIncrements, String[] types, boolean outputUnigrams) throws IOException {
        ShingleFilter filter = new ShingleFilter((TokenStream)new CannedTokenStream(tokensToShingle), minSize, maxSize);
        filter.setTokenSeparator(tokenSeparator);
        filter.setOutputUnigrams(outputUnigrams);
        this.shingleFilterTestCommon(filter, tokensToCompare, positionIncrements, types);
    }

    protected void shingleFilterTestCommon(ShingleFilter filter, Token[] tokensToCompare, int[] positionIncrements, String[] types) throws IOException {
        String[] text = new String[tokensToCompare.length];
        int[] startOffsets = new int[tokensToCompare.length];
        int[] endOffsets = new int[tokensToCompare.length];
        for (int i = 0; i < tokensToCompare.length; ++i) {
            text[i] = new String(tokensToCompare[i].buffer(), 0, tokensToCompare[i].length());
            startOffsets[i] = tokensToCompare[i].startOffset();
            endOffsets[i] = tokensToCompare[i].endOffset();
        }
        ShingleFilterTest.assertTokenStreamContents((TokenStream)filter, (String[])text, (int[])startOffsets, (int[])endOffsets, (String[])types, (int[])positionIncrements);
    }

    private static Token createToken(String term, int start, int offset) {
        return ShingleFilterTest.createToken(term, start, offset, 1);
    }

    private static Token createToken(String term, int start, int offset, int positionIncrement) {
        Token token = new Token();
        token.setOffset(start, offset);
        token.copyBuffer(term.toCharArray(), 0, term.length());
        token.setPositionIncrement(positionIncrement);
        return token;
    }

    public void testRandomStrings() throws Exception {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new ShingleFilter((TokenStream)tokenizer));
            }
        };
        ShingleFilterTest.checkRandomData((Random)ShingleFilterTest.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
    }

    public void testRandomHugeStrings() throws Exception {
        Random random = ShingleFilterTest.random();
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new ShingleFilter((TokenStream)tokenizer));
            }
        };
        ShingleFilterTest.checkRandomData((Random)random, (Analyzer)a, (int)(100 * RANDOM_MULTIPLIER), (int)8192);
        a.close();
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new ShingleFilter((TokenStream)tokenizer));
            }
        };
        ShingleFilterTest.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }

    public void testTrailingHole1() throws IOException {
        Token[] inputTokens = new Token[]{ShingleFilterTest.createToken("wizard", 0, 6)};
        ShingleFilter filter = new ShingleFilter((TokenStream)new CannedTokenStream(1, 9, inputTokens), 2, 2);
        ShingleFilterTest.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"wizard", "wizard _"}, (int[])new int[]{0, 0}, (int[])new int[]{6, 9}, (int[])new int[]{1, 0}, (Integer)9);
    }

    public void testTrailingHole2() throws IOException {
        Token[] inputTokens = new Token[]{ShingleFilterTest.createToken("purple", 0, 6), ShingleFilterTest.createToken("wizard", 7, 13)};
        ShingleFilter filter = new ShingleFilter((TokenStream)new CannedTokenStream(1, 16, inputTokens), 2, 2);
        ShingleFilterTest.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"purple", "purple wizard", "wizard", "wizard _"}, (int[])new int[]{0, 0, 7, 7}, (int[])new int[]{6, 13, 13, 16}, (int[])new int[]{1, 0, 1, 0}, (Integer)16);
    }

    public void testTwoTrailingHoles() throws IOException {
        Token[] inputTokens = new Token[]{ShingleFilterTest.createToken("purple", 0, 6), ShingleFilterTest.createToken("wizard", 7, 13)};
        ShingleFilter filter = new ShingleFilter((TokenStream)new CannedTokenStream(2, 20, inputTokens), 2, 2);
        ShingleFilterTest.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"purple", "purple wizard", "wizard", "wizard _"}, (int[])new int[]{0, 0, 7, 7}, (int[])new int[]{6, 13, 13, 20}, (int[])new int[]{1, 0, 1, 0}, (Integer)20);
    }

    public void testTwoTrailingHolesTriShingle() throws IOException {
        Token[] inputTokens = new Token[]{ShingleFilterTest.createToken("purple", 0, 6), ShingleFilterTest.createToken("wizard", 7, 13)};
        ShingleFilter filter = new ShingleFilter((TokenStream)new CannedTokenStream(2, 20, inputTokens), 2, 3);
        ShingleFilterTest.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"purple", "purple wizard", "purple wizard _", "wizard", "wizard _", "wizard _ _"}, (int[])new int[]{0, 0, 0, 7, 7, 7}, (int[])new int[]{6, 13, 20, 13, 20, 20}, (int[])new int[]{1, 0, 0, 1, 0, 0}, (Integer)20);
    }

    public void testTwoTrailingHolesTriShingleWithTokenFiller() throws IOException {
        Token[] inputTokens = new Token[]{ShingleFilterTest.createToken("purple", 0, 6), ShingleFilterTest.createToken("wizard", 7, 13)};
        ShingleFilter filter = new ShingleFilter((TokenStream)new CannedTokenStream(2, 20, inputTokens), 2, 3);
        filter.setFillerToken("--");
        ShingleFilterTest.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"purple", "purple wizard", "purple wizard --", "wizard", "wizard --", "wizard -- --"}, (int[])new int[]{0, 0, 0, 7, 7, 7}, (int[])new int[]{6, 13, 20, 13, 20, 20}, (int[])new int[]{1, 0, 0, 1, 0, 0}, (Integer)20);
        filter = new ShingleFilter((TokenStream)new CannedTokenStream(2, 20, inputTokens), 2, 3);
        filter.setFillerToken("");
        ShingleFilterTest.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"purple", "purple wizard", "purple wizard ", "wizard", "wizard ", "wizard  "}, (int[])new int[]{0, 0, 0, 7, 7, 7}, (int[])new int[]{6, 13, 20, 13, 20, 20}, (int[])new int[]{1, 0, 0, 1, 0, 0}, (Integer)20);
        filter = new ShingleFilter((TokenStream)new CannedTokenStream(2, 20, inputTokens), 2, 3);
        filter.setFillerToken(null);
        ShingleFilterTest.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"purple", "purple wizard", "purple wizard ", "wizard", "wizard ", "wizard  "}, (int[])new int[]{0, 0, 0, 7, 7, 7}, (int[])new int[]{6, 13, 20, 13, 20, 20}, (int[])new int[]{1, 0, 0, 1, 0, 0}, (Integer)20);
        filter = new ShingleFilter((TokenStream)new CannedTokenStream(2, 20, inputTokens), 2, 3);
        filter.setFillerToken(null);
        filter.setTokenSeparator(null);
        ShingleFilterTest.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"purple", "purplewizard", "purplewizard", "wizard", "wizard", "wizard"}, (int[])new int[]{0, 0, 0, 7, 7, 7}, (int[])new int[]{6, 13, 20, 13, 20, 20}, (int[])new int[]{1, 0, 0, 1, 0, 0}, (Integer)20);
    }

    public void testPositionLength() throws Exception {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                ShingleFilter filter = new ShingleFilter((TokenStream)tokenizer, 4, 4);
                filter.setOutputUnigrams(false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)filter);
            }
        };
        ShingleFilterTest.assertTokenStreamContents((TokenStream)a.tokenStream("", "to be or not to be"), (String[])new String[]{"to be or not", "be or not to", "or not to be"}, (int[])new int[]{0, 3, 6}, (int[])new int[]{12, 15, 18}, null, (int[])new int[]{1, 1, 1}, (int[])new int[]{1, 1, 1}, (Integer)18, (boolean)false);
        a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                ShingleFilter filter = new ShingleFilter((TokenStream)tokenizer, 2, 4);
                filter.setOutputUnigrams(false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)filter);
            }
        };
        ShingleFilterTest.assertTokenStreamContents((TokenStream)a.tokenStream("", "to be or not to be"), (String[])new String[]{"to be", "to be or", "to be or not", "be or", "be or not", "be or not to", "or not", "or not to", "or not to be", "not to", "not to be", "to be"}, (int[])new int[]{0, 0, 0, 3, 3, 3, 6, 6, 6, 9, 9, 13}, (int[])new int[]{5, 8, 12, 8, 12, 15, 12, 15, 18, 15, 18, 18}, null, (int[])new int[]{1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1}, (int[])new int[]{1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 1}, (Integer)18, (boolean)false);
        a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                ShingleFilter filter = new ShingleFilter((TokenStream)tokenizer, 3, 4);
                filter.setOutputUnigrams(false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)filter);
            }
        };
        ShingleFilterTest.assertTokenStreamContents((TokenStream)a.tokenStream("", "to be or not to be"), (String[])new String[]{"to be or", "to be or not", "be or not", "be or not to", "or not to", "or not to be", "not to be"}, (int[])new int[]{0, 0, 3, 3, 6, 6, 9}, (int[])new int[]{8, 12, 12, 15, 15, 18, 18}, null, (int[])new int[]{1, 0, 1, 0, 1, 0, 1, 0}, (int[])new int[]{1, 2, 1, 2, 1, 2, 1, 2}, (Integer)18, (boolean)false);
        a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                ShingleFilter filter = new ShingleFilter((TokenStream)tokenizer, 3, 5);
                filter.setOutputUnigrams(false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)filter);
            }
        };
        ShingleFilterTest.assertTokenStreamContents((TokenStream)a.tokenStream("", "to be or not to be"), (String[])new String[]{"to be or", "to be or not", "to be or not to", "be or not", "be or not to", "be or not to be", "or not to", "or not to be", "not to be"}, (int[])new int[]{0, 0, 0, 3, 3, 3, 6, 6, 9, 9}, (int[])new int[]{8, 12, 15, 12, 15, 18, 15, 18, 18}, null, (int[])new int[]{1, 0, 0, 1, 0, 0, 1, 0, 1, 0}, (int[])new int[]{1, 2, 3, 1, 2, 3, 1, 2, 1}, (Integer)18, (boolean)false);
    }

    static {
        BI_GRAM_TOKENS = new Token[]{ShingleFilterTest.createToken("please", 0, 6), ShingleFilterTest.createToken("please divide", 0, 13), ShingleFilterTest.createToken("divide", 7, 13), ShingleFilterTest.createToken("divide this", 7, 18), ShingleFilterTest.createToken("this", 14, 18), ShingleFilterTest.createToken("this sentence", 14, 27), ShingleFilterTest.createToken("sentence", 19, 27), ShingleFilterTest.createToken("sentence into", 19, 32), ShingleFilterTest.createToken("into", 28, 32), ShingleFilterTest.createToken("into shingles", 28, 39), ShingleFilterTest.createToken("shingles", 33, 39)};
        BI_GRAM_POSITION_INCREMENTS = new int[]{1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1};
        BI_GRAM_TYPES = new String[]{"word", "shingle", "word", "shingle", "word", "shingle", "word", "shingle", "word", "shingle", "word"};
        BI_GRAM_TOKENS_WITH_HOLES = new Token[]{ShingleFilterTest.createToken("please", 0, 6), ShingleFilterTest.createToken("please divide", 0, 13), ShingleFilterTest.createToken("divide", 7, 13), ShingleFilterTest.createToken("divide _", 7, 19), ShingleFilterTest.createToken("_ sentence", 19, 27), ShingleFilterTest.createToken("sentence", 19, 27), ShingleFilterTest.createToken("sentence _", 19, 33), ShingleFilterTest.createToken("_ shingles", 33, 39), ShingleFilterTest.createToken("shingles", 33, 39)};
        BI_GRAM_POSITION_INCREMENTS_WITH_HOLES = new int[]{1, 0, 1, 0, 1, 1, 0, 1, 1};
        BI_GRAM_TYPES_WITH_HOLES = new String[]{"word", "shingle", "word", "shingle", "shingle", "word", "shingle", "shingle", "word"};
        BI_GRAM_TOKENS_WITHOUT_UNIGRAMS = new Token[]{ShingleFilterTest.createToken("please divide", 0, 13), ShingleFilterTest.createToken("divide this", 7, 18), ShingleFilterTest.createToken("this sentence", 14, 27), ShingleFilterTest.createToken("sentence into", 19, 32), ShingleFilterTest.createToken("into shingles", 28, 39)};
        BI_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS = new int[]{1, 1, 1, 1, 1};
        BI_GRAM_TYPES_WITHOUT_UNIGRAMS = new String[]{"shingle", "shingle", "shingle", "shingle", "shingle"};
        BI_GRAM_TOKENS_WITH_HOLES_WITHOUT_UNIGRAMS = new Token[]{ShingleFilterTest.createToken("please divide", 0, 13), ShingleFilterTest.createToken("divide _", 7, 19), ShingleFilterTest.createToken("_ sentence", 19, 27), ShingleFilterTest.createToken("sentence _", 19, 33), ShingleFilterTest.createToken("_ shingles", 33, 39)};
        BI_GRAM_POSITION_INCREMENTS_WITH_HOLES_WITHOUT_UNIGRAMS = new int[]{1, 1, 1, 1, 1, 1};
        TEST_SINGLE_TOKEN = new Token[]{ShingleFilterTest.createToken("please", 0, 6)};
        SINGLE_TOKEN = new Token[]{ShingleFilterTest.createToken("please", 0, 6)};
        SINGLE_TOKEN_INCREMENTS = new int[]{1};
        SINGLE_TOKEN_TYPES = new String[]{"word"};
        EMPTY_TOKEN_ARRAY = new Token[0];
        EMPTY_TOKEN_INCREMENTS_ARRAY = new int[0];
        EMPTY_TOKEN_TYPES_ARRAY = new String[0];
        TRI_GRAM_TOKENS = new Token[]{ShingleFilterTest.createToken("please", 0, 6), ShingleFilterTest.createToken("please divide", 0, 13), ShingleFilterTest.createToken("please divide this", 0, 18), ShingleFilterTest.createToken("divide", 7, 13), ShingleFilterTest.createToken("divide this", 7, 18), ShingleFilterTest.createToken("divide this sentence", 7, 27), ShingleFilterTest.createToken("this", 14, 18), ShingleFilterTest.createToken("this sentence", 14, 27), ShingleFilterTest.createToken("this sentence into", 14, 32), ShingleFilterTest.createToken("sentence", 19, 27), ShingleFilterTest.createToken("sentence into", 19, 32), ShingleFilterTest.createToken("sentence into shingles", 19, 39), ShingleFilterTest.createToken("into", 28, 32), ShingleFilterTest.createToken("into shingles", 28, 39), ShingleFilterTest.createToken("shingles", 33, 39)};
        TRI_GRAM_POSITION_INCREMENTS = new int[]{1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1};
        TRI_GRAM_TYPES = new String[]{"word", "shingle", "shingle", "word", "shingle", "shingle", "word", "shingle", "shingle", "word", "shingle", "shingle", "word", "shingle", "word"};
        TRI_GRAM_TOKENS_WITHOUT_UNIGRAMS = new Token[]{ShingleFilterTest.createToken("please divide", 0, 13), ShingleFilterTest.createToken("please divide this", 0, 18), ShingleFilterTest.createToken("divide this", 7, 18), ShingleFilterTest.createToken("divide this sentence", 7, 27), ShingleFilterTest.createToken("this sentence", 14, 27), ShingleFilterTest.createToken("this sentence into", 14, 32), ShingleFilterTest.createToken("sentence into", 19, 32), ShingleFilterTest.createToken("sentence into shingles", 19, 39), ShingleFilterTest.createToken("into shingles", 28, 39)};
        TRI_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS = new int[]{1, 0, 1, 0, 1, 0, 1, 0, 1};
        TRI_GRAM_TYPES_WITHOUT_UNIGRAMS = new String[]{"shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle"};
        FOUR_GRAM_TOKENS = new Token[]{ShingleFilterTest.createToken("please", 0, 6), ShingleFilterTest.createToken("please divide", 0, 13), ShingleFilterTest.createToken("please divide this", 0, 18), ShingleFilterTest.createToken("please divide this sentence", 0, 27), ShingleFilterTest.createToken("divide", 7, 13), ShingleFilterTest.createToken("divide this", 7, 18), ShingleFilterTest.createToken("divide this sentence", 7, 27), ShingleFilterTest.createToken("divide this sentence into", 7, 32), ShingleFilterTest.createToken("this", 14, 18), ShingleFilterTest.createToken("this sentence", 14, 27), ShingleFilterTest.createToken("this sentence into", 14, 32), ShingleFilterTest.createToken("this sentence into shingles", 14, 39), ShingleFilterTest.createToken("sentence", 19, 27), ShingleFilterTest.createToken("sentence into", 19, 32), ShingleFilterTest.createToken("sentence into shingles", 19, 39), ShingleFilterTest.createToken("into", 28, 32), ShingleFilterTest.createToken("into shingles", 28, 39), ShingleFilterTest.createToken("shingles", 33, 39)};
        FOUR_GRAM_POSITION_INCREMENTS = new int[]{1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1};
        FOUR_GRAM_TYPES = new String[]{"word", "shingle", "shingle", "shingle", "word", "shingle", "shingle", "shingle", "word", "shingle", "shingle", "shingle", "word", "shingle", "shingle", "word", "shingle", "word"};
        FOUR_GRAM_TOKENS_WITHOUT_UNIGRAMS = new Token[]{ShingleFilterTest.createToken("please divide", 0, 13), ShingleFilterTest.createToken("please divide this", 0, 18), ShingleFilterTest.createToken("please divide this sentence", 0, 27), ShingleFilterTest.createToken("divide this", 7, 18), ShingleFilterTest.createToken("divide this sentence", 7, 27), ShingleFilterTest.createToken("divide this sentence into", 7, 32), ShingleFilterTest.createToken("this sentence", 14, 27), ShingleFilterTest.createToken("this sentence into", 14, 32), ShingleFilterTest.createToken("this sentence into shingles", 14, 39), ShingleFilterTest.createToken("sentence into", 19, 32), ShingleFilterTest.createToken("sentence into shingles", 19, 39), ShingleFilterTest.createToken("into shingles", 28, 39)};
        FOUR_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS = new int[]{1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1};
        FOUR_GRAM_TYPES_WITHOUT_UNIGRAMS = new String[]{"shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle"};
        TRI_GRAM_TOKENS_MIN_TRI_GRAM = new Token[]{ShingleFilterTest.createToken("please", 0, 6), ShingleFilterTest.createToken("please divide this", 0, 18), ShingleFilterTest.createToken("divide", 7, 13), ShingleFilterTest.createToken("divide this sentence", 7, 27), ShingleFilterTest.createToken("this", 14, 18), ShingleFilterTest.createToken("this sentence into", 14, 32), ShingleFilterTest.createToken("sentence", 19, 27), ShingleFilterTest.createToken("sentence into shingles", 19, 39), ShingleFilterTest.createToken("into", 28, 32), ShingleFilterTest.createToken("shingles", 33, 39)};
        TRI_GRAM_POSITION_INCREMENTS_MIN_TRI_GRAM = new int[]{1, 0, 1, 0, 1, 0, 1, 0, 1, 1};
        TRI_GRAM_TYPES_MIN_TRI_GRAM = new String[]{"word", "shingle", "word", "shingle", "word", "shingle", "word", "shingle", "word", "word"};
        TRI_GRAM_TOKENS_WITHOUT_UNIGRAMS_MIN_TRI_GRAM = new Token[]{ShingleFilterTest.createToken("please divide this", 0, 18), ShingleFilterTest.createToken("divide this sentence", 7, 27), ShingleFilterTest.createToken("this sentence into", 14, 32), ShingleFilterTest.createToken("sentence into shingles", 19, 39)};
        TRI_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS_MIN_TRI_GRAM = new int[]{1, 1, 1, 1};
        TRI_GRAM_TYPES_WITHOUT_UNIGRAMS_MIN_TRI_GRAM = new String[]{"shingle", "shingle", "shingle", "shingle"};
        FOUR_GRAM_TOKENS_MIN_TRI_GRAM = new Token[]{ShingleFilterTest.createToken("please", 0, 6), ShingleFilterTest.createToken("please divide this", 0, 18), ShingleFilterTest.createToken("please divide this sentence", 0, 27), ShingleFilterTest.createToken("divide", 7, 13), ShingleFilterTest.createToken("divide this sentence", 7, 27), ShingleFilterTest.createToken("divide this sentence into", 7, 32), ShingleFilterTest.createToken("this", 14, 18), ShingleFilterTest.createToken("this sentence into", 14, 32), ShingleFilterTest.createToken("this sentence into shingles", 14, 39), ShingleFilterTest.createToken("sentence", 19, 27), ShingleFilterTest.createToken("sentence into shingles", 19, 39), ShingleFilterTest.createToken("into", 28, 32), ShingleFilterTest.createToken("shingles", 33, 39)};
        FOUR_GRAM_POSITION_INCREMENTS_MIN_TRI_GRAM = new int[]{1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 1};
        FOUR_GRAM_TYPES_MIN_TRI_GRAM = new String[]{"word", "shingle", "shingle", "word", "shingle", "shingle", "word", "shingle", "shingle", "word", "shingle", "word", "word"};
        FOUR_GRAM_TOKENS_WITHOUT_UNIGRAMS_MIN_TRI_GRAM = new Token[]{ShingleFilterTest.createToken("please divide this", 0, 18), ShingleFilterTest.createToken("please divide this sentence", 0, 27), ShingleFilterTest.createToken("divide this sentence", 7, 27), ShingleFilterTest.createToken("divide this sentence into", 7, 32), ShingleFilterTest.createToken("this sentence into", 14, 32), ShingleFilterTest.createToken("this sentence into shingles", 14, 39), ShingleFilterTest.createToken("sentence into shingles", 19, 39)};
        FOUR_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS_MIN_TRI_GRAM = new int[]{1, 0, 1, 0, 1, 0, 1};
        FOUR_GRAM_TYPES_WITHOUT_UNIGRAMS_MIN_TRI_GRAM = new String[]{"shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle"};
        FOUR_GRAM_TOKENS_MIN_FOUR_GRAM = new Token[]{ShingleFilterTest.createToken("please", 0, 6), ShingleFilterTest.createToken("please divide this sentence", 0, 27), ShingleFilterTest.createToken("divide", 7, 13), ShingleFilterTest.createToken("divide this sentence into", 7, 32), ShingleFilterTest.createToken("this", 14, 18), ShingleFilterTest.createToken("this sentence into shingles", 14, 39), ShingleFilterTest.createToken("sentence", 19, 27), ShingleFilterTest.createToken("into", 28, 32), ShingleFilterTest.createToken("shingles", 33, 39)};
        FOUR_GRAM_POSITION_INCREMENTS_MIN_FOUR_GRAM = new int[]{1, 0, 1, 0, 1, 0, 1, 1, 1};
        FOUR_GRAM_TYPES_MIN_FOUR_GRAM = new String[]{"word", "shingle", "word", "shingle", "word", "shingle", "word", "word", "word"};
        FOUR_GRAM_TOKENS_WITHOUT_UNIGRAMS_MIN_FOUR_GRAM = new Token[]{ShingleFilterTest.createToken("please divide this sentence", 0, 27), ShingleFilterTest.createToken("divide this sentence into", 7, 32), ShingleFilterTest.createToken("this sentence into shingles", 14, 39)};
        FOUR_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS_MIN_FOUR_GRAM = new int[]{1, 1, 1};
        FOUR_GRAM_TYPES_WITHOUT_UNIGRAMS_MIN_FOUR_GRAM = new String[]{"shingle", "shingle", "shingle"};
        BI_GRAM_TOKENS_NO_SEPARATOR = new Token[]{ShingleFilterTest.createToken("please", 0, 6), ShingleFilterTest.createToken("pleasedivide", 0, 13), ShingleFilterTest.createToken("divide", 7, 13), ShingleFilterTest.createToken("dividethis", 7, 18), ShingleFilterTest.createToken("this", 14, 18), ShingleFilterTest.createToken("thissentence", 14, 27), ShingleFilterTest.createToken("sentence", 19, 27), ShingleFilterTest.createToken("sentenceinto", 19, 32), ShingleFilterTest.createToken("into", 28, 32), ShingleFilterTest.createToken("intoshingles", 28, 39), ShingleFilterTest.createToken("shingles", 33, 39)};
        BI_GRAM_POSITION_INCREMENTS_NO_SEPARATOR = new int[]{1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1};
        BI_GRAM_TYPES_NO_SEPARATOR = new String[]{"word", "shingle", "word", "shingle", "word", "shingle", "word", "shingle", "word", "shingle", "word"};
        BI_GRAM_TOKENS_WITHOUT_UNIGRAMS_NO_SEPARATOR = new Token[]{ShingleFilterTest.createToken("pleasedivide", 0, 13), ShingleFilterTest.createToken("dividethis", 7, 18), ShingleFilterTest.createToken("thissentence", 14, 27), ShingleFilterTest.createToken("sentenceinto", 19, 32), ShingleFilterTest.createToken("intoshingles", 28, 39)};
        BI_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS_NO_SEPARATOR = new int[]{1, 1, 1, 1, 1};
        BI_GRAM_TYPES_WITHOUT_UNIGRAMS_NO_SEPARATOR = new String[]{"shingle", "shingle", "shingle", "shingle", "shingle"};
        TRI_GRAM_TOKENS_NO_SEPARATOR = new Token[]{ShingleFilterTest.createToken("please", 0, 6), ShingleFilterTest.createToken("pleasedivide", 0, 13), ShingleFilterTest.createToken("pleasedividethis", 0, 18), ShingleFilterTest.createToken("divide", 7, 13), ShingleFilterTest.createToken("dividethis", 7, 18), ShingleFilterTest.createToken("dividethissentence", 7, 27), ShingleFilterTest.createToken("this", 14, 18), ShingleFilterTest.createToken("thissentence", 14, 27), ShingleFilterTest.createToken("thissentenceinto", 14, 32), ShingleFilterTest.createToken("sentence", 19, 27), ShingleFilterTest.createToken("sentenceinto", 19, 32), ShingleFilterTest.createToken("sentenceintoshingles", 19, 39), ShingleFilterTest.createToken("into", 28, 32), ShingleFilterTest.createToken("intoshingles", 28, 39), ShingleFilterTest.createToken("shingles", 33, 39)};
        TRI_GRAM_POSITION_INCREMENTS_NO_SEPARATOR = new int[]{1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1};
        TRI_GRAM_TYPES_NO_SEPARATOR = new String[]{"word", "shingle", "shingle", "word", "shingle", "shingle", "word", "shingle", "shingle", "word", "shingle", "shingle", "word", "shingle", "word"};
        TRI_GRAM_TOKENS_WITHOUT_UNIGRAMS_NO_SEPARATOR = new Token[]{ShingleFilterTest.createToken("pleasedivide", 0, 13), ShingleFilterTest.createToken("pleasedividethis", 0, 18), ShingleFilterTest.createToken("dividethis", 7, 18), ShingleFilterTest.createToken("dividethissentence", 7, 27), ShingleFilterTest.createToken("thissentence", 14, 27), ShingleFilterTest.createToken("thissentenceinto", 14, 32), ShingleFilterTest.createToken("sentenceinto", 19, 32), ShingleFilterTest.createToken("sentenceintoshingles", 19, 39), ShingleFilterTest.createToken("intoshingles", 28, 39)};
        TRI_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS_NO_SEPARATOR = new int[]{1, 0, 1, 0, 1, 0, 1, 0, 1};
        TRI_GRAM_TYPES_WITHOUT_UNIGRAMS_NO_SEPARATOR = new String[]{"shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle"};
        BI_GRAM_TOKENS_ALT_SEPARATOR = new Token[]{ShingleFilterTest.createToken("please", 0, 6), ShingleFilterTest.createToken("please<SEP>divide", 0, 13), ShingleFilterTest.createToken("divide", 7, 13), ShingleFilterTest.createToken("divide<SEP>this", 7, 18), ShingleFilterTest.createToken("this", 14, 18), ShingleFilterTest.createToken("this<SEP>sentence", 14, 27), ShingleFilterTest.createToken("sentence", 19, 27), ShingleFilterTest.createToken("sentence<SEP>into", 19, 32), ShingleFilterTest.createToken("into", 28, 32), ShingleFilterTest.createToken("into<SEP>shingles", 28, 39), ShingleFilterTest.createToken("shingles", 33, 39)};
        BI_GRAM_POSITION_INCREMENTS_ALT_SEPARATOR = new int[]{1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1};
        BI_GRAM_TYPES_ALT_SEPARATOR = new String[]{"word", "shingle", "word", "shingle", "word", "shingle", "word", "shingle", "word", "shingle", "word"};
        BI_GRAM_TOKENS_WITHOUT_UNIGRAMS_ALT_SEPARATOR = new Token[]{ShingleFilterTest.createToken("please<SEP>divide", 0, 13), ShingleFilterTest.createToken("divide<SEP>this", 7, 18), ShingleFilterTest.createToken("this<SEP>sentence", 14, 27), ShingleFilterTest.createToken("sentence<SEP>into", 19, 32), ShingleFilterTest.createToken("into<SEP>shingles", 28, 39)};
        BI_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS_ALT_SEPARATOR = new int[]{1, 1, 1, 1, 1};
        BI_GRAM_TYPES_WITHOUT_UNIGRAMS_ALT_SEPARATOR = new String[]{"shingle", "shingle", "shingle", "shingle", "shingle"};
        TRI_GRAM_TOKENS_ALT_SEPARATOR = new Token[]{ShingleFilterTest.createToken("please", 0, 6), ShingleFilterTest.createToken("please<SEP>divide", 0, 13), ShingleFilterTest.createToken("please<SEP>divide<SEP>this", 0, 18), ShingleFilterTest.createToken("divide", 7, 13), ShingleFilterTest.createToken("divide<SEP>this", 7, 18), ShingleFilterTest.createToken("divide<SEP>this<SEP>sentence", 7, 27), ShingleFilterTest.createToken("this", 14, 18), ShingleFilterTest.createToken("this<SEP>sentence", 14, 27), ShingleFilterTest.createToken("this<SEP>sentence<SEP>into", 14, 32), ShingleFilterTest.createToken("sentence", 19, 27), ShingleFilterTest.createToken("sentence<SEP>into", 19, 32), ShingleFilterTest.createToken("sentence<SEP>into<SEP>shingles", 19, 39), ShingleFilterTest.createToken("into", 28, 32), ShingleFilterTest.createToken("into<SEP>shingles", 28, 39), ShingleFilterTest.createToken("shingles", 33, 39)};
        TRI_GRAM_POSITION_INCREMENTS_ALT_SEPARATOR = new int[]{1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1};
        TRI_GRAM_TYPES_ALT_SEPARATOR = new String[]{"word", "shingle", "shingle", "word", "shingle", "shingle", "word", "shingle", "shingle", "word", "shingle", "shingle", "word", "shingle", "word"};
        TRI_GRAM_TOKENS_WITHOUT_UNIGRAMS_ALT_SEPARATOR = new Token[]{ShingleFilterTest.createToken("please<SEP>divide", 0, 13), ShingleFilterTest.createToken("please<SEP>divide<SEP>this", 0, 18), ShingleFilterTest.createToken("divide<SEP>this", 7, 18), ShingleFilterTest.createToken("divide<SEP>this<SEP>sentence", 7, 27), ShingleFilterTest.createToken("this<SEP>sentence", 14, 27), ShingleFilterTest.createToken("this<SEP>sentence<SEP>into", 14, 32), ShingleFilterTest.createToken("sentence<SEP>into", 19, 32), ShingleFilterTest.createToken("sentence<SEP>into<SEP>shingles", 19, 39), ShingleFilterTest.createToken("into<SEP>shingles", 28, 39)};
        TRI_GRAM_POSITION_INCREMENTS_WITHOUT_UNIGRAMS_ALT_SEPARATOR = new int[]{1, 0, 1, 0, 1, 0, 1, 0, 1};
        TRI_GRAM_TYPES_WITHOUT_UNIGRAMS_ALT_SEPARATOR = new String[]{"shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle"};
        TRI_GRAM_TOKENS_NULL_SEPARATOR = new Token[]{ShingleFilterTest.createToken("please", 0, 6), ShingleFilterTest.createToken("pleasedivide", 0, 13), ShingleFilterTest.createToken("pleasedividethis", 0, 18), ShingleFilterTest.createToken("divide", 7, 13), ShingleFilterTest.createToken("dividethis", 7, 18), ShingleFilterTest.createToken("dividethissentence", 7, 27), ShingleFilterTest.createToken("this", 14, 18), ShingleFilterTest.createToken("thissentence", 14, 27), ShingleFilterTest.createToken("thissentenceinto", 14, 32), ShingleFilterTest.createToken("sentence", 19, 27), ShingleFilterTest.createToken("sentenceinto", 19, 32), ShingleFilterTest.createToken("sentenceintoshingles", 19, 39), ShingleFilterTest.createToken("into", 28, 32), ShingleFilterTest.createToken("intoshingles", 28, 39), ShingleFilterTest.createToken("shingles", 33, 39)};
        TRI_GRAM_POSITION_INCREMENTS_NULL_SEPARATOR = new int[]{1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1};
        TRI_GRAM_TYPES_NULL_SEPARATOR = new String[]{"word", "shingle", "shingle", "word", "shingle", "shingle", "word", "shingle", "shingle", "word", "shingle", "shingle", "word", "shingle", "word"};
        TEST_TOKEN_POS_INCR_EQUAL_TO_N = new Token[]{ShingleFilterTest.createToken("please", 0, 6), ShingleFilterTest.createToken("divide", 7, 13), ShingleFilterTest.createToken("this", 14, 18), ShingleFilterTest.createToken("sentence", 29, 37, 3), ShingleFilterTest.createToken("into", 38, 42), ShingleFilterTest.createToken("shingles", 43, 49)};
        TRI_GRAM_TOKENS_POS_INCR_EQUAL_TO_N = new Token[]{ShingleFilterTest.createToken("please", 0, 6), ShingleFilterTest.createToken("please divide", 0, 13), ShingleFilterTest.createToken("please divide this", 0, 18), ShingleFilterTest.createToken("divide", 7, 13), ShingleFilterTest.createToken("divide this", 7, 18), ShingleFilterTest.createToken("divide this _", 7, 29), ShingleFilterTest.createToken("this", 14, 18), ShingleFilterTest.createToken("this _", 14, 29), ShingleFilterTest.createToken("this _ _", 14, 29), ShingleFilterTest.createToken("_ _ sentence", 29, 37), ShingleFilterTest.createToken("_ sentence", 29, 37), ShingleFilterTest.createToken("_ sentence into", 29, 42), ShingleFilterTest.createToken("sentence", 29, 37), ShingleFilterTest.createToken("sentence into", 29, 42), ShingleFilterTest.createToken("sentence into shingles", 29, 49), ShingleFilterTest.createToken("into", 38, 42), ShingleFilterTest.createToken("into shingles", 38, 49), ShingleFilterTest.createToken("shingles", 43, 49)};
        TRI_GRAM_POSITION_INCREMENTS_POS_INCR_EQUAL_TO_N = new int[]{1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1};
        TRI_GRAM_TYPES_POS_INCR_EQUAL_TO_N = new String[]{"word", "shingle", "shingle", "word", "shingle", "shingle", "word", "shingle", "shingle", "shingle", "shingle", "shingle", "word", "shingle", "shingle", "word", "shingle", "word"};
        TRI_GRAM_TOKENS_POS_INCR_EQUAL_TO_N_WITHOUT_UNIGRAMS = new Token[]{ShingleFilterTest.createToken("please divide", 0, 13), ShingleFilterTest.createToken("please divide this", 0, 18), ShingleFilterTest.createToken("divide this", 7, 18), ShingleFilterTest.createToken("divide this _", 7, 29), ShingleFilterTest.createToken("this _", 14, 29), ShingleFilterTest.createToken("this _ _", 14, 29), ShingleFilterTest.createToken("_ _ sentence", 29, 37), ShingleFilterTest.createToken("_ sentence", 29, 37), ShingleFilterTest.createToken("_ sentence into", 29, 42), ShingleFilterTest.createToken("sentence into", 29, 42), ShingleFilterTest.createToken("sentence into shingles", 29, 49), ShingleFilterTest.createToken("into shingles", 38, 49)};
        TRI_GRAM_POSITION_INCREMENTS_POS_INCR_EQUAL_TO_N_WITHOUT_UNIGRAMS = new int[]{1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 1};
        TRI_GRAM_TYPES_POS_INCR_EQUAL_TO_N_WITHOUT_UNIGRAMS = new String[]{"shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle"};
        TEST_TOKEN_POS_INCR_GREATER_THAN_N = new Token[]{ShingleFilterTest.createToken("please", 0, 6), ShingleFilterTest.createToken("divide", 57, 63, 8), ShingleFilterTest.createToken("this", 64, 68), ShingleFilterTest.createToken("sentence", 69, 77), ShingleFilterTest.createToken("into", 78, 82), ShingleFilterTest.createToken("shingles", 83, 89)};
        TRI_GRAM_TOKENS_POS_INCR_GREATER_THAN_N = new Token[]{ShingleFilterTest.createToken("please", 0, 6), ShingleFilterTest.createToken("please _", 0, 57), ShingleFilterTest.createToken("please _ _", 0, 57), ShingleFilterTest.createToken("_ _ divide", 57, 63), ShingleFilterTest.createToken("_ divide", 57, 63), ShingleFilterTest.createToken("_ divide this", 57, 68), ShingleFilterTest.createToken("divide", 57, 63), ShingleFilterTest.createToken("divide this", 57, 68), ShingleFilterTest.createToken("divide this sentence", 57, 77), ShingleFilterTest.createToken("this", 64, 68), ShingleFilterTest.createToken("this sentence", 64, 77), ShingleFilterTest.createToken("this sentence into", 64, 82), ShingleFilterTest.createToken("sentence", 69, 77), ShingleFilterTest.createToken("sentence into", 69, 82), ShingleFilterTest.createToken("sentence into shingles", 69, 89), ShingleFilterTest.createToken("into", 78, 82), ShingleFilterTest.createToken("into shingles", 78, 89), ShingleFilterTest.createToken("shingles", 83, 89)};
        TRI_GRAM_POSITION_INCREMENTS_POS_INCR_GREATER_THAN_N = new int[]{1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1};
        TRI_GRAM_TYPES_POS_INCR_GREATER_THAN_N = new String[]{"word", "shingle", "shingle", "shingle", "shingle", "shingle", "word", "shingle", "shingle", "word", "shingle", "shingle", "word", "shingle", "shingle", "word", "shingle", "word"};
        TRI_GRAM_TOKENS_POS_INCR_GREATER_THAN_N_WITHOUT_UNIGRAMS = new Token[]{ShingleFilterTest.createToken("please _", 0, 57), ShingleFilterTest.createToken("please _ _", 0, 57), ShingleFilterTest.createToken("_ _ divide", 57, 63), ShingleFilterTest.createToken("_ divide", 57, 63), ShingleFilterTest.createToken("_ divide this", 57, 68), ShingleFilterTest.createToken("divide this", 57, 68), ShingleFilterTest.createToken("divide this sentence", 57, 77), ShingleFilterTest.createToken("this sentence", 64, 77), ShingleFilterTest.createToken("this sentence into", 64, 82), ShingleFilterTest.createToken("sentence into", 69, 82), ShingleFilterTest.createToken("sentence into shingles", 69, 89), ShingleFilterTest.createToken("into shingles", 78, 89)};
        TRI_GRAM_POSITION_INCREMENTS_POS_INCR_GREATER_THAN_N_WITHOUT_UNIGRAMS = new int[]{1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1};
        TRI_GRAM_TYPES_POS_INCR_GREATER_THAN_N_WITHOUT_UNIGRAMS = new String[]{"shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle", "shingle"};
    }
}

