/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.shingle;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestShingleFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testDefaults() throws Exception {
        StringReader reader = new StringReader("this is a test");
        MockTokenizer stream = TestShingleFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Shingle", new String[0]).create((TokenStream)stream);
        TestShingleFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"this", "this is", "is", "is a", "a", "a test", "test"});
    }

    public void testNoUnigrams() throws Exception {
        StringReader reader = new StringReader("this is a test");
        MockTokenizer stream = TestShingleFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Shingle", "outputUnigrams", "false").create((TokenStream)stream);
        TestShingleFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"this is", "is a", "a test"});
    }

    public void testMaxShingleSize() throws Exception {
        StringReader reader = new StringReader("this is a test");
        MockTokenizer stream = TestShingleFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Shingle", "maxShingleSize", "3").create((TokenStream)stream);
        TestShingleFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"this", "this is", "this is a", "is", "is a", "is a test", "a", "a test", "test"});
    }

    public void testMinShingleSize() throws Exception {
        StringReader reader = new StringReader("this is a test");
        MockTokenizer stream = TestShingleFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Shingle", "minShingleSize", "3", "maxShingleSize", "4").create((TokenStream)stream);
        TestShingleFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"this", "this is a", "this is a test", "is", "is a test", "a", "test"});
    }

    public void testMinShingleSizeNoUnigrams() throws Exception {
        StringReader reader = new StringReader("this is a test");
        MockTokenizer stream = TestShingleFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Shingle", "minShingleSize", "3", "maxShingleSize", "4", "outputUnigrams", "false").create((TokenStream)stream);
        TestShingleFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"this is a", "this is a test", "is a test"});
    }

    public void testEqualMinAndMaxShingleSize() throws Exception {
        StringReader reader = new StringReader("this is a test");
        MockTokenizer stream = TestShingleFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Shingle", "minShingleSize", "3", "maxShingleSize", "3").create((TokenStream)stream);
        TestShingleFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"this", "this is a", "is", "is a test", "a", "test"});
    }

    public void testEqualMinAndMaxShingleSizeNoUnigrams() throws Exception {
        StringReader reader = new StringReader("this is a test");
        MockTokenizer stream = TestShingleFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Shingle", "minShingleSize", "3", "maxShingleSize", "3", "outputUnigrams", "false").create((TokenStream)stream);
        TestShingleFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"this is a", "is a test"});
    }

    public void testTokenSeparator() throws Exception {
        StringReader reader = new StringReader("this is a test");
        MockTokenizer stream = TestShingleFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Shingle", "tokenSeparator", "=BLAH=").create((TokenStream)stream);
        TestShingleFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"this", "this=BLAH=is", "is", "is=BLAH=a", "a", "a=BLAH=test", "test"});
    }

    public void testTokenSeparatorNoUnigrams() throws Exception {
        StringReader reader = new StringReader("this is a test");
        MockTokenizer stream = TestShingleFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Shingle", "tokenSeparator", "=BLAH=", "outputUnigrams", "false").create((TokenStream)stream);
        TestShingleFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"this=BLAH=is", "is=BLAH=a", "a=BLAH=test"});
    }

    public void testEmptyTokenSeparator() throws Exception {
        StringReader reader = new StringReader("this is a test");
        MockTokenizer stream = TestShingleFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Shingle", "tokenSeparator", "").create((TokenStream)stream);
        TestShingleFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"this", "thisis", "is", "isa", "a", "atest", "test"});
    }

    public void testMinShingleSizeAndTokenSeparator() throws Exception {
        StringReader reader = new StringReader("this is a test");
        MockTokenizer stream = TestShingleFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Shingle", "minShingleSize", "3", "maxShingleSize", "4", "tokenSeparator", "=BLAH=").create((TokenStream)stream);
        TestShingleFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"this", "this=BLAH=is=BLAH=a", "this=BLAH=is=BLAH=a=BLAH=test", "is", "is=BLAH=a=BLAH=test", "a", "test"});
    }

    public void testMinShingleSizeAndTokenSeparatorNoUnigrams() throws Exception {
        StringReader reader = new StringReader("this is a test");
        MockTokenizer stream = TestShingleFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Shingle", "minShingleSize", "3", "maxShingleSize", "4", "tokenSeparator", "=BLAH=", "outputUnigrams", "false").create((TokenStream)stream);
        TestShingleFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"this=BLAH=is=BLAH=a", "this=BLAH=is=BLAH=a=BLAH=test", "is=BLAH=a=BLAH=test"});
    }

    public void testOutputUnigramsIfNoShingles() throws Exception {
        StringReader reader = new StringReader("test");
        MockTokenizer stream = TestShingleFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Shingle", "outputUnigrams", "false", "outputUnigramsIfNoShingles", "true").create((TokenStream)stream);
        TestShingleFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"test"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestShingleFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("Shingle", "bogusArg", "bogusValue"));
        TestShingleFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

