/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.sinks;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Locale;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.FilteringTokenFilter;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.sinks.TeeSinkTokenFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.English;

public class TestTeeSinkTokenFilter
extends BaseTokenStreamTestCase {
    protected StringBuilder buffer1;
    protected StringBuilder buffer2;
    protected String[] tokens1;
    protected String[] tokens2;

    public void setUp() throws Exception {
        int i;
        super.setUp();
        this.tokens1 = new String[]{"The", "quick", "Burgundy", "Fox", "jumped", "over", "the", "lazy", "Red", "Dogs"};
        this.tokens2 = new String[]{"The", "Lazy", "Dogs", "should", "stay", "on", "the", "porch"};
        this.buffer1 = new StringBuilder();
        for (i = 0; i < this.tokens1.length; ++i) {
            this.buffer1.append(this.tokens1[i]).append(' ');
        }
        this.buffer2 = new StringBuilder();
        for (i = 0; i < this.tokens2.length; ++i) {
            this.buffer2.append(this.tokens2[i]).append(' ');
        }
    }

    public void testEndOffsetPositionWithTeeSinkTokenFilter() throws Exception {
        BaseDirectoryWrapper dir = TestTeeSinkTokenFilter.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(TestTeeSinkTokenFilter.random(), MockTokenizer.WHITESPACE, false);
        IndexWriter w = new IndexWriter((Directory)dir, TestTeeSinkTokenFilter.newIndexWriterConfig((Analyzer)analyzer));
        Document doc = new Document();
        TokenStream tokenStream = analyzer.tokenStream("field", "abcd   ");
        TeeSinkTokenFilter tee = new TeeSinkTokenFilter(tokenStream);
        TokenStream sink = tee.newSinkTokenStream();
        FieldType ft = new FieldType(TextField.TYPE_NOT_STORED);
        ft.setStoreTermVectors(true);
        ft.setStoreTermVectorOffsets(true);
        ft.setStoreTermVectorPositions(true);
        Field f1 = new Field("field", (TokenStream)tee, ft);
        Field f2 = new Field("field", sink, ft);
        doc.add((IndexableField)f1);
        doc.add((IndexableField)f2);
        w.addDocument((Iterable)doc);
        w.close();
        DirectoryReader r = DirectoryReader.open((Directory)dir);
        Terms vector = r.getTermVectors(0).terms("field");
        TestTeeSinkTokenFilter.assertEquals((long)1L, (long)vector.size());
        TermsEnum termsEnum = vector.iterator();
        termsEnum.next();
        TestTeeSinkTokenFilter.assertEquals((long)2L, (long)termsEnum.totalTermFreq());
        PostingsEnum positions = termsEnum.postings(null, 120);
        TestTeeSinkTokenFilter.assertTrue((positions.nextDoc() != Integer.MAX_VALUE ? 1 : 0) != 0);
        TestTeeSinkTokenFilter.assertEquals((long)2L, (long)positions.freq());
        positions.nextPosition();
        TestTeeSinkTokenFilter.assertEquals((long)0L, (long)positions.startOffset());
        TestTeeSinkTokenFilter.assertEquals((long)4L, (long)positions.endOffset());
        positions.nextPosition();
        TestTeeSinkTokenFilter.assertEquals((long)8L, (long)positions.startOffset());
        TestTeeSinkTokenFilter.assertEquals((long)12L, (long)positions.endOffset());
        TestTeeSinkTokenFilter.assertEquals((long)Integer.MAX_VALUE, (long)positions.nextDoc());
        r.close();
        dir.close();
        analyzer.close();
    }

    public void testGeneral() throws IOException {
        TeeSinkTokenFilter source = new TeeSinkTokenFilter((TokenStream)TestTeeSinkTokenFilter.whitespaceMockTokenizer((String)this.buffer1.toString()));
        TokenStream sink = source.newSinkTokenStream();
        source.addAttribute(BaseTokenStreamTestCase.CheckClearAttributesAttribute.class);
        sink.addAttribute(BaseTokenStreamTestCase.CheckClearAttributesAttribute.class);
        TestTeeSinkTokenFilter.assertTokenStreamContents((TokenStream)source, (String[])this.tokens1);
        TestTeeSinkTokenFilter.assertTokenStreamContents((TokenStream)sink, (String[])this.tokens1);
    }

    public void testMultipleSources() throws Exception {
        TeeSinkTokenFilter tee2;
        TeeSinkTokenFilter tee1 = new TeeSinkTokenFilter((TokenStream)TestTeeSinkTokenFilter.whitespaceMockTokenizer((String)this.buffer1.toString()));
        CachingTokenFilter source1 = new CachingTokenFilter((TokenStream)tee1);
        tee1.addAttribute(BaseTokenStreamTestCase.CheckClearAttributesAttribute.class);
        MockTokenizer tokenizer = new MockTokenizer(tee1.getAttributeFactory(), MockTokenizer.WHITESPACE, false);
        tokenizer.setReader((Reader)new StringReader(this.buffer2.toString()));
        TeeSinkTokenFilter source2 = tee2 = new TeeSinkTokenFilter((TokenStream)tokenizer);
        TestTeeSinkTokenFilter.assertTokenStreamContents((TokenStream)source1, (String[])this.tokens1);
        TestTeeSinkTokenFilter.assertTokenStreamContents((TokenStream)source2, (String[])this.tokens2);
        LowerCaseFilter lowerCasing = new LowerCaseFilter((TokenStream)source1);
        String[] lowerCaseTokens = new String[this.tokens1.length];
        for (int i = 0; i < this.tokens1.length; ++i) {
            lowerCaseTokens[i] = this.tokens1[i].toLowerCase(Locale.ROOT);
        }
        TestTeeSinkTokenFilter.assertTokenStreamContents((TokenStream)lowerCasing, (String[])lowerCaseTokens);
    }

    private StandardTokenizer standardTokenizer(StringBuilder builder) {
        StandardTokenizer tokenizer = new StandardTokenizer();
        tokenizer.setReader((Reader)new StringReader(builder.toString()));
        return tokenizer;
    }

    public void performance() throws Exception {
        int[] tokCount = new int[]{100, 500, 1000, 2000, 5000, 10000};
        int[] modCounts = new int[]{1, 2, 5, 10, 20, 50, 100, 200, 500};
        for (int k = 0; k < tokCount.length; ++k) {
            StringBuilder buffer = new StringBuilder();
            System.out.println("-----Tokens: " + tokCount[k] + "-----");
            for (int i = 0; i < tokCount[k]; ++i) {
                buffer.append(English.intToEnglish((int)i).toUpperCase(Locale.ROOT)).append(' ');
            }
            TeeSinkTokenFilter teeStream = new TeeSinkTokenFilter((TokenStream)new StandardFilter((TokenStream)this.standardTokenizer(buffer)));
            ModuloTokenFilter sink = new ModuloTokenFilter(teeStream.newSinkTokenStream(), 100);
            teeStream.consumeAllTokens();
            ModuloTokenFilter stream = new ModuloTokenFilter((TokenStream)new StandardFilter((TokenStream)this.standardTokenizer(buffer)), 100);
            CharTermAttribute tfTok = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
            CharTermAttribute sinkTok = (CharTermAttribute)sink.addAttribute(CharTermAttribute.class);
            int i = 0;
            while (stream.incrementToken()) {
                TestTeeSinkTokenFilter.assertTrue((boolean)sink.incrementToken());
                TestTeeSinkTokenFilter.assertTrue((String)(tfTok + " is not equal to " + sinkTok + " at token: " + i), (tfTok.equals(sinkTok) ? 1 : 0) != 0);
                ++i;
            }
            for (int j = 0; j < modCounts.length; ++j) {
                int tfPos = 0;
                long start = System.currentTimeMillis();
                for (int i2 = 0; i2 < 20; ++i2) {
                    stream = new StandardFilter((TokenStream)this.standardTokenizer(buffer));
                    PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)stream.getAttribute(PositionIncrementAttribute.class);
                    while (stream.incrementToken()) {
                        tfPos += posIncrAtt.getPositionIncrement();
                    }
                    stream = new ModuloTokenFilter((TokenStream)new StandardFilter((TokenStream)this.standardTokenizer(buffer)), modCounts[j]);
                    posIncrAtt = (PositionIncrementAttribute)stream.getAttribute(PositionIncrementAttribute.class);
                    while (stream.incrementToken()) {
                        tfPos += posIncrAtt.getPositionIncrement();
                    }
                }
                long finish = System.currentTimeMillis();
                System.out.println("ModCount: " + modCounts[j] + " Two fields took " + (finish - start) + " ms");
                int sinkPos = 0;
                start = System.currentTimeMillis();
                for (int i3 = 0; i3 < 20; ++i3) {
                    teeStream = new TeeSinkTokenFilter((TokenStream)new StandardFilter((TokenStream)this.standardTokenizer(buffer)));
                    sink = new ModuloTokenFilter(teeStream.newSinkTokenStream(), modCounts[j]);
                    PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)teeStream.getAttribute(PositionIncrementAttribute.class);
                    while (teeStream.incrementToken()) {
                        sinkPos += posIncrAtt.getPositionIncrement();
                    }
                    posIncrAtt = (PositionIncrementAttribute)sink.getAttribute(PositionIncrementAttribute.class);
                    while (sink.incrementToken()) {
                        sinkPos += posIncrAtt.getPositionIncrement();
                    }
                }
                finish = System.currentTimeMillis();
                System.out.println("ModCount: " + modCounts[j] + " Tee fields took " + (finish - start) + " ms");
                TestTeeSinkTokenFilter.assertTrue((String)(sinkPos + " does not equal: " + tfPos), (sinkPos == tfPos ? 1 : 0) != 0);
            }
            System.out.println("- End Tokens: " + tokCount[k] + "-----");
        }
    }

    static class ModuloSinkFilter
    extends FilteringTokenFilter {
        int count = 0;
        int modCount;

        ModuloSinkFilter(TokenStream input, int mc) {
            super(input);
            this.modCount = mc;
        }

        protected boolean accept() throws IOException {
            boolean b = this.count % this.modCount == 0;
            ++this.count;
            return b;
        }
    }

    static class ModuloTokenFilter
    extends TokenFilter {
        int modCount;
        int count = 0;

        ModuloTokenFilter(TokenStream input, int mc) {
            super(input);
            this.modCount = mc;
        }

        public boolean incrementToken() throws IOException {
            boolean hasNext = this.input.incrementToken();
            while (hasNext && this.count % this.modCount != 0) {
                ++this.count;
                hasNext = this.input.incrementToken();
            }
            ++this.count;
            return hasNext;
        }
    }
}

