/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.snowball;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.BytesRef;

public class TestSnowball
extends BaseTokenStreamTestCase {
    public static String[] SNOWBALL_LANGS = new String[]{"Armenian", "Basque", "Catalan", "Danish", "Dutch", "English", "Finnish", "French", "German2", "German", "Hungarian", "Irish", "Italian", "Kp", "Lovins", "Norwegian", "Porter", "Portuguese", "Romanian", "Russian", "Spanish", "Swedish", "Turkish"};

    public void testEnglish() throws Exception {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SnowballFilter((TokenStream)tokenizer, "English"));
            }
        };
        TestSnowball.assertAnalyzesTo((Analyzer)a, (String)"he abhorred accents", (String[])new String[]{"he", "abhor", "accent"});
        a.close();
    }

    public void testFilterTokens() throws Exception {
        SnowballFilter filter = new SnowballFilter((TokenStream)new TestTokenStream(), "English");
        CharTermAttribute termAtt = (CharTermAttribute)filter.getAttribute(CharTermAttribute.class);
        OffsetAttribute offsetAtt = (OffsetAttribute)filter.getAttribute(OffsetAttribute.class);
        TypeAttribute typeAtt = (TypeAttribute)filter.getAttribute(TypeAttribute.class);
        PayloadAttribute payloadAtt = (PayloadAttribute)filter.getAttribute(PayloadAttribute.class);
        PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)filter.getAttribute(PositionIncrementAttribute.class);
        FlagsAttribute flagsAtt = (FlagsAttribute)filter.getAttribute(FlagsAttribute.class);
        filter.incrementToken();
        TestSnowball.assertEquals((Object)"accent", (Object)termAtt.toString());
        TestSnowball.assertEquals((long)2L, (long)offsetAtt.startOffset());
        TestSnowball.assertEquals((long)7L, (long)offsetAtt.endOffset());
        TestSnowball.assertEquals((Object)"wrd", (Object)typeAtt.type());
        TestSnowball.assertEquals((long)3L, (long)posIncAtt.getPositionIncrement());
        TestSnowball.assertEquals((long)77L, (long)flagsAtt.getFlags());
        TestSnowball.assertEquals((Object)new BytesRef(new byte[]{0, 1, 2, 3}), (Object)payloadAtt.getPayload());
    }

    public void testEmptyTerm() throws IOException {
        for (final String lang : SNOWBALL_LANGS) {
            Analyzer a = new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    KeywordTokenizer tokenizer = new KeywordTokenizer();
                    return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SnowballFilter((TokenStream)tokenizer, lang));
                }
            };
            TestSnowball.checkOneTerm((Analyzer)a, (String)"", (String)"");
            a.close();
        }
    }

    public void testRandomStrings() throws IOException {
        for (String lang : SNOWBALL_LANGS) {
            this.checkRandomStrings(lang);
        }
    }

    public void checkRandomStrings(final String snowballLanguage) throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer t = new MockTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)t, (TokenStream)new SnowballFilter((TokenStream)t, snowballLanguage));
            }
        };
        TestSnowball.checkRandomData((Random)TestSnowball.random(), (Analyzer)a, (int)(100 * RANDOM_MULTIPLIER));
        a.close();
    }

    private static final class TestTokenStream
    extends TokenStream {
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
        private final PayloadAttribute payloadAtt = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);
        private final PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        private final FlagsAttribute flagsAtt = (FlagsAttribute)this.addAttribute(FlagsAttribute.class);

        TestTokenStream() {
        }

        public boolean incrementToken() {
            this.clearAttributes();
            this.termAtt.setEmpty().append("accents");
            this.offsetAtt.setOffset(2, 7);
            this.typeAtt.setType("wrd");
            this.posIncAtt.setPositionIncrement(3);
            this.payloadAtt.setPayload(new BytesRef(new byte[]{0, 1, 2, 3}));
            this.flagsAtt.setFlags(77);
            return true;
        }
    }
}

