/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.snowball;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;
import org.apache.lucene.analysis.util.StringMockResourceLoader;
import org.apache.lucene.util.Version;
import org.tartarus.snowball.ext.EnglishStemmer;

public class TestSnowballPorterFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void test() throws Exception {
        String text = "The fledgling banks were counting on a big boom in banking";
        EnglishStemmer stemmer = new EnglishStemmer();
        String[] test = text.split("\\s");
        String[] gold = new String[test.length];
        for (int i = 0; i < test.length; ++i) {
            stemmer.setCurrent(test[i]);
            stemmer.stem();
            gold[i] = stemmer.getCurrent();
        }
        StringReader reader = new StringReader(text);
        MockTokenizer stream = TestSnowballPorterFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("SnowballPorter", "language", "English").create((TokenStream)stream);
        TestSnowballPorterFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])gold);
    }

    public void testProtected() throws Exception {
        StringReader reader = new StringReader("ridding of some stemming");
        MockTokenizer stream = TestSnowballPorterFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("SnowballPorter", Version.LATEST, new StringMockResourceLoader("ridding"), "protected", "protwords.txt", "language", "English").create((TokenStream)stream);
        TestSnowballPorterFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"ridding", "of", "some", "stem"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestSnowballPorterFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("SnowballPorter", "bogusArg", "bogusValue"));
        TestSnowballPorterFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

