/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.snowball;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.VocabularyAssert;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.util.LuceneTestCase;

@LuceneTestCase.Slow
public class TestSnowballVocab
extends LuceneTestCase {
    public void testStemmers() throws IOException {
        this.assertCorrectOutput("Danish", "danish");
        this.assertCorrectOutput("Dutch", "dutch");
        this.assertCorrectOutput("English", "english");
        this.assertCorrectOutput("Finnish", "finnish");
        this.assertCorrectOutput("French", "french");
        this.assertCorrectOutput("German", "german");
        this.assertCorrectOutput("German2", "german2");
        this.assertCorrectOutput("Hungarian", "hungarian");
        this.assertCorrectOutput("Italian", "italian");
        this.assertCorrectOutput("Kp", "kraaij_pohlmann");
        this.assertCorrectOutput("Lovins", "lovins");
        this.assertCorrectOutput("Norwegian", "norwegian");
        this.assertCorrectOutput("Porter", "porter");
        this.assertCorrectOutput("Portuguese", "portuguese");
        this.assertCorrectOutput("Romanian", "romanian");
        this.assertCorrectOutput("Russian", "russian");
        this.assertCorrectOutput("Spanish", "spanish");
        this.assertCorrectOutput("Swedish", "swedish");
        this.assertCorrectOutput("Turkish", "turkish");
    }

    private void assertCorrectOutput(final String snowballLanguage, String dataDirectory) throws IOException {
        if (VERBOSE) {
            System.out.println("checking snowball language: " + snowballLanguage);
        }
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer t = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)t, (TokenStream)new SnowballFilter((TokenStream)t, snowballLanguage));
            }
        };
        VocabularyAssert.assertVocabulary((Analyzer)a, (Path)this.getDataPath("TestSnowballVocabData.zip"), (String)(dataDirectory + "/voc.txt"), (String)(dataDirectory + "/output.txt"));
        a.close();
    }
}

