/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.sr;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestSerbianNormalizationFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testStemming() throws Exception {
        StringReader reader = new StringReader("\u0111ura");
        MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)stream).setReader((Reader)reader);
        stream = this.tokenFilterFactory("SerbianNormalization", new String[0]).create((TokenStream)stream);
        TestSerbianNormalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"djura"});
    }

    public void testRegularStemming() throws Exception {
        StringReader reader = new StringReader("\u0452\u0443\u0440\u0430");
        MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)stream).setReader((Reader)reader);
        stream = this.tokenFilterFactory("SerbianNormalization", "haircut", "regular").create((TokenStream)stream);
        TestSerbianNormalizationFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"\u0111ura"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestSerbianNormalizationFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("SerbianNormalization", "bogusArg", "bogusValue"));
        TestSerbianNormalizationFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

