/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.sr;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.sr.SerbianNormalizationRegularFilter;

public class TestSerbianNormalizationRegularFilter
extends BaseTokenStreamTestCase {
    private Analyzer analyzer;

    public void setUp() throws Exception {
        super.setUp();
        this.analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                SerbianNormalizationRegularFilter stream = new SerbianNormalizationRegularFilter((TokenStream)tokenizer);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
            }
        };
    }

    public void tearDown() throws Exception {
        this.analyzer.close();
        super.tearDown();
    }

    public void testCyrillic() throws IOException {
        TestSerbianNormalizationRegularFilter.checkOneTerm((Analyzer)this.analyzer, (String)"\u0430\u0431\u0432\u0433\u0434\u0452\u0435\u0436\u0437\u0438\u0458\u043a\u043b\u0459\u043c\u043d\u045a\u043e\u043f\u0440\u0441\u0442\u045b\u0443\u0444\u0445\u0446\u0447\u045f\u0448", (String)"abvgd\u0111e\u017ezijklljmnnjoprst\u0107ufhc\u010dd\u017e\u0161");
    }

    public void testLatin() throws IOException {
        TestSerbianNormalizationRegularFilter.checkOneTerm((Analyzer)this.analyzer, (String)"abc\u010d\u0107dd\u017e\u0111efghijklljmnnjoprs\u0161tuvz\u017e", (String)"abc\u010d\u0107dd\u017e\u0111efghijklljmnnjoprs\u0161tuvz\u017e");
    }

    public void testRandomStrings() throws Exception {
        TestSerbianNormalizationRegularFilter.checkRandomData((Random)TestSerbianNormalizationRegularFilter.random(), (Analyzer)this.analyzer, (int)(1000 * RANDOM_MULTIPLIER));
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SerbianNormalizationRegularFilter((TokenStream)tokenizer));
            }
        };
        TestSerbianNormalizationRegularFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

