/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.standard.ClassicAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.BytesRef;

public class TestClassicAnalyzer
extends BaseTokenStreamTestCase {
    private Analyzer a;

    public void setUp() throws Exception {
        super.setUp();
        this.a = new ClassicAnalyzer();
    }

    public void tearDown() throws Exception {
        this.a.close();
        super.tearDown();
    }

    public void testMaxTermLength() throws Exception {
        ClassicAnalyzer sa = new ClassicAnalyzer();
        sa.setMaxTokenLength(5);
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)sa, (String)"ab cd toolong xy z", (String[])new String[]{"ab", "cd", "xy", "z"});
        sa.close();
    }

    public void testMaxTermLength2() throws Exception {
        ClassicAnalyzer sa = new ClassicAnalyzer();
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)sa, (String)"ab cd toolong xy z", (String[])new String[]{"ab", "cd", "toolong", "xy", "z"});
        sa.setMaxTokenLength(5);
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)sa, (String)"ab cd toolong xy z", (String[])new String[]{"ab", "cd", "xy", "z"}, (int[])new int[]{1, 1, 2, 1});
        sa.close();
    }

    public void testMaxTermLength3() throws Exception {
        char[] chars = new char[255];
        for (int i = 0; i < 255; ++i) {
            chars[i] = 97;
        }
        String longTerm = new String(chars, 0, 255);
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)("ab cd " + longTerm + " xy z"), (String[])new String[]{"ab", "cd", longTerm, "xy", "z"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)("ab cd " + longTerm + "a xy z"), (String[])new String[]{"ab", "cd", "xy", "z"});
    }

    public void testAlphanumeric() throws Exception {
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"B2B", (String[])new String[]{"b2b"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"2B", (String[])new String[]{"2b"});
    }

    public void testUnderscores() throws Exception {
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"word_having_underscore", (String[])new String[]{"word", "having", "underscore"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"word_with_underscore_and_stopwords", (String[])new String[]{"word", "underscore", "stopwords"});
    }

    public void testDelimiters() throws Exception {
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"some-dashed-phrase", (String[])new String[]{"some", "dashed", "phrase"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"dogs,chase,cats", (String[])new String[]{"dogs", "chase", "cats"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"ac/dc", (String[])new String[]{"ac", "dc"});
    }

    public void testApostrophes() throws Exception {
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"O'Reilly", (String[])new String[]{"o'reilly"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"you're", (String[])new String[]{"you're"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"she's", (String[])new String[]{"she"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"Jim's", (String[])new String[]{"jim"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"don't", (String[])new String[]{"don't"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"O'Reilly's", (String[])new String[]{"o'reilly"});
    }

    public void testTSADash() throws Exception {
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"s-class", (String[])new String[]{"s", "class"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"t-com", (String[])new String[]{"t", "com"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"a-class", (String[])new String[]{"class"});
    }

    public void testCompanyNames() throws Exception {
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"AT&T", (String[])new String[]{"at&t"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"Excite@Home", (String[])new String[]{"excite@home"});
    }

    public void testLucene1140() throws Exception {
        try {
            ClassicAnalyzer analyzer = new ClassicAnalyzer();
            TestClassicAnalyzer.assertAnalyzesTo((Analyzer)analyzer, (String)"www.nutch.org.", (String[])new String[]{"www.nutch.org"}, (String[])new String[]{"<HOST>"});
            analyzer.close();
        }
        catch (NullPointerException e) {
            TestClassicAnalyzer.fail((String)"Should not throw an NPE and it did");
        }
    }

    public void testDomainNames() throws Exception {
        ClassicAnalyzer a2 = new ClassicAnalyzer();
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)a2, (String)"www.nutch.org", (String[])new String[]{"www.nutch.org"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)a2, (String)"www.nutch.org.", (String[])new String[]{"www.nutch.org"}, (String[])new String[]{"<HOST>"});
        a2.close();
        a2 = new ClassicAnalyzer();
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)a2, (String)"www.nutch.org.", (String[])new String[]{"www.nutch.org"}, (String[])new String[]{"<HOST>"});
        a2.close();
    }

    public void testEMailAddresses() throws Exception {
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"test@example.com", (String[])new String[]{"test@example.com"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"first.lastname@example.com", (String[])new String[]{"first.lastname@example.com"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"first_lastname@example.com", (String[])new String[]{"first_lastname@example.com"});
    }

    public void testNumeric() throws Exception {
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"21.35", (String[])new String[]{"21.35"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"R2D2 C3PO", (String[])new String[]{"r2d2", "c3po"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"216.239.63.104", (String[])new String[]{"216.239.63.104"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"1-2-3", (String[])new String[]{"1-2-3"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"a1-b2-c3", (String[])new String[]{"a1-b2-c3"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"a1-b-c3", (String[])new String[]{"a1-b-c3"});
    }

    public void testTextWithNumbers() throws Exception {
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"David has 5000 bones", (String[])new String[]{"david", "has", "5000", "bones"});
    }

    public void testVariousText() throws Exception {
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"C embedded developers wanted", (String[])new String[]{"c", "embedded", "developers", "wanted"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"foo bar FOO BAR", (String[])new String[]{"foo", "bar", "foo", "bar"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"foo      bar .  FOO <> BAR", (String[])new String[]{"foo", "bar", "foo", "bar"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"\"QUOTED\" word", (String[])new String[]{"quoted", "word"});
    }

    public void testAcronyms() throws Exception {
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"U.S.A.", (String[])new String[]{"usa"});
    }

    public void testCPlusPlusHash() throws Exception {
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"C++", (String[])new String[]{"c"});
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"C#", (String[])new String[]{"c"});
    }

    public void testKorean() throws Exception {
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"\uc548\ub155\ud558\uc138\uc694 \ud55c\uae00\uc785\ub2c8\ub2e4", (String[])new String[]{"\uc548\ub155\ud558\uc138\uc694", "\ud55c\uae00\uc785\ub2c8\ub2e4"});
    }

    public void testComplianceFileName() throws Exception {
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"2004.jpg", (String[])new String[]{"2004.jpg"}, (String[])new String[]{"<HOST>"});
    }

    public void testComplianceNumericIncorrect() throws Exception {
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"62.46", (String[])new String[]{"62.46"}, (String[])new String[]{"<HOST>"});
    }

    public void testComplianceNumericLong() throws Exception {
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"978-0-94045043-1", (String[])new String[]{"978-0-94045043-1"}, (String[])new String[]{"<NUM>"});
    }

    public void testComplianceNumericFile() throws Exception {
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"78academyawards/rules/rule02.html", (String[])new String[]{"78academyawards/rules/rule02.html"}, (String[])new String[]{"<NUM>"});
    }

    public void testComplianceNumericWithUnderscores() throws Exception {
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"2006-03-11t082958z_01_ban130523_rtridst_0_ozabs", (String[])new String[]{"2006-03-11t082958z_01_ban130523_rtridst_0_ozabs"}, (String[])new String[]{"<NUM>"});
    }

    public void testComplianceNumericWithDash() throws Exception {
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"mid-20th", (String[])new String[]{"mid-20th"}, (String[])new String[]{"<NUM>"});
    }

    public void testComplianceManyTokens() throws Exception {
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)"/money.cnn.com/magazines/fortune/fortune_archive/2007/03/19/8402357/index.htm safari-0-sheikh-zayed-grand-mosque.jpg", (String[])new String[]{"money.cnn.com", "magazines", "fortune", "fortune", "archive/2007/03/19/8402357", "index.htm", "safari-0-sheikh", "zayed", "grand", "mosque.jpg"}, (String[])new String[]{"<HOST>", "<ALPHANUM>", "<ALPHANUM>", "<ALPHANUM>", "<NUM>", "<HOST>", "<NUM>", "<ALPHANUM>", "<ALPHANUM>", "<HOST>"});
    }

    public void testJava14BWCompatibility() throws Exception {
        ClassicAnalyzer sa = new ClassicAnalyzer();
        TestClassicAnalyzer.assertAnalyzesTo((Analyzer)sa, (String)"test\u02c6test", (String[])new String[]{"test", "test"});
        sa.close();
    }

    public void testWickedLongTerm() throws IOException {
        RAMDirectory dir = new RAMDirectory();
        ClassicAnalyzer analyzer = new ClassicAnalyzer();
        IndexWriter writer = new IndexWriter((Directory)dir, new IndexWriterConfig((Analyzer)analyzer));
        char[] chars = new char[32766];
        Arrays.fill(chars, 'x');
        Document doc = new Document();
        String bigTerm = new String(chars);
        String contents = "abc xyz x" + bigTerm + " another term";
        doc.add((IndexableField)new TextField("content", contents, Field.Store.NO));
        writer.addDocument((Iterable)doc);
        doc = new Document();
        doc.add((IndexableField)new TextField("content", "abc bbb ccc", Field.Store.NO));
        writer.addDocument((Iterable)doc);
        writer.close();
        DirectoryReader reader = DirectoryReader.open((Directory)dir);
        TestClassicAnalyzer.assertEquals((long)2L, (long)reader.docFreq(new Term("content", "abc")));
        TestClassicAnalyzer.assertEquals((long)1L, (long)reader.docFreq(new Term("content", "bbb")));
        TestClassicAnalyzer.assertEquals((long)1L, (long)reader.docFreq(new Term("content", "term")));
        TestClassicAnalyzer.assertEquals((long)1L, (long)reader.docFreq(new Term("content", "another")));
        PostingsEnum tps = MultiFields.getTermPositionsEnum((IndexReader)reader, (String)"content", (BytesRef)new BytesRef((CharSequence)"another"));
        TestClassicAnalyzer.assertTrue((tps.nextDoc() != Integer.MAX_VALUE ? 1 : 0) != 0);
        TestClassicAnalyzer.assertEquals((long)1L, (long)tps.freq());
        TestClassicAnalyzer.assertEquals((long)3L, (long)tps.nextPosition());
        TestClassicAnalyzer.assertEquals((String)"document with wicked long term should is not in the index!", (long)2L, (long)reader.numDocs());
        reader.close();
        doc = new Document();
        doc.add((IndexableField)new TextField("content", bigTerm, Field.Store.NO));
        ClassicAnalyzer sa = new ClassicAnalyzer();
        sa.setMaxTokenLength(100000);
        writer = new IndexWriter((Directory)dir, new IndexWriterConfig((Analyzer)sa));
        writer.addDocument((Iterable)doc);
        writer.close();
        reader = DirectoryReader.open((Directory)dir);
        TestClassicAnalyzer.assertEquals((long)1L, (long)reader.docFreq(new Term("content", bigTerm)));
        reader.close();
        dir.close();
        analyzer.close();
        sa.close();
    }

    public void testRandomStrings() throws Exception {
        ClassicAnalyzer analyzer = new ClassicAnalyzer();
        TestClassicAnalyzer.checkRandomData((Random)TestClassicAnalyzer.random(), (Analyzer)analyzer, (int)(1000 * RANDOM_MULTIPLIER));
        analyzer.close();
    }

    public void testRandomHugeStrings() throws Exception {
        ClassicAnalyzer analyzer = new ClassicAnalyzer();
        TestClassicAnalyzer.checkRandomData((Random)TestClassicAnalyzer.random(), (Analyzer)analyzer, (int)(100 * RANDOM_MULTIPLIER), (int)8192);
        analyzer.close();
    }
}

