/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestStandardFactories
extends BaseTokenStreamFactoryTestCase {
    public void testStandardTokenizer() throws Exception {
        StringReader reader = new StringReader("Wha\u0301t's this thing do?");
        Tokenizer stream = this.tokenizerFactory("Standard", new String[0]).create(TestStandardFactories.newAttributeFactory());
        stream.setReader((Reader)reader);
        TestStandardFactories.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"Wha\u0301t's", "this", "thing", "do"});
    }

    public void testStandardTokenizerMaxTokenLength() throws Exception {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            builder.append("abcdefg");
        }
        String longWord = builder.toString();
        String content = "one two three " + longWord + " four five six";
        StringReader reader = new StringReader(content);
        Tokenizer stream = this.tokenizerFactory("Standard", "maxTokenLength", "1000").create(TestStandardFactories.newAttributeFactory());
        stream.setReader((Reader)reader);
        TestStandardFactories.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"one", "two", "three", longWord, "four", "five", "six"});
    }

    public void testClassicTokenizer() throws Exception {
        StringReader reader = new StringReader("What's this thing do?");
        Tokenizer stream = this.tokenizerFactory("Classic", new String[0]).create(TestStandardFactories.newAttributeFactory());
        stream.setReader((Reader)reader);
        TestStandardFactories.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"What's", "this", "thing", "do"});
    }

    public void testClassicTokenizerMaxTokenLength() throws Exception {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            builder.append("abcdefg");
        }
        String longWord = builder.toString();
        String content = "one two three " + longWord + " four five six";
        StringReader reader = new StringReader(content);
        Tokenizer stream = this.tokenizerFactory("Classic", "maxTokenLength", "1000").create(TestStandardFactories.newAttributeFactory());
        stream.setReader((Reader)reader);
        TestStandardFactories.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"one", "two", "three", longWord, "four", "five", "six"});
    }

    public void testStandardFilter() throws Exception {
        StringReader reader = new StringReader("What's this thing do?");
        Tokenizer tokenizer = this.tokenizerFactory("Classic", new String[0]).create(TestStandardFactories.newAttributeFactory());
        tokenizer.setReader((Reader)reader);
        TokenStream stream = this.tokenFilterFactory("Classic", new String[0]).create((TokenStream)tokenizer);
        TestStandardFactories.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"What", "this", "thing", "do"});
    }

    public void testKeywordTokenizer() throws Exception {
        StringReader reader = new StringReader("What's this thing do?");
        Tokenizer stream = this.tokenizerFactory("Keyword", new String[0]).create();
        stream.setReader((Reader)reader);
        TestStandardFactories.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"What's this thing do?"});
    }

    public void testWhitespaceTokenizer() throws Exception {
        StringReader reader = new StringReader("What's this thing do?");
        Tokenizer stream = this.tokenizerFactory("Whitespace", new String[0]).create(TestStandardFactories.newAttributeFactory());
        stream.setReader((Reader)reader);
        TestStandardFactories.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"What's", "this", "thing", "do?"});
    }

    public void testLetterTokenizer() throws Exception {
        StringReader reader = new StringReader("What's this thing do?");
        Tokenizer stream = this.tokenizerFactory("Letter", new String[0]).create(TestStandardFactories.newAttributeFactory());
        stream.setReader((Reader)reader);
        TestStandardFactories.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"What", "s", "this", "thing", "do"});
    }

    public void testLowerCaseTokenizer() throws Exception {
        StringReader reader = new StringReader("What's this thing do?");
        Tokenizer stream = this.tokenizerFactory("LowerCase", new String[0]).create(TestStandardFactories.newAttributeFactory());
        stream.setReader((Reader)reader);
        TestStandardFactories.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"what", "s", "this", "thing", "do"});
    }

    public void testASCIIFolding() throws Exception {
        StringReader reader = new StringReader("\u010cesk\u00e1");
        MockTokenizer stream = TestStandardFactories.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("ASCIIFolding", new String[0]).create((TokenStream)stream);
        TestStandardFactories.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"Ceska"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestStandardFactories.expectThrows(IllegalArgumentException.class, () -> this.tokenizerFactory("Standard", "bogusArg", "bogusValue"));
        TestStandardFactories.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
        expected = (IllegalArgumentException)TestStandardFactories.expectThrows(IllegalArgumentException.class, () -> this.tokenizerFactory("Classic", "bogusArg", "bogusValue"));
        TestStandardFactories.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
        expected = (IllegalArgumentException)TestStandardFactories.expectThrows(IllegalArgumentException.class, () -> this.tokenizerFactory("Whitespace", "bogusArg", "bogusValue"));
        TestStandardFactories.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
        expected = (IllegalArgumentException)TestStandardFactories.expectThrows(IllegalArgumentException.class, () -> this.tokenizerFactory("Letter", "bogusArg", "bogusValue"));
        TestStandardFactories.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
        expected = (IllegalArgumentException)TestStandardFactories.expectThrows(IllegalArgumentException.class, () -> this.tokenizerFactory("LowerCase", "bogusArg", "bogusValue"));
        TestStandardFactories.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
        expected = (IllegalArgumentException)TestStandardFactories.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("ASCIIFolding", "bogusArg", "bogusValue"));
        TestStandardFactories.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
        expected = (IllegalArgumentException)TestStandardFactories.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("Standard", "bogusArg", "bogusValue"));
        TestStandardFactories.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
        expected = (IllegalArgumentException)TestStandardFactories.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("Classic", "bogusArg", "bogusValue"));
        TestStandardFactories.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

