/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.standard.UAX29URLEmailAnalyzer;

public class TestUAX29URLEmailAnalyzer
extends BaseTokenStreamTestCase {
    private Analyzer a;

    public void setUp() throws Exception {
        super.setUp();
        this.a = new UAX29URLEmailAnalyzer();
    }

    public void tearDown() throws Exception {
        this.a.close();
        super.tearDown();
    }

    public void testHugeDoc() throws IOException {
        StringBuilder sb = new StringBuilder();
        char[] whitespace = new char[4094];
        Arrays.fill(whitespace, ' ');
        sb.append(whitespace);
        sb.append("testing 1234");
        String input = sb.toString();
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)input, (String[])new String[]{"testing", "1234"});
    }

    public void testArmenian() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"\u054e\u056b\u0584\u056b\u057a\u0565\u0564\u056b\u0561\u0575\u056b 13 \u0574\u056b\u056c\u056b\u0578\u0576 \u0570\u0578\u0564\u057e\u0561\u056e\u0576\u0565\u0580\u0568 (4,600` \u0570\u0561\u0575\u0565\u0580\u0565\u0576 \u057e\u056b\u0584\u056b\u057a\u0565\u0564\u056b\u0561\u0575\u0578\u0582\u0574) \u0563\u0580\u057e\u0565\u056c \u0565\u0576 \u056f\u0561\u0574\u0561\u057e\u0578\u0580\u0576\u0565\u0580\u056b \u056f\u0578\u0572\u0574\u056b\u0581 \u0578\u0582 \u0570\u0561\u0574\u0561\u0580\u0575\u0561 \u0562\u0578\u056c\u0578\u0580 \u0570\u0578\u0564\u057e\u0561\u056e\u0576\u0565\u0580\u0568 \u056f\u0561\u0580\u0578\u0572 \u0567 \u056d\u0574\u0562\u0561\u0563\u0580\u0565\u056c \u0581\u0561\u0576\u056f\u0561\u0581 \u0574\u0561\u0580\u0564 \u0578\u057e \u056f\u0561\u0580\u0578\u0572 \u0567 \u0562\u0561\u0581\u0565\u056c \u054e\u056b\u0584\u056b\u057a\u0565\u0564\u056b\u0561\u0575\u056b \u056f\u0561\u0575\u0584\u0568\u0589", (String[])new String[]{"\u057e\u056b\u0584\u056b\u057a\u0565\u0564\u056b\u0561\u0575\u056b", "13", "\u0574\u056b\u056c\u056b\u0578\u0576", "\u0570\u0578\u0564\u057e\u0561\u056e\u0576\u0565\u0580\u0568", "4,600", "\u0570\u0561\u0575\u0565\u0580\u0565\u0576", "\u057e\u056b\u0584\u056b\u057a\u0565\u0564\u056b\u0561\u0575\u0578\u0582\u0574", "\u0563\u0580\u057e\u0565\u056c", "\u0565\u0576", "\u056f\u0561\u0574\u0561\u057e\u0578\u0580\u0576\u0565\u0580\u056b", "\u056f\u0578\u0572\u0574\u056b\u0581", "\u0578\u0582", "\u0570\u0561\u0574\u0561\u0580\u0575\u0561", "\u0562\u0578\u056c\u0578\u0580", "\u0570\u0578\u0564\u057e\u0561\u056e\u0576\u0565\u0580\u0568", "\u056f\u0561\u0580\u0578\u0572", "\u0567", "\u056d\u0574\u0562\u0561\u0563\u0580\u0565\u056c", "\u0581\u0561\u0576\u056f\u0561\u0581", "\u0574\u0561\u0580\u0564", "\u0578\u057e", "\u056f\u0561\u0580\u0578\u0572", "\u0567", "\u0562\u0561\u0581\u0565\u056c", "\u057e\u056b\u0584\u056b\u057a\u0565\u0564\u056b\u0561\u0575\u056b", "\u056f\u0561\u0575\u0584\u0568"});
    }

    public void testAmharic() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"\u12ca\u12aa\u1354\u12f5\u12eb \u12e8\u1263\u1208 \u1265\u12d9 \u124b\u1295\u124b \u12e8\u1270\u121f\u120b \u1275\u12ad\u12ad\u1208\u129b\u1293 \u1290\u133b \u1218\u12dd\u1308\u1260 \u12d5\u12cd\u1240\u1275 (\u12a2\u1295\u1233\u12ed\u12ad\u120e\u1352\u12f2\u12eb) \u1290\u12cd\u1362 \u121b\u1295\u129b\u12cd\u121d", (String[])new String[]{"\u12ca\u12aa\u1354\u12f5\u12eb", "\u12e8\u1263\u1208", "\u1265\u12d9", "\u124b\u1295\u124b", "\u12e8\u1270\u121f\u120b", "\u1275\u12ad\u12ad\u1208\u129b\u1293", "\u1290\u133b", "\u1218\u12dd\u1308\u1260", "\u12d5\u12cd\u1240\u1275", "\u12a2\u1295\u1233\u12ed\u12ad\u120e\u1352\u12f2\u12eb", "\u1290\u12cd", "\u121b\u1295\u129b\u12cd\u121d"});
    }

    public void testArabic() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"\u0627\u0644\u0641\u064a\u0644\u0645 \u0627\u0644\u0648\u062b\u0627\u0626\u0642\u064a \u0627\u0644\u0623\u0648\u0644 \u0639\u0646 \u0648\u064a\u0643\u064a\u0628\u064a\u062f\u064a\u0627 \u064a\u0633\u0645\u0649 \"\u0627\u0644\u062d\u0642\u064a\u0642\u0629 \u0628\u0627\u0644\u0623\u0631\u0642\u0627\u0645: \u0642\u0635\u0629 \u0648\u064a\u0643\u064a\u0628\u064a\u062f\u064a\u0627\" (\u0628\u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629: Truth in Numbers: The Wikipedia Story)\u060c \u0633\u064a\u062a\u0645 \u0625\u0637\u0644\u0627\u0642\u0647 \u0641\u064a 2008.", (String[])new String[]{"\u0627\u0644\u0641\u064a\u0644\u0645", "\u0627\u0644\u0648\u062b\u0627\u0626\u0642\u064a", "\u0627\u0644\u0623\u0648\u0644", "\u0639\u0646", "\u0648\u064a\u0643\u064a\u0628\u064a\u062f\u064a\u0627", "\u064a\u0633\u0645\u0649", "\u0627\u0644\u062d\u0642\u064a\u0642\u0629", "\u0628\u0627\u0644\u0623\u0631\u0642\u0627\u0645", "\u0642\u0635\u0629", "\u0648\u064a\u0643\u064a\u0628\u064a\u062f\u064a\u0627", "\u0628\u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629", "truth", "numbers", "wikipedia", "story", "\u0633\u064a\u062a\u0645", "\u0625\u0637\u0644\u0627\u0642\u0647", "\u0641\u064a", "2008"});
    }

    public void testAramaic() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"\u0718\u071d\u0729\u071d\u0726\u0715\u071d\u0710 (\u0710\u0722\u0713\u0720\u071d\u0710: Wikipedia) \u0717\u0718 \u0710\u071d\u0722\u0723\u0729\u0720\u0718\u0726\u0715\u071d\u0710 \u071a\u0710\u072a\u072c\u0710 \u0715\u0710\u0722\u071b\u072a\u0722\u071b \u0712\u0720\u072b\u0722\u0308\u0710 \u0723\u0713\u071d\u0710\u0308\u0710\u0702 \u072b\u0721\u0717 \u0710\u072c\u0710 \u0721\u0722 \u0721\u0308\u0720\u072c\u0710 \u0715\"\u0718\u071d\u0729\u071d\" \u0718\"\u0710\u071d\u0722\u0723\u0729\u0720\u0718\u0726\u0715\u071d\u0710\"\u0700", (String[])new String[]{"\u0718\u071d\u0729\u071d\u0726\u0715\u071d\u0710", "\u0710\u0722\u0713\u0720\u071d\u0710", "wikipedia", "\u0717\u0718", "\u0710\u071d\u0722\u0723\u0729\u0720\u0718\u0726\u0715\u071d\u0710", "\u071a\u0710\u072a\u072c\u0710", "\u0715\u0710\u0722\u071b\u072a\u0722\u071b", "\u0712\u0720\u072b\u0722\u0308\u0710", "\u0723\u0713\u071d\u0710\u0308\u0710", "\u072b\u0721\u0717", "\u0710\u072c\u0710", "\u0721\u0722", "\u0721\u0308\u0720\u072c\u0710", "\u0715", "\u0718\u071d\u0729\u071d", "\u0718", "\u0710\u071d\u0722\u0723\u0729\u0720\u0718\u0726\u0715\u071d\u0710"});
    }

    public void testBengali() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"\u098f\u0987 \u09ac\u09bf\u09b6\u09cd\u09ac\u0995\u09cb\u09b7 \u09aa\u09b0\u09bf\u099a\u09be\u09b2\u09a8\u09be \u0995\u09b0\u09c7 \u0989\u0987\u0995\u09bf\u09ae\u09bf\u09a1\u09bf\u09af\u09bc\u09be \u09ab\u09be\u0989\u09a8\u09cd\u09a1\u09c7\u09b6\u09a8 (\u098f\u0995\u099f\u09bf \u0985\u09b2\u09be\u09ad\u099c\u09a8\u0995 \u09b8\u0982\u09b8\u09cd\u09a5\u09be)\u0964 \u0989\u0987\u0995\u09bf\u09aa\u09bf\u09a1\u09bf\u09af\u09bc\u09be\u09b0 \u09b6\u09c1\u09b0\u09c1 \u09e7\u09eb \u099c\u09be\u09a8\u09c1\u09af\u09bc\u09be\u09b0\u09bf, \u09e8\u09e6\u09e6\u09e7 \u09b8\u09be\u09b2\u09c7\u0964 \u098f\u0996\u09a8 \u09aa\u09b0\u09cd\u09af\u09a8\u09cd\u09a4 \u09e8\u09e6\u09e6\u099f\u09bf\u09b0\u0993 \u09ac\u09c7\u09b6\u09c0 \u09ad\u09be\u09b7\u09be\u09af\u09bc \u0989\u0987\u0995\u09bf\u09aa\u09bf\u09a1\u09bf\u09af\u09bc\u09be \u09b0\u09af\u09bc\u09c7\u099b\u09c7\u0964", (String[])new String[]{"\u098f\u0987", "\u09ac\u09bf\u09b6\u09cd\u09ac\u0995\u09cb\u09b7", "\u09aa\u09b0\u09bf\u099a\u09be\u09b2\u09a8\u09be", "\u0995\u09b0\u09c7", "\u0989\u0987\u0995\u09bf\u09ae\u09bf\u09a1\u09bf\u09af\u09bc\u09be", "\u09ab\u09be\u0989\u09a8\u09cd\u09a1\u09c7\u09b6\u09a8", "\u098f\u0995\u099f\u09bf", "\u0985\u09b2\u09be\u09ad\u099c\u09a8\u0995", "\u09b8\u0982\u09b8\u09cd\u09a5\u09be", "\u0989\u0987\u0995\u09bf\u09aa\u09bf\u09a1\u09bf\u09af\u09bc\u09be\u09b0", "\u09b6\u09c1\u09b0\u09c1", "\u09e7\u09eb", "\u099c\u09be\u09a8\u09c1\u09af\u09bc\u09be\u09b0\u09bf", "\u09e8\u09e6\u09e6\u09e7", "\u09b8\u09be\u09b2\u09c7", "\u098f\u0996\u09a8", "\u09aa\u09b0\u09cd\u09af\u09a8\u09cd\u09a4", "\u09e8\u09e6\u09e6\u099f\u09bf\u09b0\u0993", "\u09ac\u09c7\u09b6\u09c0", "\u09ad\u09be\u09b7\u09be\u09af\u09bc", "\u0989\u0987\u0995\u09bf\u09aa\u09bf\u09a1\u09bf\u09af\u09bc\u09be", "\u09b0\u09af\u09bc\u09c7\u099b\u09c7"});
    }

    public void testFarsi() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"\u0648\u06cc\u06a9\u06cc \u067e\u062f\u06cc\u0627\u06cc \u0627\u0646\u06af\u0644\u06cc\u0633\u06cc \u062f\u0631 \u062a\u0627\u0631\u06cc\u062e \u06f2\u06f5 \u062f\u06cc \u06f1\u06f3\u06f7\u06f9 \u0628\u0647 \u0635\u0648\u0631\u062a \u0645\u06a9\u0645\u0644\u06cc \u0628\u0631\u0627\u06cc \u062f\u0627\u0646\u0634\u0646\u0627\u0645\u0647\u0654 \u062a\u062e\u0635\u0635\u06cc \u0646\u0648\u067e\u062f\u06cc\u0627 \u0646\u0648\u0634\u062a\u0647 \u0634\u062f.", (String[])new String[]{"\u0648\u06cc\u06a9\u06cc", "\u067e\u062f\u06cc\u0627\u06cc", "\u0627\u0646\u06af\u0644\u06cc\u0633\u06cc", "\u062f\u0631", "\u062a\u0627\u0631\u06cc\u062e", "\u06f2\u06f5", "\u062f\u06cc", "\u06f1\u06f3\u06f7\u06f9", "\u0628\u0647", "\u0635\u0648\u0631\u062a", "\u0645\u06a9\u0645\u0644\u06cc", "\u0628\u0631\u0627\u06cc", "\u062f\u0627\u0646\u0634\u0646\u0627\u0645\u0647\u0654", "\u062a\u062e\u0635\u0635\u06cc", "\u0646\u0648\u067e\u062f\u06cc\u0627", "\u0646\u0648\u0634\u062a\u0647", "\u0634\u062f"});
    }

    public void testGreek() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"\u0393\u03c1\u03ac\u03c6\u03b5\u03c4\u03b1\u03b9 \u03c3\u03b5 \u03c3\u03c5\u03bd\u03b5\u03c1\u03b3\u03b1\u03c3\u03af\u03b1 \u03b1\u03c0\u03cc \u03b5\u03b8\u03b5\u03bb\u03bf\u03bd\u03c4\u03ad\u03c2 \u03bc\u03b5 \u03c4\u03bf \u03bb\u03bf\u03b3\u03b9\u03c3\u03bc\u03b9\u03ba\u03cc wiki, \u03ba\u03ac\u03c4\u03b9 \u03c0\u03bf\u03c5 \u03c3\u03b7\u03bc\u03b1\u03af\u03bd\u03b5\u03b9 \u03cc\u03c4\u03b9 \u03ac\u03c1\u03b8\u03c1\u03b1 \u03bc\u03c0\u03bf\u03c1\u03b5\u03af \u03bd\u03b1 \u03c0\u03c1\u03bf\u03c3\u03c4\u03b5\u03b8\u03bf\u03cd\u03bd \u03ae \u03bd\u03b1 \u03b1\u03bb\u03bb\u03ac\u03be\u03bf\u03c5\u03bd \u03b1\u03c0\u03cc \u03c4\u03bf\u03bd \u03ba\u03b1\u03b8\u03ad\u03bd\u03b1.", (String[])new String[]{"\u03b3\u03c1\u03ac\u03c6\u03b5\u03c4\u03b1\u03b9", "\u03c3\u03b5", "\u03c3\u03c5\u03bd\u03b5\u03c1\u03b3\u03b1\u03c3\u03af\u03b1", "\u03b1\u03c0\u03cc", "\u03b5\u03b8\u03b5\u03bb\u03bf\u03bd\u03c4\u03ad\u03c2", "\u03bc\u03b5", "\u03c4\u03bf", "\u03bb\u03bf\u03b3\u03b9\u03c3\u03bc\u03b9\u03ba\u03cc", "wiki", "\u03ba\u03ac\u03c4\u03b9", "\u03c0\u03bf\u03c5", "\u03c3\u03b7\u03bc\u03b1\u03af\u03bd\u03b5\u03b9", "\u03cc\u03c4\u03b9", "\u03ac\u03c1\u03b8\u03c1\u03b1", "\u03bc\u03c0\u03bf\u03c1\u03b5\u03af", "\u03bd\u03b1", "\u03c0\u03c1\u03bf\u03c3\u03c4\u03b5\u03b8\u03bf\u03cd\u03bd", "\u03ae", "\u03bd\u03b1", "\u03b1\u03bb\u03bb\u03ac\u03be\u03bf\u03c5\u03bd", "\u03b1\u03c0\u03cc", "\u03c4\u03bf\u03bd", "\u03ba\u03b1\u03b8\u03ad\u03bd\u03b1"});
    }

    public void testThai() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"\u0e01\u0e32\u0e23\u0e17\u0e35\u0e48\u0e44\u0e14\u0e49\u0e15\u0e49\u0e2d\u0e07\u0e41\u0e2a\u0e14\u0e07\u0e27\u0e48\u0e32\u0e07\u0e32\u0e19\u0e14\u0e35. \u0e41\u0e25\u0e49\u0e27\u0e40\u0e18\u0e2d\u0e08\u0e30\u0e44\u0e1b\u0e44\u0e2b\u0e19? \u0e51\u0e52\u0e53\u0e54", (String[])new String[]{"\u0e01\u0e32\u0e23\u0e17\u0e35\u0e48\u0e44\u0e14\u0e49\u0e15\u0e49\u0e2d\u0e07\u0e41\u0e2a\u0e14\u0e07\u0e27\u0e48\u0e32\u0e07\u0e32\u0e19\u0e14\u0e35", "\u0e41\u0e25\u0e49\u0e27\u0e40\u0e18\u0e2d\u0e08\u0e30\u0e44\u0e1b\u0e44\u0e2b\u0e19", "\u0e51\u0e52\u0e53\u0e54"});
    }

    public void testLao() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"\u0eaa\u0eb2\u0e97\u0eb2\u0ea5\u0eb0\u0e99\u0eb0\u0ea5\u0eb1\u0e94 \u0e9b\u0eb0\u0e8a\u0eb2\u0e97\u0eb4\u0e9b\u0eb0\u0ec4\u0e95 \u0e9b\u0eb0\u0e8a\u0eb2\u0e8a\u0ebb\u0e99\u0ea5\u0eb2\u0ea7", (String[])new String[]{"\u0eaa\u0eb2\u0e97\u0eb2\u0ea5\u0eb0\u0e99\u0eb0\u0ea5\u0eb1\u0e94", "\u0e9b\u0eb0\u0e8a\u0eb2\u0e97\u0eb4\u0e9b\u0eb0\u0ec4\u0e95", "\u0e9b\u0eb0\u0e8a\u0eb2\u0e8a\u0ebb\u0e99\u0ea5\u0eb2\u0ea7"});
    }

    public void testTibetan() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"\u0f66\u0fa3\u0f7c\u0f53\u0f0b\u0f58\u0f5b\u0f7c\u0f51\u0f0b\u0f51\u0f44\u0f0b\u0f63\u0f66\u0f0b\u0f60\u0f51\u0f72\u0f66\u0f0b\u0f56\u0f7c\u0f51\u0f0b\u0f61\u0f72\u0f42\u0f0b\u0f58\u0f72\u0f0b\u0f49\u0f58\u0f66\u0f0b\u0f42\u0f7c\u0f44\u0f0b\u0f60\u0f55\u0f7a\u0f63\u0f0b\u0f51\u0f74\u0f0b\u0f42\u0f4f\u0f7c\u0f44\u0f0b\u0f56\u0f62\u0f0b\u0f67\u0f0b\u0f45\u0f44\u0f0b\u0f51\u0f42\u0f7a\u0f0b\u0f58\u0f5a\u0f53\u0f0b\u0f58\u0f46\u0f72\u0f66\u0f0b\u0f66\u0f7c\u0f0d \u0f0d", (String[])new String[]{"\u0f66\u0fa3\u0f7c\u0f53", "\u0f58\u0f5b\u0f7c\u0f51", "\u0f51\u0f44", "\u0f63\u0f66", "\u0f60\u0f51\u0f72\u0f66", "\u0f56\u0f7c\u0f51", "\u0f61\u0f72\u0f42", "\u0f58\u0f72", "\u0f49\u0f58\u0f66", "\u0f42\u0f7c\u0f44", "\u0f60\u0f55\u0f7a\u0f63", "\u0f51\u0f74", "\u0f42\u0f4f\u0f7c\u0f44", "\u0f56\u0f62", "\u0f67", "\u0f45\u0f44", "\u0f51\u0f42\u0f7a", "\u0f58\u0f5a\u0f53", "\u0f58\u0f46\u0f72\u0f66", "\u0f66\u0f7c"});
    }

    public void testChinese() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"\u6211\u662f\u4e2d\u56fd\u4eba\u3002 \uff11\uff12\uff13\uff14 \uff34\uff45\uff53\uff54\uff53 ", (String[])new String[]{"\u6211", "\u662f", "\u4e2d", "\u56fd", "\u4eba", "\uff11\uff12\uff13\uff14", "\uff54\uff45\uff53\uff54\uff53"});
    }

    public void testEmpty() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"", (String[])new String[0]);
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)".", (String[])new String[0]);
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)" ", (String[])new String[0]);
    }

    public void testLUCENE1545() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"mo\u0364chte", (String[])new String[]{"mo\u0364chte"});
    }

    public void testAlphanumericSA() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"B2B", (String[])new String[]{"b2b"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"2B", (String[])new String[]{"2b"});
    }

    public void testDelimitersSA() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"some-dashed-phrase", (String[])new String[]{"some", "dashed", "phrase"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"dogs,chase,cats", (String[])new String[]{"dogs", "chase", "cats"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"ac/dc", (String[])new String[]{"ac", "dc"});
    }

    public void testApostrophesSA() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"O'Reilly", (String[])new String[]{"o'reilly"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"you're", (String[])new String[]{"you're"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"she's", (String[])new String[]{"she's"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"Jim's", (String[])new String[]{"jim's"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"don't", (String[])new String[]{"don't"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"O'Reilly's", (String[])new String[]{"o'reilly's"});
    }

    public void testNumericSA() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"21.35", (String[])new String[]{"21.35"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"R2D2 C3PO", (String[])new String[]{"r2d2", "c3po"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"216.239.63.104", (String[])new String[]{"216.239.63.104"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"216.239.63.104", (String[])new String[]{"216.239.63.104"});
    }

    public void testTextWithNumbersSA() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"David has 5000 bones", (String[])new String[]{"david", "has", "5000", "bones"});
    }

    public void testVariousTextSA() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"C embedded developers wanted", (String[])new String[]{"c", "embedded", "developers", "wanted"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"foo bar FOO BAR", (String[])new String[]{"foo", "bar", "foo", "bar"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"foo      bar .  FOO <> BAR", (String[])new String[]{"foo", "bar", "foo", "bar"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"\"QUOTED\" word", (String[])new String[]{"quoted", "word"});
    }

    public void testKoreanSA() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"\uc548\ub155\ud558\uc138\uc694 \ud55c\uae00\uc785\ub2c8\ub2e4", (String[])new String[]{"\uc548\ub155\ud558\uc138\uc694", "\ud55c\uae00\uc785\ub2c8\ub2e4"});
    }

    public void testOffsets() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"David has 5000 bones", (String[])new String[]{"david", "has", "5000", "bones"}, (int[])new int[]{0, 6, 10, 15}, (int[])new int[]{5, 9, 14, 20});
    }

    public void testTypes() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"david has 5000 bones", (String[])new String[]{"david", "has", "5000", "bones"}, (String[])new String[]{"<ALPHANUM>", "<ALPHANUM>", "<NUM>", "<ALPHANUM>"});
    }

    public void testSupplementary() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"\ud866\udf05\u8271\u935f\u41f9\u612f\u701b", (String[])new String[]{"\ud866\udf05", "\u8271", "\u935f", "\u41f9", "\u612f", "\u701b"}, (String[])new String[]{"<IDEOGRAPHIC>", "<IDEOGRAPHIC>", "<IDEOGRAPHIC>", "<IDEOGRAPHIC>", "<IDEOGRAPHIC>", "<IDEOGRAPHIC>"});
    }

    public void testKorean() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"\ud6c8\ubbfc\uc815\uc74c", (String[])new String[]{"\ud6c8\ubbfc\uc815\uc74c"}, (String[])new String[]{"<HANGUL>"});
    }

    public void testJapanese() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"\u4eee\u540d\u9063\u3044 \u30ab\u30bf\u30ab\u30ca", (String[])new String[]{"\u4eee", "\u540d", "\u9063", "\u3044", "\u30ab\u30bf\u30ab\u30ca"}, (String[])new String[]{"<IDEOGRAPHIC>", "<IDEOGRAPHIC>", "<IDEOGRAPHIC>", "<HIRAGANA>", "<KATAKANA>"});
    }

    public void testCombiningMarks() throws Exception {
        TestUAX29URLEmailAnalyzer.checkOneTerm((Analyzer)this.a, (String)"\u3055\u3099", (String)"\u3055\u3099");
        TestUAX29URLEmailAnalyzer.checkOneTerm((Analyzer)this.a, (String)"\u30b5\u3099", (String)"\u30b5\u3099");
        TestUAX29URLEmailAnalyzer.checkOneTerm((Analyzer)this.a, (String)"\u58f9\u3099", (String)"\u58f9\u3099");
        TestUAX29URLEmailAnalyzer.checkOneTerm((Analyzer)this.a, (String)"\uc544\u3099", (String)"\uc544\u3099");
    }

    public void testBasicEmails() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"one test@example.com two three [A@example.CO.UK] \"ArakaBanassaMassanaBakarA\" <info@Info.info>", (String[])new String[]{"one", "test@example.com", "two", "three", "a@example.co.uk", "arakabanassamassanabakara", "info@info.info"}, (String[])new String[]{"<ALPHANUM>", "<EMAIL>", "<ALPHANUM>", "<ALPHANUM>", "<EMAIL>", "<ALPHANUM>", "<EMAIL>"});
    }

    public void testMailtoSchemeEmails() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"MAILTO:Test@Example.ORG", (String[])new String[]{"mailto", "test@example.org"}, (String[])new String[]{"<ALPHANUM>", "<EMAIL>"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"mailto:personA@example.com,personB@example.com?cc=personC@example.com&subject=Subjectivity&body=Corpusivity%20or%20something%20like%20that", (String[])new String[]{"mailto", "persona@example.com", ",personb@example.com", "?cc=personc@example.com", "subject", "subjectivity", "body", "corpusivity", "20or", "20something", "20like", "20that"}, (String[])new String[]{"<ALPHANUM>", "<EMAIL>", "<EMAIL>", "<EMAIL>", "<ALPHANUM>", "<ALPHANUM>", "<ALPHANUM>", "<ALPHANUM>", "<ALPHANUM>", "<ALPHANUM>", "<ALPHANUM>", "<ALPHANUM>"});
    }

    public void testBasicURLs() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"a <HTTPs://example.net/omg/isnt/that/NICE?no=its&n%30t#mntl-E>b-D ftp://www.example.com/ABC.txt file:///C:/path/to/a/FILE.txt C", (String[])new String[]{"https://example.net/omg/isnt/that/nice?no=its&n%30t#mntl-e", "b", "d", "ftp://www.example.com/abc.txt", "file:///c:/path/to/a/file.txt", "c"}, (String[])new String[]{"<URL>", "<ALPHANUM>", "<ALPHANUM>", "<URL>", "<URL>", "<ALPHANUM>"});
    }

    public void testNoSchemeURLs() throws Exception {
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"<index.ph>", (String[])new String[]{"index.ph"}, (String[])new String[]{"<URL>"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"index.ph", (String[])new String[]{"index.ph"}, (String[])new String[]{"<URL>"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"index.php", (String[])new String[]{"index.php"}, (String[])new String[]{"<ALPHANUM>"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"index.ph\u03b1", (String[])new String[]{"index.ph\u03b1"}, (String[])new String[]{"<ALPHANUM>"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"index-h.php", (String[])new String[]{"index", "h.php"}, (String[])new String[]{"<ALPHANUM>", "<ALPHANUM>"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"index2.php", (String[])new String[]{"index2", "php"}, (String[])new String[]{"<ALPHANUM>", "<ALPHANUM>"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"index2.ph\uff19,", (String[])new String[]{"index2", "ph\uff19"}, (String[])new String[]{"<ALPHANUM>", "<ALPHANUM>"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"example.com,example.ph,index.php,index2.php,example2.ph", (String[])new String[]{"example.com", "example.ph", "index.php", "index2", "php", "example2.ph"}, (String[])new String[]{"<URL>", "<URL>", "<ALPHANUM>", "<ALPHANUM>", "<ALPHANUM>", "<URL>"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"example.com:8080 example.com/path/here example.com?query=something example.com#fragment", (String[])new String[]{"example.com:8080", "example.com/path/here", "example.com?query=something", "example.com#fragment"}, (String[])new String[]{"<URL>", "<URL>", "<URL>", "<URL>"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"example.com:8080/path/here?query=something#fragment", (String[])new String[]{"example.com:8080/path/here?query=something#fragment"}, (String[])new String[]{"<URL>"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"example.com:8080/path/here?query=something", (String[])new String[]{"example.com:8080/path/here?query=something"}, (String[])new String[]{"<URL>"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"example.com:8080/path/here#fragment", (String[])new String[]{"example.com:8080/path/here#fragment"}, (String[])new String[]{"<URL>"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"example.com:8080/path/here", (String[])new String[]{"example.com:8080/path/here"}, (String[])new String[]{"<URL>"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"example.com:8080?query=something#fragment", (String[])new String[]{"example.com:8080?query=something#fragment"}, (String[])new String[]{"<URL>"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"example.com:8080?query=something", (String[])new String[]{"example.com:8080?query=something"}, (String[])new String[]{"<URL>"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"example.com:8080#fragment", (String[])new String[]{"example.com:8080#fragment"}, (String[])new String[]{"<URL>"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"example.com/path/here?query=something#fragment", (String[])new String[]{"example.com/path/here?query=something#fragment"}, (String[])new String[]{"<URL>"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"example.com/path/here?query=something", (String[])new String[]{"example.com/path/here?query=something"}, (String[])new String[]{"<URL>"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"example.com/path/here#fragment", (String[])new String[]{"example.com/path/here#fragment"}, (String[])new String[]{"<URL>"});
        BaseTokenStreamTestCase.assertAnalyzesTo((Analyzer)this.a, (String)"example.com?query=something#fragment", (String[])new String[]{"example.com?query=something#fragment"}, (String[])new String[]{"<URL>"});
    }

    public void testRandomStrings() throws Exception {
        TestUAX29URLEmailAnalyzer.checkRandomData((Random)TestUAX29URLEmailAnalyzer.random(), (Analyzer)this.a, (int)(1000 * RANDOM_MULTIPLIER));
    }

    public void testMaxTokenLengthDefault() throws Exception {
        StringBuilder bToken = new StringBuilder();
        for (int i = 0; i < 255; ++i) {
            bToken.append('b');
        }
        String bString = bToken.toString();
        String input = "x " + bString + " " + bString + "b";
        TestUAX29URLEmailAnalyzer.assertAnalyzesTo((Analyzer)this.a, (String)input.toString(), (String[])new String[]{"x", bString, bString, "b"});
        this.a.close();
    }

    public void testMaxTokenLengthNonDefault() throws Exception {
        UAX29URLEmailAnalyzer a = new UAX29URLEmailAnalyzer();
        a.setMaxTokenLength(5);
        TestUAX29URLEmailAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"ab cd toolong xy z", (String[])new String[]{"ab", "cd", "toolo", "ng", "xy", "z"});
        a.close();
    }
}

