/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestUAX29URLEmailTokenizerFactory
extends BaseTokenStreamFactoryTestCase {
    public void testUAX29URLEmailTokenizer() throws Exception {
        StringReader reader = new StringReader("Wha\u0301t's this thing do?");
        Tokenizer stream = this.tokenizerFactory("UAX29URLEmail", new String[0]).create(TestUAX29URLEmailTokenizerFactory.newAttributeFactory());
        stream.setReader((Reader)reader);
        TestUAX29URLEmailTokenizerFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"Wha\u0301t's", "this", "thing", "do"});
    }

    public void testArabic() throws Exception {
        StringReader reader = new StringReader("\u0627\u0644\u0641\u064a\u0644\u0645 \u0627\u0644\u0648\u062b\u0627\u0626\u0642\u064a \u0627\u0644\u0623\u0648\u0644 \u0639\u0646 \u0648\u064a\u0643\u064a\u0628\u064a\u062f\u064a\u0627 \u064a\u0633\u0645\u0649 \"\u0627\u0644\u062d\u0642\u064a\u0642\u0629 \u0628\u0627\u0644\u0623\u0631\u0642\u0627\u0645: \u0642\u0635\u0629 \u0648\u064a\u0643\u064a\u0628\u064a\u062f\u064a\u0627\" (\u0628\u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629: Truth in Numbers: The Wikipedia Story)\u060c \u0633\u064a\u062a\u0645 \u0625\u0637\u0644\u0627\u0642\u0647 \u0641\u064a 2008.");
        Tokenizer stream = this.tokenizerFactory("UAX29URLEmail", new String[0]).create(TestUAX29URLEmailTokenizerFactory.newAttributeFactory());
        stream.setReader((Reader)reader);
        TestUAX29URLEmailTokenizerFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"\u0627\u0644\u0641\u064a\u0644\u0645", "\u0627\u0644\u0648\u062b\u0627\u0626\u0642\u064a", "\u0627\u0644\u0623\u0648\u0644", "\u0639\u0646", "\u0648\u064a\u0643\u064a\u0628\u064a\u062f\u064a\u0627", "\u064a\u0633\u0645\u0649", "\u0627\u0644\u062d\u0642\u064a\u0642\u0629", "\u0628\u0627\u0644\u0623\u0631\u0642\u0627\u0645", "\u0642\u0635\u0629", "\u0648\u064a\u0643\u064a\u0628\u064a\u062f\u064a\u0627", "\u0628\u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629", "Truth", "in", "Numbers", "The", "Wikipedia", "Story", "\u0633\u064a\u062a\u0645", "\u0625\u0637\u0644\u0627\u0642\u0647", "\u0641\u064a", "2008"});
    }

    public void testChinese() throws Exception {
        StringReader reader = new StringReader("\u6211\u662f\u4e2d\u56fd\u4eba\u3002 \uff11\uff12\uff13\uff14 \uff34\uff45\uff53\uff54\uff53 ");
        Tokenizer stream = this.tokenizerFactory("UAX29URLEmail", new String[0]).create(TestUAX29URLEmailTokenizerFactory.newAttributeFactory());
        stream.setReader((Reader)reader);
        TestUAX29URLEmailTokenizerFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"\u6211", "\u662f", "\u4e2d", "\u56fd", "\u4eba", "\uff11\uff12\uff13\uff14", "\uff34\uff45\uff53\uff54\uff53"});
    }

    public void testKorean() throws Exception {
        StringReader reader = new StringReader("\uc548\ub155\ud558\uc138\uc694 \ud55c\uae00\uc785\ub2c8\ub2e4");
        Tokenizer stream = this.tokenizerFactory("UAX29URLEmail", new String[0]).create(TestUAX29URLEmailTokenizerFactory.newAttributeFactory());
        stream.setReader((Reader)reader);
        TestUAX29URLEmailTokenizerFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"\uc548\ub155\ud558\uc138\uc694", "\ud55c\uae00\uc785\ub2c8\ub2e4"});
    }

    public void testHyphen() throws Exception {
        StringReader reader = new StringReader("some-dashed-phrase");
        Tokenizer stream = this.tokenizerFactory("UAX29URLEmail", new String[0]).create(TestUAX29URLEmailTokenizerFactory.newAttributeFactory());
        stream.setReader((Reader)reader);
        TestUAX29URLEmailTokenizerFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"some", "dashed", "phrase"});
    }

    public void testURLs() throws Exception {
        String textWithURLs = "http://johno.jsmf.net/knowhow/ngrams/index.php?table=en-dickens-word-2gram&paragraphs=50&length=200&no-ads=on\n some extra\nWords thrown in here. http://c5-3486.bisynxu.FR/aI.YnNms/ samba Halta gamba ftp://119.220.152.185/JgJgdZ/31aW5c/viWlfQSTs5/1c8U5T/ih5rXx/YfUJ/xBW1uHrQo6.R\nM19nq.0URV4A.Me.CC/mj0kgt6hue/dRXv8YVLOw9v/CIOqb\nHttps://yu7v33rbt.vC6U3.XN--KPRW13D/y%4fMSzkGFlm/wbDF4m inter Locutio [c2d4::]/%471j5l/j3KFN%AAAn/Fip-NisKH/\nfile:///aXvSZS34is/eIgM8s~U5dU4Ifd%c7 blah Sirrah woof http://[a42:a7b6::]/qSmxSUU4z/%52qVl4\n";
        StringReader reader = new StringReader(textWithURLs);
        Tokenizer stream = this.tokenizerFactory("UAX29URLEmail", new String[0]).create(TestUAX29URLEmailTokenizerFactory.newAttributeFactory());
        stream.setReader((Reader)reader);
        TestUAX29URLEmailTokenizerFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"http://johno.jsmf.net/knowhow/ngrams/index.php?table=en-dickens-word-2gram&paragraphs=50&length=200&no-ads=on", "some", "extra", "Words", "thrown", "in", "here", "http://c5-3486.bisynxu.FR/aI.YnNms/", "samba", "Halta", "gamba", "ftp://119.220.152.185/JgJgdZ/31aW5c/viWlfQSTs5/1c8U5T/ih5rXx/YfUJ/xBW1uHrQo6.R", "M19nq.0URV4A.Me.CC/mj0kgt6hue/dRXv8YVLOw9v/CIOqb", "Https://yu7v33rbt.vC6U3.XN--KPRW13D/y%4fMSzkGFlm/wbDF4m", "inter", "Locutio", "[c2d4::]/%471j5l/j3KFN%AAAn/Fip-NisKH/", "file:///aXvSZS34is/eIgM8s~U5dU4Ifd%c7", "blah", "Sirrah", "woof", "http://[a42:a7b6::]/qSmxSUU4z/%52qVl4"});
    }

    public void testEmails() throws Exception {
        String textWithEmails = " some extra\nWords thrown in here. dJ8ngFi@avz13m.CC\nkU-l6DS@[082.015.228.189]\n\"%U\u0012@?\\B\"@Fl2d.md samba Halta gamba Bvd#@tupjv.sn\nSBMm0Nm.oyk70.rMNdd8k.#ru3LI.gMMLBI.0dZRD4d.RVK2nY@au58t.B13albgy4u.mt\n~+Kdz@3mousnl.SE\n inter Locutio C'ts`@Vh4zk.uoafcft-dr753x4odt04q.UY\n}0tzWYDBuy@cSRQAABB9B.7c8xawf75-cyo.PM blah Sirrah woof lMahAA.j/5.RqUjS745.DtkcYdi@d2-4gb-l6.ae\nlv'p@tqk.vj5s0tgl.0dlu7su3iyiaz.dqso.494.3hb76.XN--MGBAAM7A8H\n";
        StringReader reader = new StringReader(textWithEmails);
        Tokenizer stream = this.tokenizerFactory("UAX29URLEmail", new String[0]).create(TestUAX29URLEmailTokenizerFactory.newAttributeFactory());
        stream.setReader((Reader)reader);
        TestUAX29URLEmailTokenizerFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"some", "extra", "Words", "thrown", "in", "here", "dJ8ngFi@avz13m.CC", "kU-l6DS@[082.015.228.189]", "\"%U\u0012@?\\B\"@Fl2d.md", "samba", "Halta", "gamba", "Bvd#@tupjv.sn", "SBMm0Nm.oyk70.rMNdd8k.#ru3LI.gMMLBI.0dZRD4d.RVK2nY@au58t.B13albgy4u.mt", "~+Kdz@3mousnl.SE", "inter", "Locutio", "C'ts`@Vh4zk.uoafcft-dr753x4odt04q.UY", "}0tzWYDBuy@cSRQAABB9B.7c8xawf75-cyo.PM", "blah", "Sirrah", "woof", "lMahAA.j/5.RqUjS745.DtkcYdi@d2-4gb-l6.ae", "lv'p@tqk.vj5s0tgl.0dlu7su3iyiaz.dqso.494.3hb76.XN--MGBAAM7A8H"});
    }

    public void testMaxTokenLength() throws Exception {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            builder.append("abcdefg");
        }
        String longWord = builder.toString();
        String content = "one two three " + longWord + " four five six";
        StringReader reader = new StringReader(content);
        Tokenizer stream = this.tokenizerFactory("UAX29URLEmail", "maxTokenLength", "1000").create(TestUAX29URLEmailTokenizerFactory.newAttributeFactory());
        stream.setReader((Reader)reader);
        TestUAX29URLEmailTokenizerFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"one", "two", "three", longWord, "four", "five", "six"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestUAX29URLEmailTokenizerFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenizerFactory("UAX29URLEmail", "bogusArg", "bogusValue"));
        TestUAX29URLEmailTokenizerFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }

    public void testIllegalArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestUAX29URLEmailTokenizerFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenizerFactory("UAX29URLEmail", "maxTokenLength", "-1").create());
        TestUAX29URLEmailTokenizerFactory.assertTrue((boolean)expected.getMessage().contains("maxTokenLength must be greater than zero"));
    }
}

